/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.intmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.intmatrix.IntMatrix;
import org.ujmp.core.intmatrix.calculation.IntCalculation;
import org.ujmp.core.intmatrix.impl.IntCalculationMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;

public abstract class AbstractIntCalculation
extends AbstractCalculation
implements IntCalculation {
    private static final long serialVersionUID = 960721543868612950L;

    public AbstractIntCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractIntCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    @Override
    public final IntMatrix calcLink() {
        return new IntCalculationMatrix(this);
    }

    @Override
    public final IntMatrix calcNew() {
        IntMatrix result = (IntMatrix)Matrix.Factory.zeros(ValueType.INT, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsInt(this.getInt(c), c);
        }
        if (this.getMetaData() != null) {
            result.setMetaData((MapMatrix<String, Object>)this.getMetaData().clone());
        }
        return result;
    }

    @Override
    public final Matrix calcOrig() {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new RuntimeException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsInt(this.getInt(c), c);
        }
        this.getSource().fireValueChanged();
        return this.getSource();
    }

    @Override
    public void setInt(int value, long ... coordinates) {
    }

    @Override
    public final ValueType getValueType() {
        return ValueType.INT;
    }
}

