/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.importer;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.importer.AbstractMatrixFileImporter;
import org.ujmp.core.importer.format.MatrixBMPImportFormat;
import org.ujmp.core.importer.format.MatrixDenseCSVImportFormat;
import org.ujmp.core.importer.format.MatrixGIFImportFormat;
import org.ujmp.core.importer.format.MatrixJPGImportFormat;
import org.ujmp.core.importer.format.MatrixPDFImportFormat;
import org.ujmp.core.importer.format.MatrixPNGImportFormat;
import org.ujmp.core.importer.format.MatrixTIFFImportFormat;
import org.ujmp.core.intmatrix.impl.ImageMatrix;
import org.ujmp.core.stringmatrix.impl.DenseCSVStringMatrix2D;

public class DefaultMatrixFileImporter
extends AbstractMatrixFileImporter
implements MatrixJPGImportFormat,
MatrixPNGImportFormat,
MatrixBMPImportFormat,
MatrixGIFImportFormat,
MatrixTIFFImportFormat,
MatrixDenseCSVImportFormat,
MatrixPDFImportFormat {
    public DefaultMatrixFileImporter(Matrix matrix, File file) {
        super(matrix, file);
    }

    @Override
    public Matrix asJPG() throws IOException {
        ImageMatrix tmp = new ImageMatrix(this.getFile());
        if (this.getTargetMatrix() == null) {
            return tmp;
        }
        this.getTargetMatrix().setContent(Calculation.Ret.ORIG, tmp, 0L, 0L);
        return this.getTargetMatrix();
    }

    @Override
    public Matrix asGIF() throws IOException {
        ImageMatrix tmp = new ImageMatrix(this.getFile());
        if (this.getTargetMatrix() == null) {
            return tmp;
        }
        this.getTargetMatrix().setContent(Calculation.Ret.ORIG, tmp, 0L, 0L);
        return this.getTargetMatrix();
    }

    @Override
    public Matrix asTIFF() throws IOException {
        ImageMatrix tmp = new ImageMatrix(this.getFile());
        if (this.getTargetMatrix() == null) {
            return tmp;
        }
        this.getTargetMatrix().setContent(Calculation.Ret.ORIG, tmp, 0L, 0L);
        return this.getTargetMatrix();
    }

    @Override
    public Matrix asBMP() throws IOException {
        ImageMatrix tmp = new ImageMatrix(this.getFile());
        if (this.getTargetMatrix() == null) {
            return tmp;
        }
        this.getTargetMatrix().setContent(Calculation.Ret.ORIG, tmp, 0L, 0L);
        return this.getTargetMatrix();
    }

    @Override
    public Matrix asPNG() throws IOException {
        ImageMatrix tmp = new ImageMatrix(this.getFile());
        if (this.getTargetMatrix() == null) {
            return tmp;
        }
        this.getTargetMatrix().setContent(Calculation.Ret.ORIG, tmp, 0L, 0L);
        return this.getTargetMatrix();
    }

    @Override
    public Matrix asDenseCSV() throws IOException {
        return this.asDenseCSV('\t');
    }

    @Override
    public Matrix asDenseCSV(char columnSeparator) throws IOException {
        return this.asDenseCSV(columnSeparator, '\u0000');
    }

    @Override
    public Matrix asDenseCSV(char columnSeparator, char enclosingCharacter) throws IOException {
        DenseCSVStringMatrix2D tmp = new DenseCSVStringMatrix2D(this.getFile());
        if (this.getTargetMatrix() == null) {
            return tmp;
        }
        this.getTargetMatrix().setContent(Calculation.Ret.ORIG, tmp, 0L, 0L);
        return this.getTargetMatrix();
    }

    @Override
    public Matrix asPDF() throws IOException {
        try {
            Class<?> c = Class.forName("org.ujmp.pdfbox.ImportMatrixPDF");
            Method m = c.getMethod("fromFile", File.class);
            Matrix matrix = (Matrix)m.invoke(null, this.getFile());
            return matrix;
        }
        catch (Exception e) {
            throw new IOException("could not import PDF", e);
        }
    }
}

