/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.genericmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.genericmatrix.stub.AbstractDenseGenericMatrix2D;

public class DefaultDenseGenericMatrix2D<A>
extends AbstractDenseGenericMatrix2D<A> {
    private static final long serialVersionUID = 3132491298449205914L;
    private final Object[][] values;

    public DefaultDenseGenericMatrix2D(Matrix m) {
        super(m.getRowCount(), m.getColumnCount());
        this.values = new Object[(int)m.getRowCount()][(int)m.getColumnCount()];
        for (long[] c : m.allCoordinates()) {
            this.setAsObject(m.getAsObject(c), c);
        }
    }

    public DefaultDenseGenericMatrix2D(A[][] values) {
        super((long)values.length, (long)values[0].length);
        this.values = values;
    }

    public DefaultDenseGenericMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.values = new Object[rows][columns];
    }

    @Override
    public A getObject(long row, long column) {
        return (A)this.values[(int)row][(int)column];
    }

    @Override
    public void setObject(Object value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    @Override
    public A getObject(int row, int column) {
        return (A)this.values[row][column];
    }

    @Override
    public void setObject(A value, int row, int column) {
        this.values[row][column] = value;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.OBJECT;
    }
}

