/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.export.exporter;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DoubleMatrix;
import org.ujmp.core.enums.DBType;
import org.ujmp.core.export.exporter.AbstractMatrixWriterExporter;
import org.ujmp.core.export.format.MatrixSQLExportFormat;
import org.ujmp.core.floatmatrix.FloatMatrix;
import org.ujmp.core.intmatrix.IntMatrix;
import org.ujmp.core.longmatrix.LongMatrix;
import org.ujmp.core.stringmatrix.StringMatrix;

public class DefaultMatrixWriterSQLExporter
extends AbstractMatrixWriterExporter
implements MatrixSQLExportFormat {
    public DefaultMatrixWriterSQLExporter(Matrix matrix, Writer writer) {
        super(matrix, writer);
    }

    @Override
    public void asSQL(DBType db, String databaseName, String tableName) throws IOException {
        String EOL = System.getProperty("line.separator");
        Matrix matrix = this.getMatrix();
        Writer writer = this.getWriter();
        writer.write("CREATE DATABASE IF NOT EXISTS `" + databaseName + "`;" + EOL);
        writer.write("USE `" + databaseName + "`;" + EOL);
        writer.write("CREATE TABLE IF NOT EXISTS `" + tableName + "` (");
        int c = 0;
        while ((long)c < matrix.getColumnCount()) {
            writer.write("`" + DefaultMatrixWriterSQLExporter.getColumnName(matrix, c) + "` ");
            writer.write(DefaultMatrixWriterSQLExporter.getColumnType(db, matrix, c));
            if ((long)c < matrix.getColumnCount() - 1L) {
                writer.write(", ");
            }
            ++c;
        }
        writer.write(");" + EOL);
        writer.write("INSERT IGNORE INTO `" + tableName + "` (");
        c = 0;
        while ((long)c < matrix.getColumnCount()) {
            writer.write("`" + DefaultMatrixWriterSQLExporter.getColumnName(matrix, c) + "`");
            if ((long)c < matrix.getColumnCount() - 1L) {
                writer.write(", ");
            }
            ++c;
        }
        writer.write(") VALUES ");
        int r = 0;
        while ((long)r < matrix.getRowCount()) {
            writer.write("(");
            int c2 = 0;
            while ((long)c2 < matrix.getColumnCount()) {
                writer.write(DefaultMatrixWriterSQLExporter.encodeData(matrix.getAsObject(r, c2)));
                if ((long)c2 < matrix.getColumnCount() - 1L) {
                    writer.write(", ");
                }
                ++c2;
            }
            if ((long)r < matrix.getRowCount() - 1L) {
                writer.write("), ");
            }
            ++r;
        }
        writer.write(");" + EOL);
        writer.close();
    }

    private static String encodeData(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Number) {
            return o.toString();
        }
        return "'" + o + "'";
    }

    private static final String getColumnName(Matrix matrix, long column) {
        String columnName = matrix.getColumnLabel(column);
        if (columnName == null || columnName.length() == 0) {
            columnName = "column " + column;
        }
        return columnName;
    }

    private static final String getIntType(DBType db) {
        if (db == DBType.MySQL) {
            return "INT";
        }
        return "TEXT";
    }

    private static final String getLongType(DBType db) {
        if (db == DBType.MySQL) {
            return "BIGINT";
        }
        return "TEXT";
    }

    private static final String getFloatType(DBType db) {
        if (db == DBType.MySQL) {
            return "DOUBLE";
        }
        return "TEXT";
    }

    private static final String getDoubleType(DBType db) {
        if (db == DBType.MySQL) {
            return "DOUBLE";
        }
        return "TEXT";
    }

    private static final String getByteArrayType(DBType db) {
        if (db == DBType.MySQL) {
            return "BLOB";
        }
        return "TEXT";
    }

    private static final String getBigIntType(DBType db) {
        if (db == DBType.MySQL) {
            return "BIGINT";
        }
        return "TEXT";
    }

    private static final String getBigDecimalType(DBType db) {
        if (db == DBType.MySQL) {
            return "DOUBLE";
        }
        return "TEXT";
    }

    private static final String getStringType(DBType db) {
        if (db == DBType.MySQL) {
            return "TEXT";
        }
        return "TEXT";
    }

    private static final String getColumnType(DBType db, Matrix matrix, long column) {
        if (matrix instanceof StringMatrix) {
            return DefaultMatrixWriterSQLExporter.getStringType(db);
        }
        if (matrix instanceof IntMatrix) {
            return DefaultMatrixWriterSQLExporter.getIntType(db);
        }
        if (matrix instanceof LongMatrix) {
            return DefaultMatrixWriterSQLExporter.getLongType(db);
        }
        if (matrix instanceof FloatMatrix) {
            return DefaultMatrixWriterSQLExporter.getFloatType(db);
        }
        if (matrix instanceof DoubleMatrix) {
            return DefaultMatrixWriterSQLExporter.getDoubleType(db);
        }
        int r = 0;
        while ((long)r < matrix.getRowCount()) {
            Object o = matrix.getAsObject(r, column);
            if (o instanceof String) {
                return DefaultMatrixWriterSQLExporter.getStringType(db);
            }
            if (o instanceof Integer) {
                return DefaultMatrixWriterSQLExporter.getIntType(db);
            }
            if (o instanceof Long) {
                return DefaultMatrixWriterSQLExporter.getLongType(db);
            }
            if (o instanceof Float) {
                return DefaultMatrixWriterSQLExporter.getFloatType(db);
            }
            if (o instanceof Double) {
                return DefaultMatrixWriterSQLExporter.getDoubleType(db);
            }
            if (o instanceof BigInteger) {
                return DefaultMatrixWriterSQLExporter.getBigIntType(db);
            }
            if (o instanceof BigDecimal) {
                return DefaultMatrixWriterSQLExporter.getBigDecimalType(db);
            }
            if (o instanceof byte[]) {
                return DefaultMatrixWriterSQLExporter.getByteArrayType(db);
            }
            ++r;
        }
        return DefaultMatrixWriterSQLExporter.getStringType(db);
    }
}

