/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.export.destination;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.ujmp.core.Matrix;
import org.ujmp.core.enums.DBType;
import org.ujmp.core.export.destination.AbstractMatrixStreamExportDestination;
import org.ujmp.core.export.exporter.DefaultMatrixWriterCSVExporter;
import org.ujmp.core.export.exporter.DefaultMatrixWriterLatexExporter;
import org.ujmp.core.export.exporter.DefaultMatrixWriterMatlabScriptExporter;
import org.ujmp.core.export.exporter.DefaultMatrixWriterRScriptExporter;
import org.ujmp.core.export.exporter.DefaultMatrixWriterSQLExporter;

public class DefaultMatrixStreamExportDestination
extends AbstractMatrixStreamExportDestination {
    public DefaultMatrixStreamExportDestination(Matrix matrix, OutputStream outputStream) {
        super(matrix, outputStream);
    }

    @Override
    public void asDenseCSV(char columnSeparator, char enclosingCharacter) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.getOutputStream());
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        new DefaultMatrixWriterCSVExporter(this.getMatrix(), bufferedWriter).asDenseCSV(columnSeparator, enclosingCharacter);
        bufferedWriter.close();
        outputStreamWriter.close();
    }

    @Override
    public void asDenseCSV(char columnSeparator) throws IOException {
        this.asDenseCSV(columnSeparator, '\u0000');
    }

    @Override
    public void asDenseCSV() throws IOException {
        this.asDenseCSV('\t');
    }

    @Override
    public void asSQL(DBType db, String databaseName, String tableName) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.getOutputStream());
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        new DefaultMatrixWriterSQLExporter(this.getMatrix(), bufferedWriter).asSQL(db, databaseName, tableName);
        bufferedWriter.close();
        outputStreamWriter.close();
    }

    @Override
    public void asMatlabScript(String variableName) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.getOutputStream());
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        new DefaultMatrixWriterMatlabScriptExporter(this.getMatrix(), bufferedWriter).asMatlabScript(variableName);
        bufferedWriter.close();
        outputStreamWriter.close();
    }

    @Override
    public void asRScript(String variableName) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.getOutputStream());
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        new DefaultMatrixWriterRScriptExporter(this.getMatrix(), bufferedWriter).asRScript(variableName);
        bufferedWriter.close();
        outputStreamWriter.close();
    }

    @Override
    public void asLatex() throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.getOutputStream());
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        new DefaultMatrixWriterLatexExporter(this.getMatrix(), bufferedWriter).asLatex();
        bufferedWriter.close();
        outputStreamWriter.close();
    }
}

