/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.impl;

import org.ujmp.core.collections.Dictionary;
import org.ujmp.core.doublematrix.stub.AbstractSparseDoubleMatrix2D;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;

public class SparseFeatureVector
extends AbstractSparseDoubleMatrix2D {
    private static final long serialVersionUID = -4011983790653257058L;
    private final Dictionary dictionary;
    private final MapMatrix<String, Double> values = new DefaultMapMatrix<String, Double>();

    public SparseFeatureVector(Dictionary dictionary) {
        super(0L, 1L);
        this.dictionary = dictionary;
    }

    @Override
    public final Iterable<long[]> availableCoordinates() {
        return this.allCoordinates();
    }

    @Override
    public double getDouble(long row, long column) {
        return this.getDouble(MathUtil.longToInt(row), MathUtil.longToInt(column));
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.setDouble(value, MathUtil.longToInt(row), MathUtil.longToInt(column));
    }

    @Override
    public double getDouble(int row, int column) {
        String featureName = (String)this.dictionary.get(row);
        return this.getFeatureValue(featureName);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        String featureName = (String)this.dictionary.get(row);
        this.setFeatureValue(featureName, value);
    }

    @Override
    public boolean containsCoordinates(long ... coordinates) {
        String featureName = (String)this.dictionary.get(MathUtil.longToInt(coordinates[0]));
        return this.hasFeature(featureName);
    }

    public boolean hasFeature(String featureName) {
        return this.getFeatureValue(featureName) != 0.0;
    }

    @Override
    public long[] getSize() {
        this.size[0] = this.dictionary.size();
        return this.size;
    }

    public double getFeatureValue(String featureName) {
        Double value = (Double)this.values.get(featureName);
        return value == null ? 0.0 : value;
    }

    public void setFeatureValue(String featureName, double value) {
        this.dictionary.add(featureName);
        if (value == 0.0) {
            this.values.remove(featureName);
        } else {
            this.values.put(featureName, value);
        }
    }

    @Override
    public final void clear() {
        this.values.clear();
    }
}

