/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.impl;

import java.io.Serializable;
import java.util.Arrays;
import org.ujmp.core.doublematrix.impl.BlockDenseDoubleMatrix2D;

public final class BlockMatrixLayout
implements Serializable {
    private static final long serialVersionUID = 2726685238884065594L;
    protected final int blockArea;
    public final int blockStripe;
    public final int columns;
    public final BlockOrder blockOrder;
    final int numberOfBlocks;
    private final boolean rowMajor;
    public final int rows;
    private final int sqbColThreshold;
    private final int sqbRowThreshold;

    BlockMatrixLayout(int rows, int columns, int blockStripe, BlockOrder blockOrder) {
        this.blockStripe = blockStripe;
        if (rows <= 0 || columns <= 0 || blockStripe <= 0) {
            throw new IllegalArgumentException(String.format("One or more invalid values: rows=%s, columns=%s, blockSize=%s", rows, columns, blockStripe));
        }
        this.blockArea = blockStripe * blockStripe;
        this.rows = rows;
        this.columns = columns;
        this.sqbColThreshold = columns / blockStripe * blockStripe;
        this.sqbRowThreshold = rows / blockStripe * blockStripe;
        this.blockOrder = blockOrder;
        this.rowMajor = blockOrder == BlockOrder.ROWMAJOR;
        this.numberOfBlocks = (rows / blockStripe + (rows % blockStripe > 0 ? 1 : 0)) * (columns / blockStripe + (columns % blockStripe > 0 ? 1 : 0));
    }

    final double[] getBlock(BlockDenseDoubleMatrix2D matrix, int row, int column) {
        return matrix.getBlockData(row, column);
    }

    final int getBlockIndexByColumn(int lrow, int lcol, int numRows, int numCols) {
        return this.rowMajor ? lcol * numRows + lrow : lrow * numCols + lcol;
    }

    final int getBlockIndexByRow(int lrow, int lcol, int numRows, int numCols) {
        return this.rowMajor ? lrow * numCols + lcol : lcol * numRows + lrow;
    }

    final int getBlockNumber(int row, int col) {
        return col / this.blockStripe + row / this.blockStripe * (this.columns / this.blockStripe + (this.columns % this.blockStripe > 0 ? 1 : 0));
    }

    final int getIndexInBlock(int row, int col) {
        int lrows = this.getRowsInBlock(row);
        int lcols = this.getColumnsInBlock(col);
        return this.getBlockIndexByRow(row % this.blockStripe, col % this.blockStripe, lrows, lcols);
    }

    final int getBlockSize(int row, int col) {
        int lrows = this.getRowsInBlock(row);
        int lcols = this.getColumnsInBlock(col);
        return lrows * lcols;
    }

    final double[] toColMajorBlock(BlockDenseDoubleMatrix2D matrix, int rowStart, int colStart) {
        double[] block = this.getBlock(matrix, rowStart, colStart);
        if (!this.rowMajor) {
            return block;
        }
        return this.toColMajorBlock(block, rowStart, colStart);
    }

    final double[] toColMajorBlock(double[] block, int rowStart, int colStart) {
        double[] targetBlock = new double[block.length];
        int lrows = this.getRowsInBlock(rowStart);
        int lcols = this.getColumnsInBlock(colStart);
        for (int i = 0; i < lcols; ++i) {
            int ilrows = i * lrows;
            for (int j = 0; j < lrows; ++j) {
                targetBlock[ilrows + j] = block[j * lcols + i];
            }
        }
        return targetBlock;
    }

    int getColumnsInBlock(int col) {
        return col >= this.sqbColThreshold ? this.columns - this.sqbColThreshold : this.blockStripe;
    }

    int getRowsInBlock(int row) {
        return row >= this.sqbRowThreshold ? this.rows - this.sqbRowThreshold : this.blockStripe;
    }

    final double[] toRowMajorBlock(BlockDenseDoubleMatrix2D matrix, int rowStart, int colStart) {
        double[] block = this.getBlock(matrix, rowStart, colStart);
        if (this.rowMajor) {
            return block;
        }
        return this.toRowMajorBlock(block, rowStart, colStart);
    }

    final double[] toRowMajorBlock(double[] block, int rowStart, int colStart) {
        double[] targetBlock = new double[block.length];
        int lrows = this.getRowsInBlock(rowStart);
        int lcols = this.getColumnsInBlock(colStart);
        for (int i = 0; i < lrows; ++i) {
            int ilcols = i * lcols;
            for (int j = 0; j < lcols; ++j) {
                targetBlock[ilcols + j] = block[j * lrows + i];
            }
        }
        return targetBlock;
    }

    public String toString() {
        int[] rowLayout = new int[this.blockStripe];
        StringBuilder b = new StringBuilder(this.blockArea * 4 + 40);
        String msg = "\n(rows=%s, columns=%s, blockSize=%s):\n";
        b.append(String.format(msg, this.rows, this.columns, this.blockStripe));
        int rows = this.blockStripe;
        int cols = this.blockStripe;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                rowLayout[j] = this.getBlockIndexByRow(i, j, rows, cols);
            }
            b.append(Arrays.toString(rowLayout)).append("\n");
        }
        return b.toString();
    }

    public static enum BlockOrder {
        ROWMAJOR,
        COLUMNMAJOR;


        public BlockOrder transpose() {
            return this == ROWMAJOR ? COLUMNMAJOR : ROWMAJOR;
        }
    }
}

