/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.statistical;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;

public class Prod
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 932987805882530211L;
    boolean ignoreNaN = false;

    public Prod(int dimension, boolean ignoreNaN, Matrix matrix) {
        super(dimension, matrix);
        this.ignoreNaN = ignoreNaN;
        MapMatrix<String, Object> aold = matrix.getMetaData();
        if (aold != null) {
            DefaultMapMatrix<String, Object> a = new DefaultMapMatrix<String, Object>();
            a.put("Label", aold.get("Label"));
            if (dimension == 0 || dimension == 1) {
                // empty if block
            }
            this.setMetaData(a);
        }
    }

    @Override
    public double getDouble(long ... coordinates) {
        double prod = 1.0;
        if (this.ignoreNaN) {
            switch (this.getDimension()) {
                case 0: {
                    for (long r = this.getSource().getSize()[0] - 1L; r != -1L; --r) {
                        double v = this.getSource().getAsDouble(r, coordinates[1]);
                        if (MathUtil.isNaNOrInfinite(v)) continue;
                        prod *= v;
                    }
                    return prod;
                }
                case 1: {
                    for (long c = this.getSource().getSize()[1] - 1L; c != -1L; --c) {
                        double v = this.getSource().getAsDouble(coordinates[0], c);
                        if (MathUtil.isNaNOrInfinite(v)) continue;
                        prod *= v;
                    }
                    return prod;
                }
                case 0x7FFFFFFF: {
                    for (long r = this.getSource().getSize()[0] - 1L; r != -1L; --r) {
                        for (long c = this.getSource().getSize()[1] - 1L; c != -1L; --c) {
                            double v = this.getSource().getAsDouble(r, c);
                            if (MathUtil.isNaNOrInfinite(v)) continue;
                            prod *= v;
                        }
                    }
                    return prod;
                }
            }
            throw new RuntimeException("dimension not allowed");
        }
        switch (this.getDimension()) {
            case 0: {
                long r = this.getSource().getSize()[0] - 1L;
                while (r != -1L) {
                    prod *= this.getSource().getAsDouble(r--, coordinates[1]);
                }
                return prod;
            }
            case 1: {
                long c = this.getSource().getSize()[1] - 1L;
                while (c != -1L) {
                    prod *= this.getSource().getAsDouble(coordinates[0], c--);
                }
                return prod;
            }
            case 0x7FFFFFFF: {
                for (long r = this.getSource().getSize()[0] - 1L; r != -1L; --r) {
                    long c = this.getSource().getSize()[1] - 1L;
                    while (c != -1L) {
                        prod *= this.getSource().getAsDouble(r, c--);
                    }
                }
                return prod;
            }
        }
        throw new RuntimeException("dimension not allowed");
    }

    @Override
    public long[] getSize() {
        switch (this.getDimension()) {
            case 0: {
                return new long[]{1L, this.getSource().getSize()[1]};
            }
            case 1: {
                return new long[]{this.getSource().getSize()[0], 1L};
            }
            case 0x7FFFFFFF: {
                return new long[]{1L, 1L};
            }
        }
        return null;
    }
}

