/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.statistical;

import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.DoubleMatrix2D;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.statistical.Mean;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.concurrent.PFor;

public class Cov
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -2100820298353936855L;
    private Matrix mean = null;
    private boolean ignoreNaN = false;
    private boolean besselsCorrection = true;
    private final long[] size = new long[]{this.getSource().getColumnCount(), this.getSource().getColumnCount()};

    public Cov(boolean ignoreNaN, Matrix matrix, boolean besselsCorrection) {
        super(matrix);
        this.ignoreNaN = ignoreNaN;
        this.besselsCorrection = besselsCorrection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(long ... coordinates) {
        int i;
        double sumProd = 0.0;
        long rows = this.getSource().getRowCount();
        long N = 0L;
        double deltaX = 0.0;
        double deltaY = 0.0;
        if (this.mean == null) {
            Cov cov = this;
            synchronized (cov) {
                if (this.mean == null) {
                    this.mean = new Mean(0, this.ignoreNaN, this.getSource()).calc(Calculation.Ret.NEW);
                }
            }
        }
        if (this.ignoreNaN) {
            i = 0;
            while ((long)i < rows) {
                deltaX = this.getSource().getAsDouble(i, coordinates[0]) - this.mean.getAsDouble(0L, coordinates[0]);
                deltaY = this.getSource().getAsDouble(i, coordinates[1]) - this.mean.getAsDouble(0L, coordinates[1]);
                if (!MathUtil.isNaNOrInfinite(deltaX) && !MathUtil.isNaNOrInfinite(deltaY)) {
                    ++N;
                    sumProd += deltaX * deltaY;
                }
                ++i;
            }
        } else {
            N = rows;
            i = 0;
            while ((long)i < rows) {
                deltaX = this.getSource().getAsDouble(i, coordinates[0]) - this.mean.getAsDouble(0L, coordinates[0]);
                deltaY = this.getSource().getAsDouble(i, coordinates[1]) - this.mean.getAsDouble(0L, coordinates[1]);
                sumProd += deltaX * deltaY;
                ++i;
            }
        }
        double cov = Double.NaN;
        if (N > 0L) {
            cov = this.besselsCorrection ? sumProd / (double)(N - 1L) : sumProd / (double)N;
        }
        return cov;
    }

    @Override
    public long[] getSize() {
        return this.size;
    }

    @Override
    public Matrix calcNew() {
        final int count = MathUtil.longToInt(this.getSize()[0]);
        final DenseDoubleMatrix2D result = DoubleMatrix2D.Factory.zeros((long)count, (long)count);
        new PFor(0, count - 1){

            @Override
            public void step(int i) {
                for (int c = 0; c < count && c <= i; ++c) {
                    double value = Cov.this.getDouble(i, c);
                    result.setAsDouble(value, i, c);
                    result.setAsDouble(value, c, i);
                }
            }
        };
        if (this.getMetaData() != null) {
            result.setMetaData((MapMatrix<String, Object>)this.getMetaData().clone());
        }
        return result;
    }
}

