/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.statistical;

import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.statistical.Mean;
import org.ujmp.core.util.MathUtil;

public class Corrcoef
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 879653499852789474L;
    private Matrix mean = null;
    private boolean ignoreNaN = false;
    private boolean besselsCorrection = true;

    public Corrcoef(boolean ignoreNaN, Matrix matrix, boolean besselsCorrection) {
        super(matrix);
        this.ignoreNaN = ignoreNaN;
        this.besselsCorrection = besselsCorrection;
    }

    @Override
    public double getDouble(long ... coordinates) {
        int i;
        double sumSqX = 0.0;
        double sumSqY = 0.0;
        double sumProd = 0.0;
        double deltaX = 0.0;
        double deltaY = 0.0;
        long rows = this.getSource().getRowCount();
        long N = 0L;
        if (this.ignoreNaN && coordinates[0] == coordinates[1]) {
            return 1.0;
        }
        if (this.mean == null) {
            this.mean = new Mean(0, this.ignoreNaN, this.getSource()).calc(Calculation.Ret.NEW);
        }
        if (this.ignoreNaN) {
            i = 0;
            while ((long)i < rows) {
                deltaX = this.getSource().getAsDouble(i, coordinates[0]) - this.mean.getAsDouble(0L, coordinates[0]);
                deltaY = this.getSource().getAsDouble(i, coordinates[1]) - this.mean.getAsDouble(0L, coordinates[1]);
                if (!MathUtil.isNaNOrInfinite(deltaX) && !MathUtil.isNaNOrInfinite(deltaY)) {
                    ++N;
                    sumSqX += deltaX * deltaX;
                    sumSqY += deltaY * deltaY;
                    sumProd += deltaX * deltaY;
                }
                ++i;
            }
        } else {
            N = rows;
            i = 0;
            while ((long)i < rows) {
                deltaX = this.getSource().getAsDouble(i, coordinates[0]) - this.mean.getAsDouble(0L, coordinates[0]);
                deltaY = this.getSource().getAsDouble(i, coordinates[1]) - this.mean.getAsDouble(0L, coordinates[1]);
                sumSqX += deltaX * deltaX;
                sumSqY += deltaY * deltaY;
                sumProd += deltaX * deltaY;
                ++i;
            }
        }
        double div = N;
        if (this.besselsCorrection) {
            div = N - 1L;
        }
        double sdX = Math.sqrt(sumSqX / div);
        double sdY = Math.sqrt(sumSqY / div);
        double cov = sumProd / div;
        double corr = cov / (sdX * sdY);
        return corr;
    }

    @Override
    public long[] getSize() {
        return new long[]{this.getSource().getColumnCount(), this.getSource().getColumnCount()};
    }
}

