/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.decomposition;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.util.DecompositionOps;
import org.ujmp.core.util.UJMPSettings;

public interface Chol<T> {
    public static final int THRESHOLD = 100;
    public static final Chol<Matrix> MATRIX = new Chol<Matrix>(){

        @Override
        public final Matrix calc(Matrix source) {
            if (UJMPSettings.getInstance().getNumberOfThreads() == 1) {
                if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                    return MATRIXLARGESINGLETHREADED.calc(source);
                }
                return MATRIXSMALLSINGLETHREADED.calc(source);
            }
            if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                return MATRIXLARGEMULTITHREADED.calc(source);
            }
            return MATRIXSMALLMULTITHREADED.calc(source);
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            if (UJMPSettings.getInstance().getNumberOfThreads() == 1) {
                if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                    return MATRIXLARGESINGLETHREADED.solve(source, b);
                }
                return MATRIXSMALLSINGLETHREADED.solve(source, b);
            }
            if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                return MATRIXLARGEMULTITHREADED.solve(source, b);
            }
            return MATRIXSMALLMULTITHREADED.solve(source, b);
        }
    };
    public static final Chol<Matrix> INSTANCE = MATRIX;
    public static final Chol<Matrix> UJMP = new Chol<Matrix>(){

        @Override
        public final Matrix calc(Matrix source) {
            CholMatrix chol = new CholMatrix(source);
            return chol.getL();
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            CholMatrix chol = new CholMatrix(source);
            return chol.solve(b);
        }
    };
    public static final Chol<Matrix> MATRIXSMALLMULTITHREADED = UJMP;
    public static final Chol<Matrix> MATRIXSMALLSINGLETHREADED = UJMP;
    public static final Chol<Matrix> MATRIXLARGESINGLETHREADED = new Chol<Matrix>(){

        @Override
        public Matrix calc(Matrix source) {
            Chol chol = null;
            if (UJMPSettings.getInstance().isUseJBlas()) {
                chol = DecompositionOps.CHOL_JBLAS;
            }
            if (chol == null) {
                chol = UJMP;
            }
            return chol.calc(source);
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            Chol chol = null;
            if (UJMPSettings.getInstance().isUseJBlas()) {
                chol = DecompositionOps.CHOL_JBLAS;
            }
            if (chol == null) {
                chol = UJMP;
            }
            return chol.solve(source, b);
        }
    };
    public static final Chol<Matrix> MATRIXLARGEMULTITHREADED = new Chol<Matrix>(){

        @Override
        public Matrix calc(Matrix source) {
            Chol<Matrix> chol = null;
            if (UJMPSettings.getInstance().isUseJBlas()) {
                chol = DecompositionOps.CHOL_JBLAS;
            }
            if (chol == null && UJMPSettings.getInstance().isUseOjalgo()) {
                chol = DecompositionOps.CHOL_OJALGO;
            }
            if (chol == null) {
                chol = UJMP;
            }
            return chol.calc(source);
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            Chol<Matrix> chol = null;
            if (UJMPSettings.getInstance().isUseJBlas()) {
                chol = DecompositionOps.CHOL_JBLAS;
            }
            if (chol == null && UJMPSettings.getInstance().isUseOjalgo()) {
                chol = DecompositionOps.CHOL_OJALGO;
            }
            if (chol == null) {
                chol = UJMP;
            }
            return chol.solve(source, b);
        }
    };

    public T calc(T var1);

    public T solve(T var1, T var2);

    public static final class CholMatrix {
        public static final long serialVersionUID = 400514872358216115L;
        private final double[][] L;
        private final int n;
        private boolean isspd;

        public CholMatrix(Matrix Arg) {
            double[][] A = Arg.toDoubleArray();
            this.n = (int)Arg.getRowCount();
            this.L = new double[this.n][this.n];
            this.isspd = Arg.getColumnCount() == (long)this.n;
            double[] Lrowj = null;
            double[] Lrowk = null;
            double[] Aj = null;
            for (int j = 0; j < this.n; ++j) {
                int k;
                Lrowj = this.L[j];
                Aj = A[j];
                double d = 0.0;
                for (k = 0; k < j; ++k) {
                    Lrowk = this.L[k];
                    double s = 0.0;
                    for (int i = 0; i < k; ++i) {
                        s += Lrowk[i] * Lrowj[i];
                    }
                    Lrowj[k] = s = (Aj[k] - s) / Lrowk[k];
                    d += s * s;
                    this.isspd &= A[k][j] == Aj[k];
                }
                this.isspd &= (d = Aj[j] - d) > 0.0;
                Lrowj[j] = Math.sqrt(Math.max(d, 0.0));
                for (k = j + 1; k < this.n; ++k) {
                    Lrowj[k] = 0.0;
                }
            }
        }

        public final boolean isSPD() {
            return this.isspd;
        }

        public final DenseDoubleMatrix2D getL() {
            return Matrix.Factory.linkToArray(this.L);
        }

        public final DenseDoubleMatrix2D solve(Matrix B) {
            int i;
            int j;
            int k;
            if (B.getRowCount() != (long)this.n) {
                throw new IllegalArgumentException("Matrix row dimensions must agree.");
            }
            if (!this.isspd) {
                throw new RuntimeException("Matrix is not symmetric positive definite.");
            }
            double[][] X = B.toDoubleArray();
            int nx = (int)B.getColumnCount();
            for (k = 0; k < this.n; ++k) {
                j = 0;
                while (j < nx) {
                    for (i = 0; i < k; ++i) {
                        double[] dArray = X[k];
                        int n = j;
                        dArray[n] = dArray[n] - X[i][j] * this.L[k][i];
                    }
                    double[] dArray = X[k];
                    int n = j++;
                    dArray[n] = dArray[n] / this.L[k][k];
                }
            }
            for (k = this.n - 1; k >= 0; --k) {
                j = 0;
                while (j < nx) {
                    for (i = k + 1; i < this.n; ++i) {
                        double[] dArray = X[k];
                        int n = j;
                        dArray[n] = dArray[n] - X[i][j] * this.L[i][k];
                    }
                    double[] dArray = X[k];
                    int n = j++;
                    dArray[n] = dArray[n] / this.L[k][k];
                }
            }
            return Matrix.Factory.linkToArray(X);
        }
    }
}

