/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.charmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.charmatrix.stub.AbstractDenseCharMatrix2D;
import org.ujmp.core.doublematrix.impl.DefaultDenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasColumnMajorCharArray1D;
import org.ujmp.core.mapmatrix.MapMatrix;

public class DefaultDenseCharMatrix2D
extends AbstractDenseCharMatrix2D
implements HasColumnMajorCharArray1D {
    private static final long serialVersionUID = 5579846181111172177L;
    private final char[] values;
    private final int rows;
    private final int cols;

    public DefaultDenseCharMatrix2D(Matrix m) {
        super(m.getRowCount(), m.getColumnCount());
        this.rows = (int)m.getRowCount();
        this.cols = (int)m.getColumnCount();
        if (m instanceof DefaultDenseCharMatrix2D) {
            char[] v = ((DefaultDenseCharMatrix2D)m).values;
            this.values = new char[v.length];
            System.arraycopy(v, 0, this.values, 0, v.length);
        } else {
            this.values = new char[this.rows * this.cols];
            for (long[] c : m.allCoordinates()) {
                this.setChar(m.getAsChar(c), c);
            }
        }
    }

    public DefaultDenseCharMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.rows = rows;
        this.cols = columns;
        this.values = new char[rows * this.cols];
    }

    public DefaultDenseCharMatrix2D(char[] v, int rows, int cols) {
        super((long)rows, (long)cols);
        this.rows = rows;
        this.cols = cols;
        this.values = v;
    }

    @Override
    public char getChar(long row, long column) {
        return this.values[(int)(column * (long)this.rows + row)];
    }

    @Override
    public void setChar(char value, long row, long column) {
        this.values[(int)(column * (long)this.rows + row)] = value;
    }

    @Override
    public char getChar(int row, int column) {
        return this.values[column * this.rows + row];
    }

    @Override
    public void setChar(char value, int row, int column) {
        this.values[column * this.rows + row] = value;
    }

    @Override
    public final Matrix plus(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] + v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    @Override
    public final Matrix minus(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] - v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    @Override
    public final Matrix times(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] * v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    @Override
    public final Matrix divide(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] / v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix copy() {
        char[] result = new char[this.values.length];
        System.arraycopy(this.values, 0, result, 0, this.values.length);
        DefaultDenseCharMatrix2D m = new DefaultDenseCharMatrix2D(result, this.rows, this.cols);
        if (this.getMetaData() != null) {
            m.setMetaData((MapMatrix<String, Object>)this.getMetaData().clone());
        }
        return m;
    }

    @Override
    public final Matrix transpose() {
        char[] result = new char[this.cols * this.rows];
        int c = this.rows;
        while (--c != -1) {
            int r = this.cols;
            while (--r != -1) {
                result[c * this.cols + r] = this.values[r * this.rows + c];
            }
        }
        return new DefaultDenseCharMatrix2D(result, this.cols, this.rows);
    }

    @Override
    public char[] getColumnMajorCharArray1D() {
        return this.values;
    }
}

