/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.DenseMatrix2D;
import org.ujmp.core.calculation.Transpose;
import org.ujmp.core.calculation.TransposeCalculation;
import org.ujmp.core.util.VerifyUtil;

class TransposeDenseMatrix
implements TransposeCalculation<DenseMatrix, DenseMatrix> {
    TransposeDenseMatrix() {
    }

    @Override
    public final void calc(DenseMatrix source, DenseMatrix target) {
        if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            Transpose.DENSEMATRIX2D.calc((DenseMatrix2D)source, (DenseMatrix2D)target);
        } else {
            VerifyUtil.verify2D(source);
            VerifyUtil.verify2D(target);
            VerifyUtil.verifyEquals(source.getRowCount(), target.getColumnCount(), "matrices have wrong size");
            VerifyUtil.verifyEquals(source.getColumnCount(), target.getRowCount(), "matrices have wrong size");
            for (long[] c : source.allCoordinates()) {
                Object o = source.getAsObject(c);
                target.setAsObject(o, Coordinates.transpose(c));
            }
        }
    }
}

