/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.SparseMatrix;
import org.ujmp.core.calculation.TimesMatrixCalculation;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

class TimesMatrixSparseMatrix
implements TimesMatrixCalculation<SparseMatrix, SparseMatrix, SparseMatrix> {
    TimesMatrixSparseMatrix() {
    }

    @Override
    public void calc(SparseMatrix source1, SparseMatrix source2, SparseMatrix target) {
        MapMatrix<String, Object> a;
        VerifyUtil.verifySameSize(source1, source2, target);
        for (long[] c : source1.availableCoordinates()) {
            BigDecimal v1 = source1.getAsBigDecimal(c);
            BigDecimal v2 = source2.getAsBigDecimal(c);
            target.setAsBigDecimal(MathUtil.times(v1, v2), c);
        }
        if (source1 != target && (a = source1.getMetaData()) != null) {
            target.setMetaData((MapMatrix<String, Object>)a.clone());
        }
    }
}

