/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.svg;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.intermediate.AbstractIFPainter;
import org.apache.fop.render.intermediate.IFConstants;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFState;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.fop.render.svg.AbstractSVGDocumentHandler;
import org.apache.fop.render.svg.SVGConstants;
import org.apache.fop.render.svg.SVGRenderingContext;
import org.apache.fop.render.svg.SVGUtil;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.ColorUtil;
import org.apache.fop.util.GenerationHelperContentHandler;
import org.apache.fop.util.XMLConstants;
import org.apache.fop.util.XMLUtil;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.util.QName;
import org.apache.xmlgraphics.xmp.Metadata;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGPainter
extends AbstractIFPainter
implements SVGConstants {
    private AbstractSVGDocumentHandler parent;
    protected GenerationHelperContentHandler handler;
    private static final int MODE_NORMAL = 0;
    private static final int MODE_TEXT = 1;
    private int mode = 0;

    public SVGPainter(AbstractSVGDocumentHandler parent, GenerationHelperContentHandler contentHandler) {
        this.parent = parent;
        this.handler = contentHandler;
        this.state = IFState.create();
    }

    protected IFContext getContext() {
        return this.parent.getContext();
    }

    public void startViewport(AffineTransform transform, Dimension size, Rectangle clipRect) throws IFException {
        this.startViewport(SVGUtil.formatAffineTransformMptToPt(transform), size, clipRect);
    }

    public void startViewport(AffineTransform[] transforms, Dimension size, Rectangle clipRect) throws IFException {
        this.startViewport(SVGUtil.formatAffineTransformsMptToPt(transforms), size, clipRect);
    }

    private void startViewport(String transform, Dimension size, Rectangle clipRect) throws IFException {
        try {
            this.establish(0);
            AttributesImpl atts = new AttributesImpl();
            if (transform != null && transform.length() > 0) {
                XMLUtil.addAttribute((AttributesImpl)atts, (String)"transform", (String)transform);
            }
            this.handler.startElement("g", (Attributes)atts);
            atts.clear();
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"width", (String)SVGUtil.formatMptToPt(size.width));
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"height", (String)SVGUtil.formatMptToPt(size.height));
            if (clipRect != null) {
                int[] v = new int[]{clipRect.y, -clipRect.x + size.width - clipRect.width, -clipRect.y + size.height - clipRect.height, clipRect.x};
                int sum = 0;
                for (int i = 0; i < 4; ++i) {
                    sum += Math.abs(v[i]);
                }
                if (sum != 0) {
                    StringBuffer sb = new StringBuffer("rect(");
                    sb.append(SVGUtil.formatMptToPt(v[0])).append(',');
                    sb.append(SVGUtil.formatMptToPt(v[1])).append(',');
                    sb.append(SVGUtil.formatMptToPt(v[2])).append(',');
                    sb.append(SVGUtil.formatMptToPt(v[3])).append(')');
                    XMLUtil.addAttribute((AttributesImpl)atts, (String)"clip", (String)sb.toString());
                }
                XMLUtil.addAttribute((AttributesImpl)atts, (String)"overflow", (String)"hidden");
            } else {
                XMLUtil.addAttribute((AttributesImpl)atts, (String)"overflow", (String)"visible");
            }
            this.handler.startElement("svg", (Attributes)atts);
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startBox()", (Exception)e);
        }
    }

    public void endViewport() throws IFException {
        try {
            this.establish(0);
            this.handler.endElement("svg");
            this.handler.endElement("g");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endBox()", (Exception)e);
        }
    }

    public void startGroup(AffineTransform[] transforms) throws IFException {
        this.startGroup(SVGUtil.formatAffineTransformsMptToPt(transforms));
    }

    public void startGroup(AffineTransform transform) throws IFException {
        this.startGroup(SVGUtil.formatAffineTransformMptToPt(transform));
    }

    private void startGroup(String transform) throws IFException {
        try {
            AttributesImpl atts = new AttributesImpl();
            if (transform != null && transform.length() > 0) {
                XMLUtil.addAttribute((AttributesImpl)atts, (String)"transform", (String)transform);
            }
            this.handler.startElement("g", (Attributes)atts);
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startGroup()", (Exception)e);
        }
    }

    public void endGroup() throws IFException {
        try {
            this.establish(0);
            this.handler.endElement("g");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endGroup()", (Exception)e);
        }
    }

    public void drawImage(String uri, Rectangle rect) throws IFException {
        block7: {
            try {
                this.establish(0);
                ImageManager manager = this.getUserAgent().getFactory().getImageManager();
                ImageInfo info = null;
                try {
                    ImageSessionContext sessionContext = this.getUserAgent().getImageSessionContext();
                    info = manager.getImageInfo(uri, sessionContext);
                    String mime = info.getMimeType();
                    Map foreignAttributes = this.getContext().getForeignAttributes();
                    String conversionMode = (String)foreignAttributes.get(ImageHandlerUtil.CONVERSION_MODE);
                    if ("reference".equals(conversionMode) && ("image/gif".equals(mime) || "image/jpeg".equals(mime) || "image/png".equals(mime) || "image/svg+xml".equals(mime))) {
                        AttributesImpl atts = new AttributesImpl();
                        XMLUtil.addAttribute((AttributesImpl)atts, (QName)IFConstants.XLINK_HREF, (String)uri);
                        XMLUtil.addAttribute((AttributesImpl)atts, (String)"x", (String)SVGUtil.formatMptToPt(rect.x));
                        XMLUtil.addAttribute((AttributesImpl)atts, (String)"y", (String)SVGUtil.formatMptToPt(rect.y));
                        XMLUtil.addAttribute((AttributesImpl)atts, (String)"width", (String)SVGUtil.formatMptToPt(rect.width));
                        XMLUtil.addAttribute((AttributesImpl)atts, (String)"height", (String)SVGUtil.formatMptToPt(rect.height));
                        this.handler.element("image", (Attributes)atts);
                        break block7;
                    }
                    this.drawImageUsingImageHandler(info, rect);
                }
                catch (ImageException ie) {
                    ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
                    eventProducer.imageError((Object)this, info != null ? info.toString() : uri, ie, null);
                }
                catch (FileNotFoundException fe) {
                    ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
                    eventProducer.imageNotFound((Object)this, info != null ? info.toString() : uri, fe, null);
                }
                catch (IOException ioe) {
                    ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
                    eventProducer.imageIOError((Object)this, info != null ? info.toString() : uri, ioe, null);
                }
            }
            catch (SAXException e) {
                throw new IFException("SAX error in drawImage()", (Exception)e);
            }
        }
    }

    public void drawImage(Document doc, Rectangle rect) throws IFException {
        try {
            this.establish(0);
            this.drawImageUsingDocument(doc, rect);
        }
        catch (SAXException e) {
            throw new IFException("SAX error in drawImage()", (Exception)e);
        }
    }

    protected RenderingContext createRenderingContext() {
        SVGRenderingContext svgContext = new SVGRenderingContext(this.getUserAgent(), (ContentHandler)this.handler);
        return svgContext;
    }

    private static String toString(Paint paint) {
        if (paint instanceof Color) {
            return ColorUtil.colorToString((Color)((Color)paint));
        }
        throw new UnsupportedOperationException("Paint not supported: " + paint);
    }

    public void clipRect(Rectangle rect) throws IFException {
    }

    public void fillRect(Rectangle rect, Paint fill) throws IFException {
        if (fill == null) {
            return;
        }
        try {
            this.establish(0);
            AttributesImpl atts = new AttributesImpl();
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"x", (String)SVGUtil.formatMptToPt(rect.x));
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"y", (String)SVGUtil.formatMptToPt(rect.y));
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"width", (String)SVGUtil.formatMptToPt(rect.width));
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"height", (String)SVGUtil.formatMptToPt(rect.height));
            if (fill != null) {
                XMLUtil.addAttribute((AttributesImpl)atts, (String)"fill", (String)SVGPainter.toString(fill));
            }
            this.handler.element("rect", (Attributes)atts);
        }
        catch (SAXException e) {
            throw new IFException("SAX error in fillRect()", (Exception)e);
        }
    }

    public void drawBorderRect(Rectangle rect, BorderProps before, BorderProps after, BorderProps start, BorderProps end) throws IFException {
    }

    public void drawLine(Point start, Point end, int width, Color color, RuleStyle style) throws IFException {
        try {
            this.establish(0);
            AttributesImpl atts = new AttributesImpl();
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"x1", (String)SVGUtil.formatMptToPt(start.x));
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"y1", (String)SVGUtil.formatMptToPt(start.y));
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"x2", (String)SVGUtil.formatMptToPt(end.x));
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"y2", (String)SVGUtil.formatMptToPt(end.y));
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"stroke-width", (String)SVGPainter.toString(color));
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"fill", (String)SVGPainter.toString(color));
            this.handler.element("line", (Attributes)atts);
        }
        catch (SAXException e) {
            throw new IFException("SAX error in drawLine()", (Exception)e);
        }
    }

    public void drawText(int x, int y, int letterSpacing, int wordSpacing, int[][] dp, String text) throws IFException {
        try {
            this.establish(1);
            AttributesImpl atts = new AttributesImpl();
            XMLUtil.addAttribute((AttributesImpl)atts, (QName)XMLConstants.XML_SPACE, (String)"preserve");
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"x", (String)SVGUtil.formatMptToPt(x));
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"y", (String)SVGUtil.formatMptToPt(y));
            if (letterSpacing != 0) {
                XMLUtil.addAttribute((AttributesImpl)atts, (String)"letter-spacing", (String)SVGUtil.formatMptToPt(letterSpacing));
            }
            if (wordSpacing != 0) {
                XMLUtil.addAttribute((AttributesImpl)atts, (String)"word-spacing", (String)SVGUtil.formatMptToPt(wordSpacing));
            }
            if (dp != null) {
                int[] dx = IFUtil.convertDPToDX((int[][])dp);
                XMLUtil.addAttribute((AttributesImpl)atts, (String)"dx", (String)SVGUtil.formatMptArrayToPt(dx));
            }
            this.handler.startElement("text", (Attributes)atts);
            char[] chars = text.toCharArray();
            this.handler.characters(chars, 0, chars.length);
            this.handler.endElement("text");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in setFont()", (Exception)e);
        }
    }

    private void leaveTextMode() throws SAXException {
        assert (this.mode == 1);
        this.handler.endElement("g");
        this.mode = 0;
    }

    private void establish(int newMode) throws SAXException {
        switch (newMode) {
            case 1: {
                this.enterTextMode();
                break;
            }
            default: {
                if (this.mode != 1) break;
                this.leaveTextMode();
            }
        }
    }

    private void enterTextMode() throws SAXException {
        if (this.state.isFontChanged() && this.mode == 1) {
            this.leaveTextMode();
        }
        if (this.mode != 1) {
            this.startTextGroup();
            this.mode = 1;
        }
    }

    private void startTextGroup() throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        XMLUtil.addAttribute((AttributesImpl)atts, (String)"font-family", (String)("'" + this.state.getFontFamily() + "'"));
        XMLUtil.addAttribute((AttributesImpl)atts, (String)"font-style", (String)this.state.getFontStyle());
        XMLUtil.addAttribute((AttributesImpl)atts, (String)"font-weight", (String)Integer.toString(this.state.getFontWeight()));
        XMLUtil.addAttribute((AttributesImpl)atts, (String)"font-variant", (String)this.state.getFontVariant());
        XMLUtil.addAttribute((AttributesImpl)atts, (String)"font-size", (String)SVGUtil.formatMptToPt(this.state.getFontSize()));
        XMLUtil.addAttribute((AttributesImpl)atts, (String)"fill", (String)SVGPainter.toString(this.state.getTextColor()));
        this.handler.startElement("g", (Attributes)atts);
        this.state.resetFontChanged();
    }

    public void handleExtensionObject(Object extension) throws IFException {
        if (extension instanceof Metadata) {
            Metadata meta = (Metadata)extension;
            try {
                this.establish(0);
                this.handler.startElement("metadata");
                meta.toSAX((ContentHandler)this.handler);
                this.handler.endElement("metadata");
            }
            catch (SAXException e) {
                throw new IFException("SAX error while handling extension object", (Exception)e);
            }
        } else {
            throw new UnsupportedOperationException("Don't know how to handle extension object: " + extension);
        }
    }
}

