/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.realtime.MemoryArea;
import javolution.context.ObjectFactory;
import javolution.io.UTF8StreamWriter;
import javolution.lang.Reusable;
import javolution.text.CharArray;
import javolution.text.TextBuilder;
import javolution.xml.stream.NamespacesImpl;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamWriter;

public final class XMLStreamWriterImpl
implements XMLStreamWriter,
Reusable {
    private static final int BUFFER_LENGTH = 2048;
    private int _nesting = 0;
    private TextBuilder[] _qNames = new TextBuilder[16];
    private boolean _isElementOpen;
    private boolean _isEmptyElement;
    private final char[] _buffer = new char[2048];
    private final NamespacesImpl _namespaces = new NamespacesImpl();
    private int _index;
    private boolean _isRepairingNamespaces;
    private String _repairingPrefix = "ns";
    private String _indentation;
    private int _indentationLevel;
    private boolean _automaticEmptyElements;
    private int _autoNSCount;
    ObjectFactory _objectFactory;
    private Writer _writer;
    private String _encoding;
    private final UTF8StreamWriter _utf8StreamWriter = new UTF8StreamWriter();
    private final CharArray _noChar = new CharArray("");
    private final TextBuilder _autoPrefix = new TextBuilder();

    public XMLStreamWriterImpl() {
        int n = 0;
        while (n < this._qNames.length) {
            this._qNames[n++] = new TextBuilder();
        }
    }

    public void setOutput(OutputStream outputStream) throws XMLStreamException {
        this._utf8StreamWriter.setOutput(outputStream);
        this._encoding = "UTF-8";
        this.setOutput(this._utf8StreamWriter);
    }

    public void setOutput(OutputStream outputStream, String string) throws XMLStreamException {
        if (string.equals("UTF-8") || string.equals("utf-8") || string.equals("ASCII")) {
            this.setOutput(outputStream);
        } else {
            try {
                this._encoding = string;
                this.setOutput(new OutputStreamWriter(outputStream, string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new XMLStreamException(unsupportedEncodingException);
            }
        }
    }

    public void setOutput(Writer writer) throws XMLStreamException {
        if (this._writer != null) {
            throw new IllegalStateException("Writer not closed or reset");
        }
        this._writer = writer;
    }

    public void setRepairingNamespaces(boolean bl) {
        this._isRepairingNamespaces = bl;
    }

    public void setRepairingPrefix(String string) {
        this._repairingPrefix = string;
    }

    public void setIndentation(String string) {
        this._indentation = string;
    }

    public void setAutomaticEmptyElements(boolean bl) {
        this._automaticEmptyElements = bl;
    }

    public void reset() {
        this._automaticEmptyElements = false;
        this._autoNSCount = 0;
        this._encoding = null;
        this._indentation = null;
        this._indentationLevel = 0;
        this._index = 0;
        this._isElementOpen = false;
        this._isEmptyElement = false;
        this._isRepairingNamespaces = false;
        this._namespaces.reset();
        this._nesting = 0;
        this._objectFactory = null;
        this._repairingPrefix = "ns";
        this._utf8StreamWriter.reset();
        this._writer = null;
    }

    public void writeStartElement(CharSequence charSequence) throws XMLStreamException {
        if (charSequence == null) {
            throw new XMLStreamException("Local name cannot be null");
        }
        this.writeNewElement(null, charSequence, null);
    }

    public void writeStartElement(CharSequence charSequence, CharSequence charSequence2) throws XMLStreamException {
        if (charSequence2 == null) {
            throw new XMLStreamException("Local name cannot be null");
        }
        if (charSequence == null) {
            throw new XMLStreamException("Namespace URI cannot be null");
        }
        this.writeNewElement(null, charSequence2, charSequence);
    }

    public void writeStartElement(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) throws XMLStreamException {
        if (charSequence2 == null) {
            throw new XMLStreamException("Local name cannot be null");
        }
        if (charSequence3 == null) {
            throw new XMLStreamException("Namespace URI cannot be null");
        }
        if (charSequence == null) {
            throw new XMLStreamException("Prefix cannot be null");
        }
        this.writeNewElement(charSequence, charSequence2, charSequence3);
    }

    public void writeEmptyElement(CharSequence charSequence) throws XMLStreamException {
        this.writeStartElement(charSequence);
        this._isEmptyElement = true;
    }

    public void writeEmptyElement(CharSequence charSequence, CharSequence charSequence2) throws XMLStreamException {
        this.writeStartElement(charSequence, charSequence2);
        this._isEmptyElement = true;
    }

    public void writeEmptyElement(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) throws XMLStreamException {
        this.writeStartElement(charSequence, charSequence2, charSequence3);
        this._isEmptyElement = true;
    }

    public void writeEndElement() throws XMLStreamException {
        if (this._isElementOpen) {
            if (this._automaticEmptyElements) {
                this._isEmptyElement = true;
                this.closeOpenTag();
                return;
            }
            this.closeOpenTag();
        }
        if (this._indentation != null && this._indentationLevel != this._nesting - 1) {
            this.write('\n');
            for (int i = 1; i < this._nesting; ++i) {
                this.writeStr(this._indentation);
            }
        }
        this.write('<');
        this.write('/');
        this.writeTB(this._qNames[this._nesting--]);
        this.write('>');
        this._namespaces.pop();
    }

    public void writeEndDocument() throws XMLStreamException {
        if (this._isElementOpen) {
            this.closeOpenTag();
        }
        while (this._nesting > 0) {
            this.writeEndElement();
        }
    }

    public void close() throws XMLStreamException {
        if (this._writer != null) {
            if (this._nesting != 0) {
                this.writeEndDocument();
            }
            this.flush();
        }
        if (this._objectFactory != null) {
            this._objectFactory.recycle(this);
        } else {
            this.reset();
        }
    }

    public void flush() throws XMLStreamException {
        this.flushBuffer();
        try {
            this._writer.flush();
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeAttribute(CharSequence charSequence, CharSequence charSequence2) throws XMLStreamException {
        if (charSequence == null) {
            throw new XMLStreamException("Local name cannot be null");
        }
        if (charSequence2 == null) {
            throw new XMLStreamException("Value cannot be null");
        }
        this.writeAttributeOrNamespace(null, null, charSequence, charSequence2);
    }

    public void writeAttribute(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) throws XMLStreamException {
        if (charSequence2 == null) {
            throw new XMLStreamException("Local name cannot be null");
        }
        if (charSequence3 == null) {
            throw new XMLStreamException("Value cannot be null");
        }
        if (charSequence == null) {
            throw new XMLStreamException("Namespace URI cannot be null");
        }
        this.writeAttributeOrNamespace(null, charSequence, charSequence2, charSequence3);
    }

    public void writeAttribute(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, CharSequence charSequence4) throws XMLStreamException {
        if (charSequence3 == null) {
            throw new XMLStreamException("Local name cannot be null");
        }
        if (charSequence4 == null) {
            throw new XMLStreamException("Value cannot be null");
        }
        if (charSequence2 == null) {
            throw new XMLStreamException("Namespace URI cannot be null");
        }
        if (charSequence == null) {
            throw new XMLStreamException("Prefix cannot be null");
        }
        this.writeAttributeOrNamespace(charSequence, charSequence2, charSequence3, charSequence4);
    }

    public void writeNamespace(CharSequence charSequence, CharSequence charSequence2) throws XMLStreamException {
        if (charSequence == null || charSequence.length() == 0 || this._namespaces._xmlns.equals((Object)charSequence)) {
            charSequence = this._namespaces._defaultNsPrefix;
        }
        if (!this._isElementOpen) {
            throw new IllegalStateException("No open start element");
        }
        this._namespaces.setPrefix(charSequence, charSequence2 == null ? this._namespaces._nullNsURI : charSequence2, true);
    }

    public void writeDefaultNamespace(CharSequence charSequence) throws XMLStreamException {
        this.writeNamespace(this._namespaces._defaultNsPrefix, charSequence);
    }

    public void writeComment(CharSequence charSequence) throws XMLStreamException {
        if (this._isElementOpen) {
            this.closeOpenTag();
        }
        this.writeStr("<!--");
        if (charSequence != null) {
            this.write(charSequence);
        }
        this.writeStr("-->");
    }

    public void writeProcessingInstruction(CharSequence charSequence) throws XMLStreamException {
        this.writeProcessingInstruction(charSequence, this._noChar);
    }

    public void writeProcessingInstruction(CharSequence charSequence, CharSequence charSequence2) throws XMLStreamException {
        if (charSequence == null) {
            throw new XMLStreamException("Target cannot be null");
        }
        if (charSequence2 == null) {
            throw new XMLStreamException("Data cannot be null");
        }
        if (this._isElementOpen) {
            this.closeOpenTag();
        }
        this.writeStr("<?");
        this.write(charSequence);
        this.write(' ');
        this.write(charSequence2);
        this.write(" ?>");
    }

    public void writeCData(CharSequence charSequence) throws XMLStreamException {
        if (charSequence == null) {
            throw new XMLStreamException("Data cannot be null");
        }
        if (this._isElementOpen) {
            this.closeOpenTag();
        }
        this.writeStr("<![CDATA[");
        this.write(charSequence);
        this.writeStr("]]>");
    }

    public void writeDTD(CharSequence charSequence) throws XMLStreamException {
        if (charSequence == null) {
            throw new XMLStreamException("DTD cannot be null");
        }
        if (this._nesting > 0) {
            throw new XMLStreamException("DOCTYPE declaration (DTD) when not in document root (prolog)");
        }
        this.write(charSequence);
    }

    public void writeEntityRef(CharSequence charSequence) throws XMLStreamException {
        this.write('&');
        this.write(charSequence);
        this.write(';');
    }

    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument(null, null);
    }

    public void writeStartDocument(CharSequence charSequence) throws XMLStreamException {
        this.writeStartDocument(null, charSequence);
    }

    public void writeStartDocument(CharSequence charSequence, CharSequence charSequence2) throws XMLStreamException {
        if (this._nesting > 0) {
            throw new XMLStreamException("Not in document root");
        }
        this.writeStr("<?xml version=\"");
        if (charSequence2 != null) {
            this.write(charSequence2);
            this.write('\"');
        } else {
            this.writeStr("1.0\"");
        }
        if (charSequence != null) {
            this.writeStr(" encoding=\"");
            this.write(charSequence);
            this.write('\"');
        } else if (this._encoding != null) {
            this.writeStr(" encoding=\"");
            this.writeStr(this._encoding);
            this.write('\"');
        }
        this.writeStr(" ?>");
    }

    public void writeCharacters(CharSequence charSequence) throws XMLStreamException {
        if (this._isElementOpen) {
            this.closeOpenTag();
        }
        if (charSequence == null) {
            return;
        }
        this.writeEsc(charSequence);
    }

    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        if (this._isElementOpen) {
            this.closeOpenTag();
        }
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            this.writeEsc(cArray[n3++]);
        }
    }

    public CharSequence getPrefix(CharSequence charSequence) throws XMLStreamException {
        return this._namespaces.getPrefix(charSequence);
    }

    public void setPrefix(CharSequence charSequence, CharSequence charSequence2) throws XMLStreamException {
        this._namespaces.setPrefix(charSequence, charSequence2 == null ? this._namespaces._nullNsURI : charSequence2, false);
    }

    public void setDefaultNamespace(CharSequence charSequence) throws XMLStreamException {
        this.setPrefix(this._namespaces._defaultNsPrefix, charSequence);
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (string.equals("javolution.xml.stream.isRepairingNamespaces")) {
            return new Boolean(this._isRepairingNamespaces);
        }
        if (string.equals("javolution.xml.stream.repairingPrefix")) {
            return this._repairingPrefix;
        }
        if (string.equals("javolution.xml.stream.automaticEmptyElements")) {
            return new Boolean(this._automaticEmptyElements);
        }
        if (string.equals("javolution.xml.stream.indentation")) {
            return this._indentation;
        }
        throw new IllegalArgumentException("Property: " + string + " not supported");
    }

    private void writeNewElement(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) throws XMLStreamException {
        if (this._isElementOpen) {
            this.closeOpenTag();
        }
        if (this._indentation != null) {
            this.write('\n');
            this._indentationLevel = this._nesting;
            for (int i = 0; i < this._indentationLevel; ++i) {
                this.writeStr(this._indentation);
            }
        }
        this.write('<');
        this._isElementOpen = true;
        if (++this._nesting >= this._qNames.length) {
            this.resizeElemStack();
        }
        this._namespaces.push();
        TextBuilder textBuilder = this._qNames[this._nesting].clear();
        if (charSequence3 != null && !this._namespaces._defaultNamespace.equals((Object)charSequence3)) {
            if (this._isRepairingNamespaces) {
                charSequence = this.getRepairedPrefix(charSequence, charSequence3);
            } else if (charSequence == null && (charSequence = this.getPrefix(charSequence3)) == null) {
                throw new XMLStreamException("URI: " + charSequence3 + " not bound and repairing namespaces disabled");
            }
            if (charSequence.length() > 0) {
                textBuilder.append(charSequence);
                textBuilder.append(':');
            }
        }
        textBuilder.append(charSequence2);
        this.writeTB(textBuilder);
    }

    private void writeAttributeOrNamespace(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, CharSequence charSequence4) throws XMLStreamException {
        if (!this._isElementOpen) {
            throw new IllegalStateException("No open start element");
        }
        this.write(' ');
        if (charSequence2 != null && !this._namespaces._defaultNamespace.equals((Object)charSequence2)) {
            if (this._isRepairingNamespaces) {
                charSequence = this.getRepairedPrefix(charSequence, charSequence2);
            } else if (charSequence == null && (charSequence = this.getPrefix(charSequence2)) == null) {
                throw new XMLStreamException("URI: " + charSequence2 + " not bound and repairing namespaces disabled");
            }
            if (charSequence.length() > 0) {
                this.write(charSequence);
                this.write(':');
            }
        }
        this.write(charSequence3);
        this.write('=');
        this.write('\"');
        this.writeEsc(charSequence4);
        this.write('\"');
    }

    private void closeOpenTag() throws XMLStreamException {
        this.writeNamespaces();
        this._isElementOpen = false;
        if (this._isEmptyElement) {
            this.write('/');
            this.write('>');
            --this._nesting;
            this._namespaces.pop();
            this._isEmptyElement = false;
        } else {
            this.write('>');
        }
    }

    private void writeNamespaces() throws XMLStreamException {
        int n = this._nesting > 1 ? this._namespaces._namespacesCount[this._nesting - 2] : 3;
        int n2 = this._namespaces._namespacesCount[this._nesting - 1];
        int n3 = this._namespaces._namespacesCount[this._nesting];
        for (int i = n; i < n3; ++i) {
            CharArray charArray;
            if ((!this._isRepairingNamespaces || i >= n2 || this._namespaces._prefixesWritten[i]) && (i < n2 || !this._namespaces._prefixesWritten[i]) || this._isRepairingNamespaces && this._namespaces._prefixes[i].equals(charArray = this._namespaces.getPrefix(this._namespaces._namespaces[i], i))) continue;
            if (this._namespaces._prefixes[i].length() == 0) {
                this.writeAttributeOrNamespace(null, null, this._namespaces._xmlns, this._namespaces._namespaces[i]);
                continue;
            }
            this.writeAttributeOrNamespace(this._namespaces._xmlns, this._namespaces._xmlnsURI, this._namespaces._prefixes[i], this._namespaces._namespaces[i]);
        }
    }

    private CharSequence getRepairedPrefix(CharSequence charSequence, CharSequence charSequence2) throws XMLStreamException {
        CharArray charArray = this._namespaces.getPrefix(charSequence2);
        if (charArray != null && (charSequence == null || charArray.equals((Object)charSequence))) {
            return charArray;
        }
        if (charSequence == null || charSequence.length() == 0) {
            charSequence = this._autoPrefix.clear().append(this._repairingPrefix).append(this._autoNSCount++);
        }
        this._namespaces.setPrefix(charSequence, charSequence2, true);
        return charSequence;
    }

    private void resizeElemStack() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                int n = XMLStreamWriterImpl.this._qNames.length;
                int n2 = n * 2;
                TextBuilder[] textBuilderArray = new TextBuilder[n2];
                System.arraycopy(XMLStreamWriterImpl.this._qNames, 0, textBuilderArray, 0, n);
                XMLStreamWriterImpl.access$002(XMLStreamWriterImpl.this, textBuilderArray);
                for (int i = n; i < n2; ++i) {
                    ((XMLStreamWriterImpl)XMLStreamWriterImpl.this)._qNames[i] = new TextBuilder();
                }
            }
        });
    }

    private final void write(char c) throws XMLStreamException {
        this._buffer[this._index++] = c;
        if (this._index == 2048) {
            this.flushBuffer();
        }
    }

    private final void writeEsc(char c) throws XMLStreamException {
        if (c >= '?' || c >= ' ' && c != '<' && c != '>' && c != '\"' && c != '&') {
            this.write(c);
        } else {
            this.writeEsc2(c);
        }
    }

    private final void writeEsc2(char c) throws XMLStreamException {
        switch (c) {
            case '<': {
                this.writeStr("&lt;");
                break;
            }
            case '>': {
                this.writeStr("&gt;");
                break;
            }
            case '\"': {
                this.writeStr("&quot;");
                break;
            }
            case '&': {
                this.writeStr("&amp;");
                break;
            }
            default: {
                if (c >= ' ') {
                    this.write(c);
                    break;
                }
                this.writeStr("&#");
                this.write((char)(48 + c / 10));
                this.write((char)(48 + c % 10));
                this.write(';');
            }
        }
    }

    private void write(Object object) throws XMLStreamException {
        if (object instanceof String) {
            this.writeStr((String)object);
        } else {
            this.writeCsq((CharSequence)object);
        }
    }

    private void writeStr(String string) throws XMLStreamException {
        int n = string.length();
        if (this._index + n < 2048) {
            string.getChars(0, n, this._buffer, this._index);
            this._index += n;
        } else {
            this.writeStrImmediate(string);
        }
    }

    private void writeStrImmediate(String string) throws XMLStreamException {
        this.flushBuffer();
        try {
            this._writer.write(string);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    private void writeCsq(CharSequence charSequence) throws XMLStreamException {
        int n = 0;
        int n2 = charSequence.length();
        while (n < n2) {
            this._buffer[this._index++] = charSequence.charAt(n++);
            if (this._index != 2048) continue;
            this.flushBuffer();
        }
    }

    private void writeTB(TextBuilder textBuilder) throws XMLStreamException {
        int n = 0;
        int n2 = textBuilder.length();
        while (n < n2) {
            this._buffer[this._index++] = textBuilder.charAt(n++);
            if (this._index != 2048) continue;
            this.flushBuffer();
        }
    }

    private void writeEsc(Object object) throws XMLStreamException {
        if (object instanceof String) {
            this.writeEscStr((String)object);
        } else {
            this.writeEscCsq((CharSequence)object);
        }
    }

    private void writeEscStr(String string) throws XMLStreamException {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c;
            if ((c = string.charAt(n++)) >= '?' || c >= ' ' && c != '<' && c != '>' && c != '\"' && c != '&') {
                this._buffer[this._index++] = c;
                if (this._index != 2048) continue;
                this.flushBuffer();
                continue;
            }
            this.writeEsc2(c);
        }
    }

    private void writeEscCsq(CharSequence charSequence) throws XMLStreamException {
        int n = 0;
        int n2 = charSequence.length();
        while (n < n2) {
            char c;
            if ((c = charSequence.charAt(n++)) >= '?' || c >= ' ' && c != '<' && c != '>' && c != '\"' && c != '&') {
                this._buffer[this._index++] = c;
                if (this._index != 2048) continue;
                this.flushBuffer();
                continue;
            }
            this.writeEsc2(c);
        }
    }

    private void flushBuffer() throws XMLStreamException {
        try {
            this._writer.write(this._buffer, 0, this._index);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        finally {
            this._index = 0;
        }
    }

    static /* synthetic */ TextBuilder[] access$002(XMLStreamWriterImpl xMLStreamWriterImpl, TextBuilder[] textBuilderArray) {
        xMLStreamWriterImpl._qNames = textBuilderArray;
        return textBuilderArray;
    }
}

