/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.realtime.MemoryArea;
import javolution.context.ArrayFactory;
import javolution.context.LogContext;
import javolution.context.ObjectFactory;
import javolution.context.PersistentContext;
import javolution.lang.MathLib;
import javolution.lang.Realtime;
import javolution.lang.Reusable;
import javolution.text.Text;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.xml.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastMap<K, V>
implements Map<K, V>,
Reusable,
XMLSerializable,
Realtime {
    private static final int B0 = 4;
    private static final int C0 = 16;
    private static final int B1 = 10;
    private static final int C1 = 1024;
    private static final int B2 = 6;
    private static final int C2 = 64;
    private transient Entry<K, V> _head;
    private transient Entry<K, V> _tail;
    private transient Entry<K, V>[] _entries;
    private transient int _entryCount;
    private transient int _nullCount;
    private transient FastMap[] _subMaps;
    private transient boolean _useSubMaps;
    private transient int _keyShift;
    private transient Values _values;
    private transient KeySet _keySet;
    private transient EntrySet _entrySet;
    private transient Map<K, V> _unmodifiable;
    private transient FastComparator _keyComparator;
    private transient boolean _isDirectKeyComparator;
    private transient FastComparator _valueComparator;
    private transient boolean _isShared;
    private static final ObjectFactory FACTORY = new ObjectFactory(){

        public Object create() {
            return new FastMap();
        }

        public void cleanup(Object object) {
            ((FastMap)object).reset();
        }
    };
    private static final Entry[] NULL_ENTRIES = new Entry[1024];
    static volatile int ONE_VOLATILE = 1;
    private static final long serialVersionUID = 1L;

    public FastMap() {
        this(4);
    }

    public FastMap(String string) {
        this();
        new PersistentContext.Reference(string, this){

            protected void notifyChange() {
                FastMap.this.clear();
                FastMap.this.putAll((FastMap)this.get());
            }
        };
    }

    public FastMap(int n) {
        this.setKeyComparator(FastComparator.DEFAULT);
        this.setValueComparator(FastComparator.DEFAULT);
        this.setup(n);
    }

    private void setup(int n) {
        int n2;
        for (n2 = 16; n2 < n; n2 <<= 1) {
        }
        this._entries = new Entry[n2 << 1];
        this._head = this.newEntry();
        this._tail = this.newEntry();
        ((Entry)this._head)._next = (Entry)this._tail;
        ((Entry)this._tail)._previous = (Entry)this._head;
        Entry<K, V> entry = this._tail;
        int n3 = 0;
        while (n3++ < n) {
            Entry<K, V> entry2 = this.newEntry();
            ((Entry)entry2)._previous = (Entry)entry;
            ((Entry)entry)._next = (Entry)entry2;
            entry = entry2;
        }
    }

    public FastMap(Map<? extends K, ? extends V> map) {
        this(map.size());
        this.putAll(map);
    }

    private FastMap(Entry[] entryArray) {
        this._entries = entryArray;
    }

    public static <K, V> FastMap<K, V> newInstance() {
        return (FastMap)FACTORY.object();
    }

    public static void recycle(FastMap fastMap) {
        FACTORY.recycle(fastMap);
    }

    public final Entry<K, V> head() {
        return this._head;
    }

    public final Entry<K, V> tail() {
        return this._tail;
    }

    @Override
    public final int size() {
        if (!this._useSubMaps) {
            return this._entryCount;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this._subMaps.length) {
            n += this._subMaps[n2++].size();
        }
        return n;
    }

    @Override
    public final boolean isEmpty() {
        return ((Entry)this._head)._next == this._tail;
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    @Override
    public final boolean containsValue(Object object) {
        return this.values().contains(object);
    }

    @Override
    public final V get(Object object) {
        Entry<K, V> entry = this.getEntry(object);
        return (V)(entry != null ? ((Entry)entry)._value : null);
    }

    public final Entry<K, V> getEntry(Object object) {
        return this.getEntry(object, this._isDirectKeyComparator ? object.hashCode() : this._keyComparator.hashCodeOf(object));
    }

    private final Entry getEntry(Object object, int n) {
        FastMap fastMap = this.getSubMap(n);
        Entry<K, V>[] entryArray = fastMap._entries;
        int n2 = entryArray.length - 1;
        int n3 = n >> fastMap._keyShift;
        Entry<K, V> entry;
        while ((entry = entryArray[n3 & n2]) != null) {
            if (object == ((Entry)entry)._key || n == ((Entry)entry)._keyHash && (this._isDirectKeyComparator ? object.equals(((Entry)entry)._key) : this._keyComparator.areEqual(object, ((Entry)entry)._key))) {
                return entry;
            }
            ++n3;
        }
        return null;
    }

    private final FastMap getSubMap(int n) {
        return this._useSubMaps ? this._subMaps[n & 0x3F].getSubMap(n >> 6) : this;
    }

    @Override
    public final V put(K k, V v) {
        return (V)this.put(k, v, this._isDirectKeyComparator ? k.hashCode() : this._keyComparator.hashCodeOf(k), this._isShared, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object put(Object object, Object object2, int n, boolean bl, boolean bl2) {
        FastMap fastMap = this.getSubMap(n);
        Entry<K, V>[] entryArray = fastMap._entries;
        int n2 = entryArray.length - 1;
        int n3 = -1;
        int n4 = n >> fastMap._keyShift;
        while (true) {
            Entry<K, V> entry;
            if ((entry = entryArray[n4 & n2]) == null) break;
            if (entry == Entry.NULL) {
                n3 = n3 < 0 ? n4 & n2 : n3;
            } else if (object == ((Entry)entry)._key || n == ((Entry)entry)._keyHash && (this._isDirectKeyComparator ? object.equals(((Entry)entry)._key) : this._keyComparator.areEqual(object, ((Entry)entry)._key))) {
                if (bl2) {
                    return ((Entry)entry)._value;
                }
                Object object3 = ((Entry)entry)._value;
                ((Entry)entry)._value = object2;
                return object3;
            }
            ++n4;
        }
        n3 = n3 < 0 ? n4 & n2 : n3;
        if (bl) {
            FastMap fastMap2 = this;
            synchronized (fastMap2) {
                return this.put(object, object2, n, false, bl2);
            }
        }
        Entry<K, V> entry = this._tail;
        ((Entry)entry)._key = object;
        ((Entry)entry)._value = object2;
        ((Entry)entry)._keyHash = n;
        if (((Entry)entry)._next == null) {
            this.createNewEntries();
        }
        entryArray[n3] = entry;
        fastMap._entryCount += ONE_VOLATILE;
        this._tail = ((Entry)this._tail)._next;
        if (fastMap._entryCount + fastMap._nullCount > entryArray.length >> 1) {
            fastMap.resizeTable(this._isShared);
        }
        return null;
    }

    private void createNewEntries() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                Entry entry = FastMap.this._tail;
                for (int i = 0; i < 8; ++i) {
                    Entry entry2 = FastMap.this.newEntry();
                    entry2._previous = entry;
                    entry._next = entry2;
                    entry = entry2;
                }
            }
        });
    }

    private void resizeTable(final boolean bl) {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                int n = FastMap.this._nullCount;
                FastMap.this._nullCount = 0;
                if (n > FastMap.this._entryCount) {
                    if (bl) {
                        Entry[] entryArray = new Entry[FastMap.this._entries.length];
                        FastMap.this.copyEntries(FastMap.this._entries, entryArray, FastMap.this._entries.length);
                        FastMap.access$802(FastMap.this, entryArray);
                    } else {
                        Object[] objectArray = ArrayFactory.OBJECTS_FACTORY.array(FastMap.this._entries.length);
                        System.arraycopy(FastMap.this._entries, 0, objectArray, 0, FastMap.this._entries.length);
                        FastMap.reset(FastMap.this._entries);
                        FastMap.this.copyEntries(objectArray, FastMap.this._entries, FastMap.this._entries.length);
                        FastMap.reset(objectArray);
                        ArrayFactory.OBJECTS_FACTORY.recycle(objectArray);
                    }
                    return;
                }
                int n2 = FastMap.this._entries.length << 1;
                if (n2 <= 1024) {
                    Entry[] entryArray = new Entry[n2];
                    FastMap.this.copyEntries(FastMap.this._entries, entryArray, FastMap.this._entries.length);
                    FastMap.access$802(FastMap.this, entryArray);
                    return;
                }
                if (FastMap.this._subMaps == null) {
                    FastMap.access$1102(FastMap.this, FastMap.this.newSubMaps(n2 >> 5));
                }
                int n3 = 0;
                while (n3 < FastMap.this._entries.length) {
                    Entry entry = FastMap.this._entries[n3++];
                    if (entry == null || entry == Entry.NULL) continue;
                    FastMap fastMap = FastMap.this._subMaps[entry._keyHash >> FastMap.this._keyShift & 0x3F];
                    fastMap.mapEntry(entry);
                    if (fastMap._entryCount + fastMap._nullCount << 1 < fastMap._entries.length) continue;
                    LogContext.warning("Unevenly distributed hash code - Degraded Preformance");
                    Entry[] entryArray = new Entry[n2];
                    FastMap.this.copyEntries(FastMap.this._entries, entryArray, FastMap.this._entries.length);
                    FastMap.access$802(FastMap.this, entryArray);
                    FastMap.access$1102(FastMap.this, null);
                    return;
                }
                FastMap.this._useSubMaps = ONE_VOLATILE == 1;
            }
        });
    }

    private FastMap[] newSubMaps(int n) {
        FastMap[] fastMapArray = new FastMap[64];
        for (int i = 0; i < 64; ++i) {
            FastMap<K, V> fastMap = new FastMap<K, V>(new Entry[n]);
            fastMap._keyShift = 6 + this._keyShift;
            fastMapArray[i] = fastMap;
        }
        return fastMapArray;
    }

    private void mapEntry(Entry entry) {
        int n = this._entries.length - 1;
        int n2 = entry._keyHash >> this._keyShift;
        while (true) {
            Entry<K, V> entry2;
            if ((entry2 = this._entries[n2 & n]) == null) break;
            ++n2;
        }
        this._entries[n2 & n] = entry;
        ++this._entryCount;
    }

    private void copyEntries(Object[] objectArray, Entry[] entryArray, int n) {
        int n2 = entryArray.length - 1;
        int n3 = 0;
        block0: while (n3 < n) {
            Entry entry;
            if ((entry = (Entry)objectArray[n3++]) == null || entry == Entry.NULL) continue;
            int n4 = entry._keyHash >> this._keyShift;
            while (true) {
                Entry entry2;
                if ((entry2 = entryArray[n4 & n2]) == null) {
                    entryArray[n4 & n2] = entry;
                    continue block0;
                }
                ++n4;
            }
        }
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public final V putIfAbsent(K k, V v) {
        return (V)this.put(k, v, this._isDirectKeyComparator ? k.hashCode() : this._keyComparator.hashCodeOf(k), this._isShared, true);
    }

    @Override
    public final V remove(Object object) {
        return (V)this.remove(object, this._isDirectKeyComparator ? object.hashCode() : this._keyComparator.hashCodeOf(object), this._isShared);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object remove(Object object, int n, boolean bl) {
        FastMap fastMap = this.getSubMap(n);
        Entry<K, V>[] entryArray = fastMap._entries;
        int n2 = entryArray.length - 1;
        int n3 = n >> fastMap._keyShift;
        Entry<K, V> entry;
        while ((entry = entryArray[n3 & n2]) != null) {
            if (object == ((Entry)entry)._key || n == ((Entry)entry)._keyHash && (this._isDirectKeyComparator ? object.equals(((Entry)entry)._key) : this._keyComparator.areEqual(object, ((Entry)entry)._key))) {
                if (bl) {
                    FastMap fastMap2 = this;
                    synchronized (fastMap2) {
                        return this.remove(object, n, false);
                    }
                }
                ((Entry)entry)._previous._next = ((Entry)entry)._next;
                ((Entry)entry)._next._previous = ((Entry)entry)._previous;
                entryArray[n3 & n2] = Entry.NULL;
                ++fastMap._nullCount;
                --fastMap._entryCount;
                Object object2 = ((Entry)entry)._value;
                if (!this._isShared) {
                    ((Entry)entry)._key = null;
                    ((Entry)entry)._value = null;
                    Entry entry2 = ((Entry)this._tail)._next;
                    ((Entry)entry)._previous = (Entry)this._tail;
                    ((Entry)entry)._next = entry2;
                    ((Entry)this._tail)._next = (Entry)entry;
                    if (entry2 != null) {
                        entry2._previous = (Entry)entry;
                    }
                }
                return object2;
            }
            ++n3;
        }
        return null;
    }

    public FastMap<K, V> setShared(boolean bl) {
        this._isShared = bl;
        return this;
    }

    public boolean isShared() {
        return this._isShared;
    }

    public FastMap<K, V> setKeyComparator(FastComparator<? super K> fastComparator) {
        this._keyComparator = fastComparator;
        this._isDirectKeyComparator = fastComparator instanceof FastComparator.Direct || this._keyComparator instanceof FastComparator.Default && !FastComparator._Rehash;
        return this;
    }

    public FastComparator<? super K> getKeyComparator() {
        return this._keyComparator;
    }

    public FastMap<K, V> setValueComparator(FastComparator<? super V> fastComparator) {
        this._valueComparator = fastComparator;
        return this;
    }

    public FastComparator<? super V> getValueComparator() {
        return this._valueComparator;
    }

    @Override
    public final void clear() {
        if (this._isShared) {
            this.clearShared();
            return;
        }
        Entry entry = this._head;
        Entry<K, V> entry2 = this._tail;
        while ((entry = entry._next) != entry2) {
            entry._key = null;
            entry._value = null;
        }
        this._tail = ((Entry)this._head)._next;
        this.clearTables();
    }

    private void clearTables() {
        if (this._useSubMaps) {
            int n = 0;
            while (n < 64) {
                this._subMaps[n++].clearTables();
            }
            this._useSubMaps = false;
        }
        FastMap.reset(this._entries);
        this._nullCount = 0;
        this._entryCount = 0;
    }

    private synchronized void clearShared() {
        ((Entry)this._head)._next = (Entry)this._tail;
        ((Entry)this._tail)._previous = (Entry)this._head;
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                FastMap.access$802(FastMap.this, new Entry[16]);
                if (FastMap.this._useSubMaps) {
                    FastMap.this._useSubMaps = false;
                    FastMap.access$1102(FastMap.this, FastMap.this.newSubMaps(16));
                }
                FastMap.this._entryCount = 0;
                FastMap.this._nullCount = 0;
            }
        });
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return ((Object)this.entrySet()).equals(map.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 0;
        Entry entry = this._head;
        Entry<K, V> entry2 = this._tail;
        while ((entry = entry._next) != entry2) {
            n += entry.hashCode();
        }
        return n;
    }

    @Override
    public Text toText() {
        return Text.valueOf(this.entrySet());
    }

    public final String toString() {
        return this.toText().toString();
    }

    protected Entry<K, V> newEntry() {
        return new Entry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStatistics(PrintStream printStream) {
        long l = this.getSumDistance();
        int n = this.size();
        int n2 = n != 0 ? (int)(100L * l / (long)n) : 0;
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            printStream.print("SIZE: " + n);
            printStream.print(", ENTRIES: " + this.getCapacity());
            printStream.print(", SLOTS: " + this.getTableLength());
            printStream.print(", USE SUB-MAPS: " + this._useSubMaps);
            printStream.print(", SUB-MAPS DEPTH: " + this.getSubMapDepth());
            printStream.print(", NULL COUNT: " + this._nullCount);
            printStream.print(", IS SHARED: " + this._isShared);
            printStream.print(", AVG DISTANCE: " + n2 + "%");
            printStream.print(", MAX DISTANCE: " + this.getMaximumDistance());
            printStream.println();
        }
    }

    private int getTableLength() {
        if (this._useSubMaps) {
            int n = 0;
            for (int i = 0; i < 64; ++i) {
                n += this._subMaps[i].getTableLength();
            }
            return n;
        }
        return this._entries.length;
    }

    private int getCapacity() {
        int n = 0;
        Entry entry = this._head;
        while ((entry = entry._next) != null) {
            ++n;
        }
        return n - 1;
    }

    private int getMaximumDistance() {
        int n = 0;
        if (this._useSubMaps) {
            for (int i = 0; i < 64; ++i) {
                int n2 = this._subMaps[i].getMaximumDistance();
                n = MathLib.max(n, n2);
            }
            return n;
        }
        for (int i = 0; i < this._entries.length; ++i) {
            Entry<K, V> entry = this._entries[i];
            if (entry == null || entry == Entry.NULL) continue;
            int n3 = ((Entry)entry)._keyHash >> this._keyShift & this._entries.length - 1;
            int n4 = i - n3;
            if (n4 < 0) {
                n4 += this._entries.length;
            }
            if (n4 <= n) continue;
            n = n4;
        }
        return n;
    }

    private long getSumDistance() {
        long l = 0L;
        if (this._useSubMaps) {
            for (int i = 0; i < 64; ++i) {
                l += this._subMaps[i].getSumDistance();
            }
            return l;
        }
        for (int i = 0; i < this._entries.length; ++i) {
            Entry<K, V> entry = this._entries[i];
            if (entry == null || entry == Entry.NULL) continue;
            int n = ((Entry)entry)._keyHash >> this._keyShift & this._entries.length - 1;
            int n2 = i - n;
            if (n2 < 0) {
                n2 += this._entries.length;
            }
            l += (long)n2;
        }
        return l;
    }

    private int getSubMapDepth() {
        if (this._useSubMaps) {
            int n = 0;
            for (int i = 0; i < 64; ++i) {
                int n2 = this._subMaps[i].getSubMapDepth();
                n = MathLib.max(n, n2);
            }
            return n + 1;
        }
        return 0;
    }

    @Override
    public final Collection<V> values() {
        if (this._values == null) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                public void run() {
                    FastMap.this._values = new Values();
                }
            });
        }
        return this._values;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        if (this._entrySet == null) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                public void run() {
                    FastMap.this._entrySet = new EntrySet();
                }
            });
        }
        return this._entrySet;
    }

    @Override
    public final Set<K> keySet() {
        if (this._keySet == null) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                public void run() {
                    FastMap.this._keySet = new KeySet();
                }
            });
        }
        return this._keySet;
    }

    public final Map<K, V> unmodifiable() {
        if (this._unmodifiable == null) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                public void run() {
                    FastMap.this._unmodifiable = new Unmodifiable();
                }
            });
        }
        return this._unmodifiable;
    }

    @Override
    public void reset() {
        this.setShared(false);
        this.clear();
        this.setKeyComparator(FastComparator.DEFAULT);
        this.setValueComparator(FastComparator.DEFAULT);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.setKeyComparator((FastComparator)objectInputStream.readObject());
        this.setValueComparator((FastComparator)objectInputStream.readObject());
        this.setShared(objectInputStream.readBoolean());
        int n = objectInputStream.readInt();
        this.setup(n);
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.getKeyComparator());
        objectOutputStream.writeObject(this.getValueComparator());
        objectOutputStream.writeBoolean(this._isShared);
        objectOutputStream.writeInt(this.size());
        Entry entry = this._head;
        Entry<K, V> entry2 = this._tail;
        while ((entry = entry._next) != entry2) {
            objectOutputStream.writeObject(entry._key);
            objectOutputStream.writeObject(entry._value);
        }
    }

    private static void reset(Object[] objectArray) {
        int n;
        for (int i = 0; i < objectArray.length; i += n) {
            n = MathLib.min(objectArray.length - i, 1024);
            System.arraycopy(NULL_ENTRIES, 0, objectArray, i, n);
        }
    }

    static /* synthetic */ Entry[] access$802(FastMap fastMap, Entry[] entryArray) {
        fastMap._entries = entryArray;
        return entryArray;
    }

    static /* synthetic */ FastMap[] access$1102(FastMap fastMap, FastMap[] fastMapArray) {
        fastMap._subMaps = fastMapArray;
        return fastMapArray;
    }

    private final class Unmodifiable
    implements Map,
    Serializable {
        private Unmodifiable() {
        }

        public boolean equals(Object object) {
            return FastMap.this.equals(object);
        }

        public int hashCode() {
            return FastMap.this.hashCode();
        }

        public Text toText() {
            return FastMap.this.toText();
        }

        public int size() {
            return FastMap.this.size();
        }

        public boolean isEmpty() {
            return FastMap.this.isEmpty();
        }

        public boolean containsKey(Object object) {
            return FastMap.this.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return FastMap.this.containsValue(object);
        }

        public Object get(Object object) {
            return FastMap.this.get(object);
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public void clear() {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public Set keySet() {
            return (Set)((KeySet)FastMap.this.keySet()).unmodifiable();
        }

        public Collection values() {
            return ((Values)FastMap.this.values()).unmodifiable();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException("Direct view over unmodifiable map entries is not supported  (to prevent access to Entry.setValue(Object) method). To iterate over unmodifiable map entries, applications may use the keySet() and values() fast collection views in conjonction.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<K, V>
    implements Map.Entry<K, V>,
    FastCollection.Record {
        public static final Entry NULL = new Entry();
        private Entry<K, V> _next;
        private Entry<K, V> _previous;
        private K _key;
        private V _value;
        private int _keyHash;

        protected Entry() {
        }

        @Override
        public final Entry<K, V> getNext() {
            return this._next;
        }

        @Override
        public final Entry<K, V> getPrevious() {
            return this._previous;
        }

        @Override
        public final K getKey() {
            return this._key;
        }

        @Override
        public final V getValue() {
            return this._value;
        }

        @Override
        public final V setValue(V v) {
            V v2 = this._value;
            this._value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return FastComparator.DEFAULT.areEqual(this._key, entry.getKey()) && FastComparator.DEFAULT.areEqual(this._value, entry.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this._key != null ? this._key.hashCode() : 0) ^ (this._value != null ? this._value.hashCode() : 0);
        }
    }

    private static final class KeyIterator
    implements Iterator {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new KeyIterator();
            }

            protected void cleanup(Object object) {
                KeyIterator keyIterator = (KeyIterator)object;
                keyIterator._map = null;
                keyIterator._current = null;
                keyIterator._next = null;
                keyIterator._tail = null;
            }
        };
        private FastMap _map;
        private Entry _current;
        private Entry _next;
        private Entry _tail;

        public static KeyIterator valueOf(FastMap fastMap) {
            KeyIterator keyIterator = (KeyIterator)FACTORY.object();
            keyIterator._map = fastMap;
            keyIterator._next = fastMap._head._next;
            keyIterator._tail = fastMap._tail;
            return keyIterator;
        }

        private KeyIterator() {
        }

        public boolean hasNext() {
            return this._next != this._tail;
        }

        public Object next() {
            if (this._next == this._tail) {
                throw new NoSuchElementException();
            }
            this._current = this._next;
            this._next = this._next._next;
            return this._current._key;
        }

        public void remove() {
            if (this._current == null) {
                throw new IllegalStateException();
            }
            this._next = this._current._next;
            this._map.remove(this._current._key);
            this._current = null;
        }
    }

    private final class KeySet
    extends FastCollection
    implements Set {
        private KeySet() {
        }

        public int size() {
            return FastMap.this.size();
        }

        public void clear() {
            FastMap.this.clear();
        }

        public boolean contains(Object object) {
            return FastMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return FastMap.this.remove(object) != null;
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return ((Entry)record)._key;
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }

        public FastComparator getValueComparator() {
            return FastMap.this._keyComparator;
        }

        public Iterator iterator() {
            return KeyIterator.valueOf(FastMap.this);
        }
    }

    private static final class EntryIterator
    implements Iterator {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new EntryIterator();
            }

            protected void cleanup(Object object) {
                EntryIterator entryIterator = (EntryIterator)object;
                entryIterator._map = null;
                entryIterator._current = null;
                entryIterator._next = null;
                entryIterator._tail = null;
            }
        };
        private FastMap _map;
        private Entry _current;
        private Entry _next;
        private Entry _tail;

        public static EntryIterator valueOf(FastMap fastMap) {
            EntryIterator entryIterator = (EntryIterator)FACTORY.object();
            entryIterator._map = fastMap;
            entryIterator._next = fastMap._head._next;
            entryIterator._tail = fastMap._tail;
            return entryIterator;
        }

        private EntryIterator() {
        }

        public boolean hasNext() {
            return this._next != this._tail;
        }

        public Object next() {
            if (this._next == this._tail) {
                throw new NoSuchElementException();
            }
            this._current = this._next;
            this._next = this._next._next;
            return this._current;
        }

        public void remove() {
            if (this._current == null) {
                throw new IllegalStateException();
            }
            this._next = this._current._next;
            this._map.remove(this._current._key);
            this._current = null;
        }
    }

    private final class EntrySet
    extends FastCollection
    implements Set {
        private final FastComparator _entryComparator = new FastComparator(){

            public boolean areEqual(Object object, Object object2) {
                if (object instanceof Map.Entry && object2 instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    Map.Entry entry2 = (Map.Entry)object2;
                    return FastMap.this._keyComparator.areEqual(entry.getKey(), entry2.getKey()) && FastMap.this._valueComparator.areEqual(entry.getValue(), entry2.getValue());
                }
                return object == null && object2 == null;
            }

            public int compare(Object object, Object object2) {
                return FastMap.this._keyComparator.compare(object, object2);
            }

            public int hashCodeOf(Object object) {
                Map.Entry entry = (Map.Entry)object;
                return FastMap.this._keyComparator.hashCodeOf(entry.getKey()) + FastMap.this._valueComparator.hashCodeOf(entry.getValue());
            }
        };

        private EntrySet() {
        }

        public int size() {
            return FastMap.this.size();
        }

        public void clear() {
            FastMap.this.clear();
        }

        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Entry entry = (Entry)object;
                Entry entry2 = FastMap.this.getEntry(entry.getKey());
                if (entry2 == null) {
                    return false;
                }
                return FastMap.this._valueComparator.areEqual(entry2.getValue(), entry.getValue());
            }
            return false;
        }

        public Text toText() {
            Text text = Text.valueOf('[');
            Text text2 = Text.valueOf('=');
            Text text3 = Text.valueOf((Object)", ");
            Entry entry = FastMap.this._head;
            Entry entry2 = FastMap.this._tail;
            while ((entry = entry._next) != entry2) {
                text = text.concat(Text.valueOf(entry._key)).concat(text2).concat(Text.valueOf(entry._value));
                if (entry._next == entry2) continue;
                text = text.concat(text3);
            }
            return text.concat(Text.valueOf(']'));
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return (Map.Entry)((Object)record);
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }

        public FastComparator getValueComparator() {
            return this._entryComparator;
        }

        public Iterator iterator() {
            return EntryIterator.valueOf(FastMap.this);
        }
    }

    private static final class ValueIterator
    implements Iterator {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new ValueIterator();
            }

            protected void cleanup(Object object) {
                ValueIterator valueIterator = (ValueIterator)object;
                valueIterator._map = null;
                valueIterator._current = null;
                valueIterator._next = null;
                valueIterator._tail = null;
            }
        };
        private FastMap _map;
        private Entry _current;
        private Entry _next;
        private Entry _tail;

        public static ValueIterator valueOf(FastMap fastMap) {
            ValueIterator valueIterator = (ValueIterator)FACTORY.object();
            valueIterator._map = fastMap;
            valueIterator._next = fastMap._head._next;
            valueIterator._tail = fastMap._tail;
            return valueIterator;
        }

        private ValueIterator() {
        }

        public boolean hasNext() {
            return this._next != this._tail;
        }

        public Object next() {
            if (this._next == this._tail) {
                throw new NoSuchElementException();
            }
            this._current = this._next;
            this._next = this._next._next;
            return this._current._value;
        }

        public void remove() {
            if (this._current == null) {
                throw new IllegalStateException();
            }
            this._next = this._current._next;
            this._map.remove(this._current._key);
            this._current = null;
        }
    }

    private final class Values
    extends FastCollection {
        private Values() {
        }

        public int size() {
            return FastMap.this.size();
        }

        public void clear() {
            FastMap.this.clear();
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return ((Entry)record)._value;
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }

        public FastComparator getValueComparator() {
            return FastMap.this._valueComparator;
        }

        public Iterator iterator() {
            return ValueIterator.valueOf(FastMap.this);
        }
    }
}

