/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit.extra;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.webswing.toolkit.util.Util;

public class WebRepaintManager
extends RepaintManager {
    private RepaintManager delegate;
    private Map<Container, Rectangle> dirty = new HashMap<Container, Rectangle>();

    public WebRepaintManager(RepaintManager delegate) {
        if (delegate != null) {
            this.delegate = delegate;
        }
    }

    public void setDelegate(RepaintManager delegate) {
        if (delegate != null) {
            this.delegate = delegate;
        }
    }

    @Override
    public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
        this.addDirtyRegionPrivate(c, x, y, w, h);
    }

    @Override
    public void addDirtyRegion(Window window, int x, int y, int w, int h) {
        this.addDirtyRegionPrivate(window, x, y, w, h);
    }

    @Override
    public void addDirtyRegion(Applet applet, int x, int y, int w, int h) {
        this.addDirtyRegionPrivate(applet, x, y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDirtyRegionPrivate(Container c, int x, int y, int w, int h) {
        if (w <= 0 || h <= 0 || c == null) {
            return;
        }
        if (c.getWidth() <= 0 || c.getHeight() <= 0) {
            return;
        }
        RepaintManager repaintManager = this.delegate;
        synchronized (repaintManager) {
            Rectangle r = this.dirty.get(c);
            if (r != null) {
                SwingUtilities.computeUnion(x, y, w, h, r);
            } else {
                this.dirty.put(c, new Rectangle(x, y, w, h));
            }
        }
        Util.getWebToolkit().getPaintDispatcher().notifyNewDirtyRegionQueued();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle getDirtyRegion(JComponent aComponent) {
        Rectangle r;
        RepaintManager repaintManager = this.delegate;
        synchronized (repaintManager) {
            r = this.dirty.get(aComponent);
        }
        if (r == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markCompletelyClean(JComponent component) {
        RepaintManager repaintManager = this.delegate;
        synchronized (repaintManager) {
            this.dirty.remove(component);
        }
    }

    public static void processDirtyComponents() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> WebRepaintManager.processDirtyComponents());
        } else if (RepaintManager.currentManager(null) instanceof WebRepaintManager) {
            ((WebRepaintManager)RepaintManager.currentManager(null)).process();
        } else {
            RepaintManager newDelegate = Util.getWebToolkit().getPaintDispatcher().getDefaultRepaintManager();
            WebRepaintManager webRepaintManager = new WebRepaintManager(newDelegate);
            RepaintManager.setCurrentManager(webRepaintManager);
            for (Window w : Window.getWindows()) {
                if (!w.isShowing()) continue;
                webRepaintManager.addDirtyRegion(w, w.getX(), w.getY(), w.getWidth(), w.getHeight());
            }
            webRepaintManager.process();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        RepaintManager repaintManager = this.delegate;
        synchronized (repaintManager) {
            for (Container c : this.dirty.keySet()) {
                Rectangle r = this.dirty.get(c);
                if (c instanceof JComponent) {
                    Panel p = Util.findHwComponentParent((JComponent)c);
                    if (p != null) {
                        for (Component chld : p.getComponents()) {
                            this.delegate.addDirtyRegion((JComponent)chld, 0, 0, chld.getWidth(), chld.getHeight());
                        }
                        continue;
                    }
                    this.delegate.addDirtyRegion((JComponent)c, r.x, r.y, r.width, r.height);
                    continue;
                }
                if (c instanceof Window) {
                    this.delegate.addDirtyRegion((Window)c, r.x, r.y, r.width, r.height);
                    continue;
                }
                if (!(c instanceof Applet)) continue;
                this.delegate.addDirtyRegion((Applet)c, r.x, r.y, r.width, r.height);
            }
            this.dirty.clear();
        }
    }

    @Override
    public void addInvalidComponent(JComponent invalidComponent) {
        this.delegate.addInvalidComponent(invalidComponent);
    }

    @Override
    public void removeInvalidComponent(JComponent component) {
        this.delegate.removeInvalidComponent(component);
    }

    @Override
    public Dimension getDoubleBufferMaximumSize() {
        return this.delegate.getDoubleBufferMaximumSize();
    }

    @Override
    public Image getOffscreenBuffer(Component c, int proposedWidth, int proposedHeight) {
        return this.delegate.getOffscreenBuffer(c, proposedWidth, proposedHeight);
    }

    @Override
    public Image getVolatileOffscreenBuffer(Component c, int proposedWidth, int proposedHeight) {
        return this.delegate.getVolatileOffscreenBuffer(c, proposedWidth, proposedHeight);
    }

    @Override
    public boolean isCompletelyDirty(JComponent component) {
        return this.delegate.isCompletelyDirty(component);
    }

    @Override
    public boolean isDoubleBufferingEnabled() {
        return this.delegate.isDoubleBufferingEnabled();
    }

    @Override
    public void markCompletelyDirty(JComponent component) {
        this.delegate.markCompletelyDirty(component);
    }

    @Override
    public void paintDirtyRegions() {
        this.delegate.paintDirtyRegions();
    }

    @Override
    public void setDoubleBufferingEnabled(boolean flag) {
        this.delegate.setDoubleBufferingEnabled(flag);
    }

    @Override
    public void setDoubleBufferMaximumSize(Dimension d) {
        this.delegate.setDoubleBufferMaximumSize(d);
    }

    @Override
    public void validateInvalidComponents() {
        this.delegate.validateInvalidComponents();
    }
}

