/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit.extra;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.webswing.toolkit.WebDragSourceContextPeer;
import org.webswing.toolkit.WebDropTargetContextPeer;
import org.webswing.toolkit.util.Logger;
import org.webswing.toolkit.util.Util;

public class DndEventHandler {
    private WebDropTargetContextPeer dropTarget;
    private long[] formats;
    private WebDragSourceContextPeer dragSource;
    private int sourceActions;
    private int lastDropTargetAction = 0;
    private boolean dropped;
    private boolean finished = true;
    private Component enteredComponent;
    private static Cursor cursor = Cursor.getDefaultCursor();

    public void processMouseEvent(Window w, AWTEvent e) {
        if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            int modifiers = me.getModifiersEx() & 0xC0 | 0x400;
            int currentDropAction = WebDragSourceContextPeer.convertModifiersToDropAction(modifiers, this.sourceActions);
            if (this.enteredComponent == w) {
                this.lastDropTargetAction = this.dropTarget.handleMotionMessage(w, me.getX(), me.getY(), currentDropAction, this.sourceActions, this.formats, 123123123L);
            } else {
                this.lastDropTargetAction = this.dropTarget.handleEnterMessage(w, me.getX(), me.getY(), currentDropAction, this.sourceActions, this.formats, 123123123L);
                this.enteredComponent = w;
            }
            if (e.getID() == 502) {
                this.dragEnd(w, e, this.lastDropTargetAction != 0, this.lastDropTargetAction);
            } else if (e.getID() == 506) {
                this.updateCursor();
                String winId = Util.getPeerForTarget(w) == null ? null : Util.getPeerForTarget(w).getGuid();
                Util.getWebToolkit().getPaintDispatcher().notifyCursorUpdate(cursor, null, winId);
            }
        } else if (e instanceof KeyEvent && e.getID() == 401 && ((KeyEvent)e).getKeyCode() == 27) {
            this.enteredComponent = null;
            this.dragEnd(w, e, false, 0);
        }
    }

    private void updateCursor() {
        try {
            switch (this.lastDropTargetAction) {
                case 0: {
                    cursor = Cursor.getSystemCustomCursor("Invalid.32x32");
                    break;
                }
                case 1: {
                    cursor = Cursor.getSystemCustomCursor("CopyDrop.32x32");
                    break;
                }
                case 0x40000000: {
                    cursor = Cursor.getSystemCustomCursor("LinkDrop.32x32");
                    break;
                }
                default: {
                    cursor = Cursor.getSystemCustomCursor("MoveDrop.32x32");
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.debug("Failed to load DnD cursor", e);
        }
    }

    public void dragStart(WebDragSourceContextPeer dragSource, Transferable transferable, int actions, long[] formats) {
        this.dragSource = dragSource;
        this.formats = formats;
        this.sourceActions = actions;
        this.dropTarget = WebDropTargetContextPeer.getWebDropTargetContextPeer();
        this.dropped = false;
        this.finished = false;
        this.enteredComponent = null;
    }

    private void dragEnd(Window w, AWTEvent e, boolean supported, int dropAction) {
        if (!this.finished) {
            if (e instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e;
                if (w != null) {
                    if (supported && !this.dropped) {
                        this.dropTarget.setDragSource(this.dragSource);
                        this.dropTarget.handleDropMessage(w, me.getX(), me.getY(), this.lastDropTargetAction, this.sourceActions, this.formats, 123123123L);
                        this.dropped = true;
                    } else {
                        this.dropTarget.handleExitMessage(w, 123123123L);
                        this.dragSource.dragFinished(false, dropAction, me.getX(), me.getY());
                    }
                }
            } else {
                this.dropTarget.handleExitMessage(w, 123123123L);
                this.dragSource.dragFinished(false, dropAction, 0, 0);
            }
            this.finished = true;
        }
        this.sourceActions = 0;
        this.lastDropTargetAction = 0;
        cursor = Cursor.getDefaultCursor();
    }

    public static Cursor getCurrentDropTargetCursorName() {
        return cursor;
    }

    public boolean isDndInProgress() {
        return !this.finished;
    }
}

