/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashPrintJobAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.TextSyntax;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobOriginatingUserName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import org.webswing.toolkit.WebPrintService;

public class WebPrintJob
implements DocPrintJob {
    private static final int JOB_COMPLETED = 102;
    private static final int JOB_NOMOREEVENTS = 105;
    private static final int JOB_DATA_TRANSFER_COMPLETED = 106;
    private static final int JOB_FAILED = 103;
    private static final int JOB_CANCELED = 101;
    private transient List<PrintJobListener> jobListeners;
    private PrintJobAttributeSet jobAttrSet = null;
    private WebPrintService service;
    private boolean printing;
    private PrinterJob job;
    private MediaSize mediaSize = MediaSize.NA.LETTER;
    private OrientationRequested orient = OrientationRequested.PORTRAIT;
    private HashPrintRequestAttributeSet reqAttrSet;

    public WebPrintJob(WebPrintService webPrintService) {
        this.service = webPrintService;
    }

    @Override
    public void addPrintJobAttributeListener(PrintJobAttributeListener listener, PrintJobAttributeSet attributes) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintJobListener(PrintJobListener listener) {
        WebPrintJob webPrintJob = this;
        synchronized (webPrintJob) {
            if (listener == null) {
                return;
            }
            if (this.jobListeners == null) {
                this.jobListeners = new ArrayList<PrintJobListener>();
            }
            this.jobListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintJobAttributeSet getAttributes() {
        WebPrintJob webPrintJob = this;
        synchronized (webPrintJob) {
            if (this.jobAttrSet == null) {
                HashPrintJobAttributeSet localHashPrintJobAttributeSet = new HashPrintJobAttributeSet();
                return AttributeSetUtilities.unmodifiableView(localHashPrintJobAttributeSet);
            }
            return this.jobAttrSet;
        }
    }

    @Override
    public PrintService getPrintService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Doc doc, PrintRequestAttributeSet attributes) throws PrintException {
        WebPrintJob webPrintJob = this;
        synchronized (webPrintJob) {
            if (this.printing) {
                throw new PrintException("already printing");
            }
            this.printing = true;
        }
        DocFlavor flavor = doc.getDocFlavor();
        try {
            doc.getPrintData();
        }
        catch (IOException localIOException1) {
            this.notifyEvent(103);
            throw new PrintException("can't get print data: " + localIOException1.toString());
        }
        if (flavor == null || !this.service.isDocFlavorSupported(flavor)) {
            this.notifyEvent(103);
            throw new PrintException("invalid flavor");
        }
        this.initializeAttributeSets(doc, attributes);
        this.getAttributeValues(flavor);
        String str = flavor.getRepresentationClassName();
        if (str.equals("java.awt.print.Pageable")) {
            try {
                this.pageableJob((Pageable)doc.getPrintData(), attributes);
                return;
            }
            catch (ClassCastException localClassCastException3) {
                this.notifyEvent(103);
                throw new PrintException(localClassCastException3);
            }
            catch (IOException localIOException3) {
                this.notifyEvent(103);
                throw new PrintException(localIOException3);
            }
        }
        if (str.equals("java.awt.print.Printable")) {
            try {
                this.printableJob((Printable)doc.getPrintData(), attributes);
                return;
            }
            catch (ClassCastException localClassCastException4) {
                this.notifyEvent(103);
                throw new PrintException(localClassCastException4);
            }
            catch (IOException localIOException4) {
                this.notifyEvent(103);
                throw new PrintException(localIOException4);
            }
        }
        this.notifyEvent(103);
        throw new PrintException("unrecognized class: " + str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printableJob(Printable printData, PrintRequestAttributeSet attributes) throws PrintException {
        try {
            WebPrintJob webPrintJob = this;
            synchronized (webPrintJob) {
                if (this.job != null) {
                    throw new PrintException("already printing");
                }
                this.job = PrinterJob.getPrinterJob();
            }
            this.job.setPrintService(this.getPrintService());
            PageFormat pf = new PageFormat();
            if (this.mediaSize != null) {
                Paper localPaper = new Paper();
                localPaper.setSize((double)this.mediaSize.getX(25400) * 72.0, (double)this.mediaSize.getY(25400) * 72.0);
                localPaper.setImageableArea(72.0, 72.0, localPaper.getWidth() - 144.0, localPaper.getHeight() - 144.0);
                pf.setPaper(localPaper);
            }
            if (this.orient == OrientationRequested.REVERSE_LANDSCAPE) {
                pf.setOrientation(2);
            } else if (this.orient == OrientationRequested.LANDSCAPE) {
                pf.setOrientation(0);
            }
            this.job.setPrintable(printData);
            this.job.print(attributes);
            this.notifyEvent(102);
        }
        catch (PrinterException localPrinterException) {
            this.notifyEvent(103);
            throw new PrintException(localPrinterException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pageableJob(Pageable printData, PrintRequestAttributeSet attributes) throws PrintException {
        try {
            WebPrintJob webPrintJob = this;
            synchronized (webPrintJob) {
                if (this.job != null) {
                    throw new PrintException("already printing");
                }
                this.job = PrinterJob.getPrinterJob();
            }
            this.job.setPrintService(this.getPrintService());
            this.job.setPageable(printData);
            this.job.print(attributes);
            this.notifyEvent(102);
        }
        catch (PrinterException localPrinterException) {
            this.notifyEvent(103);
            throw new PrintException(localPrinterException);
        }
    }

    @Override
    public void removePrintJobAttributeListener(PrintJobAttributeListener listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintJobListener(PrintJobListener listener) {
        WebPrintJob webPrintJob = this;
        synchronized (webPrintJob) {
            if (listener == null || this.jobListeners == null) {
                return;
            }
            this.jobListeners.remove(listener);
            if (this.jobListeners.isEmpty()) {
                this.jobListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvent(int eventType) {
        WebPrintJob webPrintJob = this;
        synchronized (webPrintJob) {
            if (this.jobListeners != null) {
                PrintJobEvent jobEvent = new PrintJobEvent(this, eventType);
                block10: for (int i = 0; i < this.jobListeners.size(); ++i) {
                    PrintJobListener listener = this.jobListeners.get(i);
                    switch (eventType) {
                        case 101: {
                            listener.printJobCanceled(jobEvent);
                            continue block10;
                        }
                        case 103: {
                            listener.printJobFailed(jobEvent);
                            continue block10;
                        }
                        case 106: {
                            listener.printDataTransferCompleted(jobEvent);
                            continue block10;
                        }
                        case 105: {
                            listener.printJobNoMoreEvents(jobEvent);
                            continue block10;
                        }
                        case 102: {
                            listener.printJobCompleted(jobEvent);
                        }
                    }
                }
            }
        }
    }

    private synchronized void initializeAttributeSets(Doc paramDoc, PrintRequestAttributeSet paramPrintRequestAttributeSet) {
        TextSyntax localObject1;
        DocAttributeSet localDocAttributeSet;
        Attribute[] arrayOfAttribute;
        this.reqAttrSet = new HashPrintRequestAttributeSet();
        this.jobAttrSet = new HashPrintJobAttributeSet();
        if (paramPrintRequestAttributeSet != null) {
            this.reqAttrSet.addAll(paramPrintRequestAttributeSet);
            arrayOfAttribute = paramPrintRequestAttributeSet.toArray();
            for (int i = 0; i < arrayOfAttribute.length; ++i) {
                if (!(arrayOfAttribute[i] instanceof PrintJobAttribute)) continue;
                this.jobAttrSet.add(arrayOfAttribute[i]);
            }
        }
        if ((localDocAttributeSet = paramDoc.getAttributes()) != null) {
            arrayOfAttribute = localDocAttributeSet.toArray();
            for (int j = 0; j < arrayOfAttribute.length; ++j) {
                if (arrayOfAttribute[j] instanceof PrintRequestAttribute) {
                    this.reqAttrSet.add(arrayOfAttribute[j]);
                }
                if (!(arrayOfAttribute[j] instanceof PrintJobAttribute)) continue;
                this.jobAttrSet.add(arrayOfAttribute[j]);
            }
        }
        String str = "";
        try {
            str = System.getProperty("user.name");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (str == null || str.equals("")) {
            localObject1 = (RequestingUserName)paramPrintRequestAttributeSet.get(RequestingUserName.class);
            if (localObject1 != null) {
                this.jobAttrSet.add(new JobOriginatingUserName(localObject1.getValue(), localObject1.getLocale()));
            } else {
                this.jobAttrSet.add(new JobOriginatingUserName("", null));
            }
        } else {
            this.jobAttrSet.add(new JobOriginatingUserName(str, null));
        }
        if (this.jobAttrSet.get(JobName.class) == null) {
            if (localDocAttributeSet != null && localDocAttributeSet.get(DocumentName.class) != null) {
                DocumentName localObject2 = (DocumentName)localDocAttributeSet.get(DocumentName.class);
                localObject1 = new JobName(localObject2.getValue(), localObject2.getLocale());
                this.jobAttrSet.add((Attribute)((Object)localObject1));
            } else {
                String localObject2 = "JPS Job:" + paramDoc;
                try {
                    Object localObject3 = paramDoc.getPrintData();
                    if (localObject3 instanceof URL) {
                        localObject2 = ((URL)paramDoc.getPrintData()).toString();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                localObject1 = new JobName(localObject2, null);
                this.jobAttrSet.add((Attribute)((Object)localObject1));
            }
        }
        this.jobAttrSet = AttributeSetUtilities.unmodifiableView(this.jobAttrSet);
    }

    private void getAttributeValues(DocFlavor paramDocFlavor) throws PrintException {
        Attribute[] arrayOfAttribute = this.reqAttrSet.toArray();
        for (int i = 0; i < arrayOfAttribute.length; ++i) {
            Attribute localAttribute = arrayOfAttribute[i];
            Class<? extends Attribute> localClass = localAttribute.getCategory();
            if (localClass == Media.class) {
                if (!(localAttribute instanceof MediaSizeName) || !this.service.isAttributeValueSupported(localAttribute, null, null)) continue;
                this.mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)localAttribute);
                continue;
            }
            if (localClass != OrientationRequested.class) continue;
            this.orient = (OrientationRequested)localAttribute;
        }
    }
}

