/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import org.webswing.model.c2s.PasteEventMsgIn;
import org.webswing.toolkit.WebClipboard;
import org.webswing.toolkit.api.clipboard.BrowserTransferable;
import org.webswing.toolkit.util.Services;

public class WebClipboardTransferable
implements BrowserTransferable {
    private Image image;
    private String text;
    private String html;

    public WebClipboardTransferable(PasteEventMsgIn paste) {
        if (paste != null) {
            if (paste.getImg() != null) {
                this.image = Services.getImageService().readFromDataUrl(paste.getImg());
            }
            this.text = paste.getText();
            this.html = paste.getHtml();
        }
    }

    public boolean isEmpty() {
        return this.image == null && this.text == null && this.html == null;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (this.isDataFlavorSupported(flavor)) {
            if (DataFlavor.imageFlavor.equals(flavor)) {
                return this.image;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return this.text;
            }
            if (WebClipboard.HTML_FLAVOR.equals(flavor)) {
                return this.html;
            }
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (DataFlavor.imageFlavor.equals(flavor)) {
            return this.image != null;
        }
        if (DataFlavor.stringFlavor.equals(flavor)) {
            return this.text != null;
        }
        if (WebClipboard.HTML_FLAVOR.equals(flavor)) {
            return this.html != null;
        }
        return false;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.imageFlavor, DataFlavor.stringFlavor, WebClipboard.HTML_FLAVOR};
    }

    public Image getImage() {
        return this.image;
    }

    public String getText() {
        return this.text;
    }

    public String getHtml() {
        return this.html;
    }
}

