/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.model.s2c;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.webswing.model.Msg;

public class FileDialogEventMsg
implements Msg {
    private static final long serialVersionUID = -7470385173647106699L;
    private FileDialogEventType eventType;
    private boolean allowDownload;
    private boolean allowUpload;
    private boolean allowDelete;
    private boolean customDialog;
    private String selection;
    private String filter = "";
    private boolean isMultiSelection;

    public FileDialogEventMsg() {
        this(null);
    }

    public FileDialogEventMsg(JFileChooser chooser) {
        if (chooser != null) {
            Boolean downloadOverride = (Boolean)chooser.getClientProperty("webswing.allowDownload");
            Boolean uploadOverride = (Boolean)chooser.getClientProperty("webswing.allowUpload");
            Boolean deleteOverride = (Boolean)chooser.getClientProperty("webswing.allowDelete");
            this.allowDownload = downloadOverride != null ? downloadOverride : Boolean.valueOf(System.getProperty("webswing.allowDownload"));
            this.allowUpload = uploadOverride != null ? uploadOverride : Boolean.valueOf(System.getProperty("webswing.allowUpload"));
            this.allowDelete = deleteOverride != null ? deleteOverride : Boolean.valueOf(System.getProperty("webswing.allowDelete"));
            Boolean customDialog = (Boolean)chooser.getClientProperty("webswing.customFileChooser");
            this.customDialog = customDialog != null ? customDialog : false;
        }
    }

    public void addFilter(FileFilter[] filterArr) {
        for (FileFilter ff : filterArr) {
            if (!(ff instanceof FileNameExtensionFilter)) continue;
            FileNameExtensionFilter fe = (FileNameExtensionFilter)ff;
            for (String s : fe.getExtensions()) {
                this.filter = this.filter + "." + s + ", ";
            }
        }
        if (this.filter.length() > 2) {
            this.filter = this.filter.substring(0, this.filter.length() - 2);
        }
    }

    public FileDialogEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(FileDialogEventType eventType) {
        this.eventType = eventType;
    }

    public boolean isAllowDownload() {
        return this.allowDownload;
    }

    public void setAllowDownload(boolean allowDownload) {
        this.allowDownload = allowDownload;
    }

    public boolean isAllowUpload() {
        return this.allowUpload;
    }

    public void setAllowUpload(boolean allowUpload) {
        this.allowUpload = allowUpload;
    }

    public boolean isAllowDelete() {
        return this.allowDelete;
    }

    public void setAllowDelete(boolean allowDelete) {
        this.allowDelete = allowDelete;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public boolean isMultiSelection() {
        return this.isMultiSelection;
    }

    public void setMultiSelection(boolean isMultiSelection) {
        this.isMultiSelection = isMultiSelection;
    }

    public String getSelection() {
        return this.selection;
    }

    public void setSelection(String selection) {
        this.selection = selection;
    }

    public boolean isCustomDialog() {
        return this.customDialog;
    }

    public void setCustomDialog(boolean customDialog) {
        this.customDialog = customDialog;
    }

    public static enum FileDialogEventType {
        AutoUpload,
        AutoSave,
        Open,
        Close;

    }
}

