/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.dispatch;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.webswing.dispatch.AbstractPaintDispatcher;
import org.webswing.model.s2c.AppFrameMsgOut;
import org.webswing.model.s2c.WindowMoveActionMsg;
import org.webswing.toolkit.WebComponentPeer;
import org.webswing.toolkit.WebToolkit;
import org.webswing.toolkit.WebWindowPeer;
import org.webswing.toolkit.api.component.HtmlPanel;
import org.webswing.toolkit.extra.WebRepaintManager;
import org.webswing.toolkit.extra.WindowManager;
import org.webswing.toolkit.util.Logger;
import org.webswing.toolkit.util.Util;

public class WebPaintDispatcher
extends AbstractPaintDispatcher {
    private volatile WindowMoveActionMsg moveAction;

    public WebPaintDispatcher() {
        Runnable sendUpdate = () -> {
            try {
                AppFrameMsgOut json;
                if (!this.isClientReadyToReceiveOrResetAfterTimedOut()) {
                    return;
                }
                Map<String, Map<Integer, BufferedImage>> windowImages = null;
                Map<String, Image> windowWebImages = null;
                Object object = Util.getWebToolkit().getTreeLock();
                synchronized (object) {
                    Object object2 = webPaintLock;
                    synchronized (object2) {
                        WebRepaintManager.processDirtyComponents();
                        Map<String, Set<Rectangle>> currentAreasToUpdate = this.popProcessableDirtyAreas();
                        if (currentAreasToUpdate.isEmpty() && !this.hasMoveAction()) {
                            return;
                        }
                        json = Util.fillWithWindowsData(currentAreasToUpdate);
                        if (Util.isDD()) {
                            windowWebImages = Util.extractWindowWebImages(currentAreasToUpdate.keySet(), new HashMap<String, Image>());
                        } else {
                            windowImages = Util.extractWindowImages(json, new HashMap<String, Map<Integer, BufferedImage>>());
                        }
                        this.fillMoveAction(json);
                        this.fillFocusEvent(json);
                        this.setClientNotReady();
                    }
                }
                Logger.trace("contentSender:paintJson", json);
                if (Util.isDD()) {
                    Logger.trace("contentSender:pngWebImageEncodingStart", json.hashCode());
                    Util.encodeWindowWebImages(windowWebImages, json);
                    Logger.trace("contentSender:pngWebImageEncodingDone", json.hashCode());
                } else {
                    Logger.trace("contentSender:pngEncodingStart", json.hashCode());
                    Util.encodeWindowImages(windowImages, json);
                    Logger.trace("contentSender:pngEncodingDone", json.hashCode());
                }
                json.setDirectDraw(Util.isDD());
                json.setCompositingWM(Util.isCompositingWM());
                json.setSendTimestamp("" + System.currentTimeMillis());
                this.sendObject(json);
            }
            catch (Throwable e) {
                Logger.error("contentSender:error", e);
            }
        };
        Integer delay = Integer.getInteger("webswing.drawDelayMs", 33);
        this.getExecutorService().scheduleWithFixedDelay(sendUpdate, delay.intValue(), delay.intValue(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void notifyWindowAreaRepainted(String guid, Rectangle repaintedArea) {
        this.addDirtyArea(guid, repaintedArea);
    }

    @Override
    public void notifyWindowAreaVisible(String guid, Rectangle visibleArea) {
        this.addDirtyArea(guid, visibleArea);
    }

    @Override
    public void notifyWindowBoundsChanged(String guid, Rectangle newBounds) {
    }

    @Override
    public void notifyWindowActivated(Window activeWindow) {
        WebComponentPeer activeWindowPeer = (WebComponentPeer)WebToolkit.targetToPeer(activeWindow);
        activeWindowPeer.updateWindowDecorationImage();
        this.addDirtyArea(activeWindow);
    }

    @Override
    public void notifyWindowDeactivated(Window oldActiveWindow) {
        WebComponentPeer oldActiveWindowPeer = (WebComponentPeer)WebToolkit.targetToPeer(oldActiveWindow);
        oldActiveWindowPeer.updateWindowDecorationImage();
        this.addDirtyArea(oldActiveWindow);
    }

    @Override
    public void notifyWindowZOrderChanged(Window w) {
        w.repaint();
        this.addDirtyArea(w);
    }

    @Override
    public void notifyWindowMaximized(JFrame target) {
        JFrame f = target;
        f.setLocation(0, 0);
        Dimension originalSize = f.getSize();
        Dimension newSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (!originalSize.equals(newSize)) {
            SwingUtilities.invokeLater(() -> f.setSize(newSize));
        }
    }

    @Override
    public void notifyBackgroundAreaVisible(Rectangle toRepaint) {
        this.addDirtyArea("BG", toRepaint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyWindowMoved(Window w, int zIndex, Rectangle from, Rectangle to) {
        if (zIndex == 0 && w.getWidth() == from.width && w.getHeight() == from.height) {
            Object object = webPaintLock;
            synchronized (object) {
                if (!this.hasMoveAction()) {
                    this.setMoveAction(new WindowMoveActionMsg(from.x, from.y, to.x, to.y, from.width, from.height));
                    this.notifyRepaintOffScreenAreas(w, this.getMoveAction());
                } else if (this.getMoveAction().getDx() == from.x && this.getMoveAction().getDy() == from.y && this.getMoveAction().getWidth() == from.width && this.getMoveAction().getHeight() == from.height) {
                    this.getMoveAction().setDx(to.x);
                    this.getMoveAction().setDy(to.y);
                    this.notifyRepaintOffScreenAreas(w, this.getMoveAction());
                } else {
                    this.addDirtyArea(w);
                }
            }
        } else {
            this.addDirtyArea(w);
        }
    }

    private void notifyRepaintOffScreenAreas(Window w, WindowMoveActionMsg m) {
        Rectangle screen = new Rectangle(Util.getWebToolkit().getScreenSize());
        Rectangle before = new Rectangle(m.getSx(), m.getSy(), m.getWidth(), m.getHeight());
        Rectangle after = new Rectangle(m.getDx(), m.getDy(), m.getWidth(), m.getHeight());
        int xdiff = m.getSx() - m.getDx();
        int ydiff = m.getSy() - m.getDy();
        Rectangle[] invisibleBefore = SwingUtilities.computeDifference(before, screen);
        if (invisibleBefore.length != 0) {
            for (Rectangle r : invisibleBefore) {
                r.setLocation(r.x - xdiff, r.y - ydiff);
            }
            Rectangle[] invisibleAfter = SwingUtilities.computeDifference(after, screen);
            List<Rectangle> toRepaint = Util.joinRectangles(Util.getGrid(Arrays.asList(invisibleBefore), Arrays.asList(invisibleAfter)));
            WebWindowPeer peer = (WebWindowPeer)WebToolkit.targetToPeer(w);
            for (Rectangle r : toRepaint) {
                r.setLocation(r.x - w.getX(), r.y - w.getY());
                this.addDirtyArea(peer.getGuid(), r);
            }
        }
    }

    @Override
    public void registerWebContainer(Container container) {
        throw new UnsupportedOperationException("Only supported when Composition Window Manager is enabled");
    }

    @Override
    public Map<Window, List<Container>> getRegisteredWebContainersAsMap() {
        throw new UnsupportedOperationException("Only supported when Composition Window Manager is enabled");
    }

    @Override
    public void registerHtmlPanel(HtmlPanel hp) {
        throw new UnsupportedOperationException("Only supported when Composition Window Manager is enabled");
    }

    @Override
    public Map<Window, List<HtmlPanel>> getRegisteredHtmlPanelsAsMap() {
        throw new UnsupportedOperationException("Only supported when Composition Window Manager is enabled");
    }

    @Override
    public HtmlPanel findHtmlPanelById(String id) {
        throw new UnsupportedOperationException("Only supported when Composition Window Manager is enabled");
    }

    @Override
    public void notifyWindowDockStateChanged() {
        throw new UnsupportedOperationException("Only supported when Composition Window Manager is enabled");
    }

    private void fillMoveAction(AppFrameMsgOut json) {
        if (this.moveAction != null) {
            json.setMoveAction(this.moveAction);
            this.moveAction = null;
        }
    }

    protected boolean hasMoveAction() {
        return this.moveAction != null;
    }

    protected WindowMoveActionMsg getMoveAction() {
        return this.moveAction;
    }

    protected void setMoveAction(WindowMoveActionMsg moveAction) {
        this.moveAction = moveAction;
    }

    @Override
    protected String getCurrentCursor(String winId) {
        return WindowManager.getInstance().getCurrentCursor();
    }

    @Override
    protected void setCurrentCursor(String winId, String cursor) {
        WindowManager.getInstance().setCurrentCursor(cursor);
    }
}

