/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.audio;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.webswing.audio.NullAudioFileFormat;

public class AudioFileReader
extends javax.sound.sampled.spi.AudioFileReader {
    private AudioFileFormat fileFormat = new NullAudioFileFormat();

    @Override
    public AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        return this.fileFormat;
    }

    @Override
    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        try (InputStream stream = url.openStream();){
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(stream);
            return audioFileFormat;
        }
    }

    @Override
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(stream);
            return audioFileFormat;
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        return new AudioInputStream(stream, this.fileFormat.getFormat(), -1L);
    }

    @Override
    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream urlStream = url.openStream();
        try {
            return this.getAudioInputStream(new BufferedInputStream(urlStream));
        }
        catch (Throwable e) {
            try {
                urlStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileStream = new FileInputStream(file);
        try {
            return this.getAudioInputStream(new BufferedInputStream(fileStream));
        }
        catch (Throwable e) {
            try {
                ((InputStream)fileStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }
}

