/*
 * Decompiled with CFR 0.152.
 */
package sharptools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import sharptools.CellPoint;
import sharptools.CellRange;
import sharptools.Debug;
import sharptools.History;
import sharptools.Node;
import sharptools.SharpOptionPane;
import sharptools.SharpTableModel;
import sharptools.SharpTools;
import sharptools.SortDialog;

public class TableOp
implements ActionListener {
    private SharpTools sharp;
    private JTable table;
    private SharpTableModel tableModel;
    private History history;
    private JToolBar toolBar;
    private static final ImageIcon colwidthIcon = SharpTools.getImageIcon("colwidth.gif");

    TableOp(SharpTools sharp) {
        this.init(sharp);
        sharp.checkFindNextState();
        KeyStroke insertrow = KeyStroke.getKeyStroke(155, 2, false);
        KeyStroke insertcolumn = KeyStroke.getKeyStroke(155, 3, false);
        KeyStroke deleterow = KeyStroke.getKeyStroke(127, 2, false);
        KeyStroke deletecolumn = KeyStroke.getKeyStroke(127, 3, false);
        this.table.registerKeyboardAction(this, "Insert Row", insertrow, 0);
        this.table.registerKeyboardAction(this, "Insert Column", insertcolumn, 0);
        this.table.registerKeyboardAction(this, "Delete Row", deleterow, 0);
        this.table.registerKeyboardAction(this, "Delete Column", deletecolumn, 0);
    }

    private void init(SharpTools sharp) {
        this.sharp = sharp;
        this.table = sharp.getTable();
        this.tableModel = sharp.getTableModel();
        this.history = sharp.getHistory();
        this.toolBar = sharp.getToolBar();
    }

    public void insert(boolean byRow) {
        int insertNum = this.table.getSelectedRowCount();
        if (insertNum != 0) {
            if (byRow) {
                int row = this.table.getSelectedRow();
                CellRange range = new CellRange(new CellPoint(row, SharpTools.baseCol), new CellPoint(row + insertNum - 1, this.tableModel.getColumnCount() - 1));
                this.history.add(this.tableModel, range, 1);
                this.tableModel.insertRow(range);
            } else {
                insertNum = this.table.getSelectedColumnCount();
                int column = this.table.getSelectedColumn();
                CellRange range = new CellRange(new CellPoint(SharpTools.baseRow, column), new CellPoint(this.tableModel.getRowCount() - 1, column + insertNum - 1));
                this.history.add(this.tableModel, range, 2);
                this.tableModel.insertColumn(range);
            }
        } else {
            this.sharp.noCellsSelected("Insert");
        }
    }

    public void remove(boolean byRow) {
        int removeNum = this.table.getSelectedRowCount();
        if (removeNum != 0) {
            if (byRow) {
                if (removeNum == this.table.getRowCount() - 1) {
                    this.tooMuchDeletion();
                    return;
                }
                int row = this.table.getSelectedRow();
                CellRange range = new CellRange(new CellPoint(row, SharpTools.baseCol), new CellPoint(row + removeNum - 1, this.tableModel.getColumnCount() - 1));
                if (this.tableModel.isDeletionSafe(range, true) || this.unsafeDeletion()) {
                    this.history.add(this.tableModel, range, 3);
                    Debug.println(range);
                    this.tableModel.removeRow(range);
                    Debug.println("Delete row range " + range);
                }
            } else {
                int column = this.table.getSelectedColumn();
                removeNum = this.table.getSelectedColumnCount();
                if (removeNum == this.table.getColumnCount() - 1) {
                    this.tooMuchDeletion();
                    return;
                }
                CellRange range = new CellRange(new CellPoint(SharpTools.baseRow, column), new CellPoint(this.tableModel.getRowCount() - 1, column + removeNum - 1));
                Debug.println("Delete column range " + range);
                if (this.tableModel.isDeletionSafe(range, false) || this.unsafeDeletion()) {
                    this.history.add(this.tableModel, range, 4);
                    Debug.println(range);
                    this.tableModel.removeColumn(range);
                }
            }
        } else {
            this.sharp.noCellsSelected("Remove");
        }
    }

    public void sort(boolean byRow) {
        if (this.table.getSelectedRowCount() != 0) {
            int i;
            CellRange range = new CellRange(this.table.getSelectedRows(), this.table.getSelectedColumns());
            Vector<String> primary = new Vector<String>();
            Vector<String> secondary = new Vector<String>();
            secondary.add("None");
            if (byRow) {
                for (i = range.getStartRow(); i <= range.getEndRow(); ++i) {
                    primary.add("Row " + Node.translateRow(i));
                    secondary.add("Row " + Node.translateRow(i));
                }
            } else {
                for (i = range.getStartCol(); i <= range.getEndCol(); ++i) {
                    primary.add("Column " + Node.translateColumn(i));
                    secondary.add("Column " + Node.translateColumn(i));
                }
            }
            SortDialog sortDialog = new SortDialog(this.sharp, primary, secondary);
            sortDialog.pack();
            sortDialog.setLocationRelativeTo(this.sharp);
            sortDialog.setVisible(true);
            Debug.println("Here we go " + sortDialog.getCriteriaA() + ": And : " + sortDialog.getCriteriaB());
            Debug.println(sortDialog.firstAscending() + " : " + sortDialog.secondAscending());
            int first = sortDialog.getCriteriaA();
            if (first >= 0) {
                this.history.add(this.tableModel, range);
                first = byRow ? (first += range.getStartRow()) : (first += range.getStartCol());
                int second = sortDialog.getCriteriaB();
                if (second > 0) {
                    second = byRow ? (second += range.getStartRow() - 1) : (second += range.getStartCol() - 1);
                    this.tableModel.sort(range, first, second, byRow, sortDialog.firstAscending(), sortDialog.secondAscending());
                } else {
                    this.tableModel.sort(range, first, first, byRow, sortDialog.firstAscending(), sortDialog.secondAscending());
                }
            }
        } else {
            this.sharp.noCellsSelected("Sort");
        }
    }

    public void setColumnWidth() {
        int width = SharpTools.getConfig().getInt("COLUMNWIDTH");
        Integer input = SharpOptionPane.showIntegerInputDialog(this.sharp, "Please input the column width in pixels: ", "Column Width", 3, colwidthIcon, new Integer(width));
        if (input != null) {
            try {
                int newwidth = input;
                if (newwidth != width && newwidth >= 0) {
                    SharpTools.getConfig().setInt("COLUMNWIDTH", newwidth);
                    this.sharp.setColumnWidth(newwidth);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean unsafeDeletion() {
        int choice = SharpOptionPane.showOptionDialog(this.sharp, "The deletion may cause irriversible data loss in other cells.\n\nDo you really want to proceed?\n\n", "Delete", 0, 2, null, 1);
        return choice == 0;
    }

    private void tooMuchDeletion() {
        SharpOptionPane.showMessageDialog(this.sharp, "You can not delete all the rows or columns!", "Delete", 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().compareTo("Insert Row") == 0) {
            this.insert(true);
        } else if (e.getActionCommand().compareTo("Insert Column") == 0) {
            this.insert(false);
        } else if (e.getActionCommand().compareTo("Delete Row") == 0) {
            this.remove(true);
        } else if (e.getActionCommand().compareTo("Delete Column") == 0) {
            this.remove(false);
        }
    }
}

