/*
 * Decompiled with CFR 0.152.
 */
package sharptools;

import java.util.LinkedList;
import sharptools.CellPoint;
import sharptools.Formula;
import sharptools.Function;
import sharptools.Node;
import sharptools.ParserException;
import sharptools.SharpTableModel;

class FunctionSum
extends Function {
    FunctionSum() {
    }

    @Override
    public Number evaluate(SharpTableModel table, Node node, int row, int col) throws ParserException {
        this.checkParamsExist(node);
        float sum = 0.0f;
        LinkedList params = node.getParams();
        if (params != null) {
            for (Node exp : params) {
                if (this.isRange(exp)) {
                    CellPoint[] addr = this.getFirst(exp).getAddressRange(row, col);
                    for (int i = addr[0].getRow(); i <= addr[1].getRow(); ++i) {
                        for (int j = addr[0].getCol(); j <= addr[1].getCol(); ++j) {
                            sum += table.getNumericValueAt(i, j).floatValue();
                        }
                    }
                    continue;
                }
                sum += Formula.evaluate(table, exp.getExp(), row, col).floatValue();
            }
        }
        return new Float(sum);
    }

    @Override
    public String getUsage() {
        return "SUM(value1,value2,...)";
    }

    @Override
    public String getDescription() {
        return "Adds all the numbers in a set of values.";
    }
}

