/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jfree.report.ElementAlignment;
import org.jfree.report.JFreeReport;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.PageFooter;
import org.jfree.report.PageHeader;
import org.jfree.report.ReportFooter;
import org.jfree.report.ReportHeader;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.SimplePageDefinition;
import org.jfree.report.TextElement;
import org.jfree.report.elementfactory.LabelElementFactory;
import org.jfree.report.elementfactory.StaticShapeElementFactory;
import org.jfree.report.elementfactory.TextFieldElementFactory;
import org.jfree.report.function.PageOfPagesFunction;
import org.jfree.report.modules.gui.base.PreviewDialog;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.FontDefinition;
import org.jfree.ui.FloatDimension;
import org.jfree.util.Log;

public class JFreeReportPrintUtil {
    public static void PrintControlTable(JTable tb, String reportHeaderText, String reportFooterText, String pageHeaderText, String pageFooterText) {
        TableModel tm = tb.getModel();
        TableColumnModel tcm = tb.getColumnModel();
        int numCols = tm.getColumnCount();
        if (0 == tm.getColumnCount()) {
            return;
        }
        JFreeReport report = new JFreeReport();
        report.setName(reportHeaderText);
        float width = report.getPageDefinition().getWidth();
        PageFormat ThisPageformat = new PageFormat();
        report.setPageDefinition(new SimplePageDefinition(ThisPageformat, (int)Math.ceil((double)numCols / ((double)width / 50.0)), 1));
        ReportHeader header = new ReportHeader();
        header.setName("Report-Header");
        header.getStyle().setStyleProperty(ElementStyleSheet.MINIMUMSIZE, new FloatDimension(0.0f, 5.0f));
        header.getStyle().setFontDefinitionProperty(new FontDefinition("Serif", 20, true, false, false, false));
        LabelElementFactory factory = new LabelElementFactory();
        factory.setName("Report-Header-Label");
        factory.setAbsolutePosition(new Point2D.Float(0.0f, 0.0f));
        factory.setMinimumSize((Dimension2D)new FloatDimension(-400.0f, 24.0f));
        factory.setHorizontalAlignment(ElementAlignment.CENTER);
        factory.setVerticalAlignment(ElementAlignment.MIDDLE);
        factory.setText(reportHeaderText);
        header.addElement(factory.createElement());
        report.setReportHeader(header);
        ReportFooter footer = new ReportFooter();
        footer.setName("Report-Footer");
        footer.getStyle().setStyleProperty(ElementStyleSheet.MINIMUMSIZE, new FloatDimension(0.0f, 4.0f));
        footer.getStyle().setFontDefinitionProperty(new FontDefinition("Serif", 12, true, false, false, false));
        LabelElementFactory rfFactory = new LabelElementFactory();
        rfFactory.setName("Report-Footer-Label");
        rfFactory.setAbsolutePosition(new Point2D.Float(0.0f, 0.0f));
        rfFactory.setMinimumSize((Dimension2D)new FloatDimension(-100.0f, 24.0f));
        rfFactory.setHorizontalAlignment(ElementAlignment.RIGHT);
        rfFactory.setVerticalAlignment(ElementAlignment.BOTTOM);
        rfFactory.setText(reportFooterText);
        footer.addElement(rfFactory.createElement());
        report.setReportFooter(footer);
        PageHeader pHeader = new PageHeader();
        pHeader.setName("Page-pHeader");
        rfFactory.setVerticalAlignment(ElementAlignment.TOP);
        rfFactory.setText(pageHeaderText);
        pHeader.addElement(rfFactory.createElement());
        pHeader.addElement(StaticShapeElementFactory.createHorizontalLine(null, null, new BasicStroke(1.0f), 24.0));
        pHeader.setDisplayOnFirstPage(true);
        report.setPageHeader(pHeader);
        PageFooter pageFooter = new PageFooter();
        pageFooter.getStyle().setStyleProperty(ElementStyleSheet.MINIMUMSIZE, new FloatDimension(0.0f, 24.0f));
        pageFooter.setName("Page-Footer");
        pageFooter.setDisplayOnFirstPage(true);
        pageFooter.setDisplayOnLastPage(true);
        PageOfPagesFunction pageFunction = new PageOfPagesFunction();
        pageFunction.setName("pageXofY");
        pageFunction.setFormat(pageFooterText + "  -  page {0} of {1}");
        report.addExpression(pageFunction);
        TextFieldElementFactory elementFactory = new TextFieldElementFactory();
        elementFactory.setAbsolutePosition(new Point2D.Float(0.0f, 0.0f));
        elementFactory.setMinimumSize((Dimension2D)new FloatDimension(-100.0f, 24.0f));
        elementFactory.setVerticalAlignment(ElementAlignment.MIDDLE);
        elementFactory.setHorizontalAlignment(ElementAlignment.RIGHT);
        elementFactory.setFieldname("pageXofY");
        pageFooter.addElement(elementFactory.createElement());
        report.setPageFooter(pageFooter);
        for (int i = 0; i < numCols; ++i) {
            TextElement t = TextFieldElementFactory.createStringElement("T" + i, new Rectangle2D.Double(50 * i, 0.0, 50.0, 20.0), Color.black, ElementAlignment.LEFT, ElementAlignment.MIDDLE, null, "-", tm.getColumnName(i));
            report.getItemBand().addElement(t);
        }
        report.setData(tm);
        try {
            PreviewDialog preview = new PreviewDialog(report);
            preview.pack();
            preview.setVisible(true);
        }
        catch (ReportProcessingException e) {
            Log.error((Object)"Failed to generate report ", (Exception)((Object)e));
        }
    }

    static {
        JFreeReportBoot.getInstance().start();
    }
}

