/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import java.util.Vector;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.FProbabilityDistribution;

public class OneWayANOVA {
    Vector<Vector<Double>> SamplesVectors;
    int k;
    int[] n;
    int N;
    double[] means;
    double[] stdevs;

    public OneWayANOVA(Vector<Vector<Double>> Samples) {
        this.SamplesVectors = Samples;
        this.k = Samples.size();
        this.n = new int[this.k];
        this.means = new double[this.k];
        this.stdevs = new double[this.k];
        this.N = 0;
        for (int i = 0; i < this.k; ++i) {
            Vector<Double> sample = Samples.elementAt(i);
            this.n[i] = sample.size();
            this.N += this.n[i];
            this.means[i] = BasicStatistics.mean(sample);
            this.stdevs[i] = BasicStatistics.stdev(sample);
        }
    }

    public double GrandMean() {
        double total = 0.0;
        for (int i = 0; i < this.k; ++i) {
            total += (double)this.n[i] * this.means[i];
        }
        return total / (double)this.N;
    }

    public double SSTreatment() {
        double sum = 0.0;
        double grandMean = this.GrandMean();
        for (int i = 0; i < this.k; ++i) {
            double diff = this.means[i] - grandMean;
            sum += (double)this.n[i] * diff * diff;
        }
        return sum;
    }

    public double MSTreatment() {
        return this.SSTreatment() / (double)(this.k - 1);
    }

    public double SSError() {
        double sum = 0.0;
        for (int i = 0; i < this.k; ++i) {
            sum += (double)(this.n[i] - 1) * Math.pow(this.stdevs[i], 2.0);
        }
        return sum;
    }

    public double MSError() {
        return this.SSError() / (double)(this.N - this.k);
    }

    public double SSTotal() {
        return this.SSTreatment() + this.SSError();
    }

    public double TestStatisticsF() {
        return this.MSTreatment() / this.MSError();
    }

    public int DOFTreatment() {
        return this.k - 1;
    }

    public int DOFError() {
        return this.N - this.k;
    }

    public int DOFTotal() {
        return this.DOFTreatment() + this.DOFError();
    }

    public double CriticalValue(double significance) {
        FProbabilityDistribution dist = new FProbabilityDistribution(this.DOFTreatment(), this.DOFError());
        double F = dist.inverseCumulativeProbability(1.0 - significance);
        return F;
    }

    public double PValue() {
        double ts = this.TestStatisticsF();
        FProbabilityDistribution dist = new FProbabilityDistribution(this.DOFTreatment(), this.DOFError());
        double area = dist.cumulativeProbability(ts);
        return 1.0 - area;
    }
}

