/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import org.statcato.statistics.ChiSquareProbabilityDistribution;
import org.statcato.statistics.inferential.HypothesisTest;
import org.statcato.utils.HelperFunctions;

public class HypothesisTest1Var {
    int n;
    double sigma2;
    double confidenceLevel;
    int testType;

    public HypothesisTest1Var(int n, double sigma2, double confidenceLevel, int testType) {
        this.n = n;
        this.sigma2 = sigma2;
        this.confidenceLevel = confidenceLevel;
        this.testType = testType;
    }

    public double testStatistics(double s2) {
        return (double)(this.n - 1) * s2 / this.sigma2;
    }

    public String criticalValue() {
        double alpha = 1.0 - this.confidenceLevel;
        ChiSquareProbabilityDistribution dist = new ChiSquareProbabilityDistribution(this.n - 1);
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(1.0 - alpha), 3);
        }
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(alpha), 3);
        }
        return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(alpha / 2.0), 3) + ", " + HelperFunctions.formatFloat(dist.inverseCumulativeProbability(1.0 - alpha / 2.0), 3);
    }

    public double pValue(double s2) {
        double ts = this.testStatistics(s2);
        ChiSquareProbabilityDistribution dist = new ChiSquareProbabilityDistribution(this.n - 1);
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return dist.cumulativeProbability(ts);
        }
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return 1.0 - dist.cumulativeProbability(ts);
        }
        double area = dist.cumulativeProbability(ts);
        if (area > 0.5) {
            area = 1.0 - area;
        }
        return 2.0 * area;
    }
}

