/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import org.statcato.statistics.NormalProbabilityDistribution;
import org.statcato.statistics.inferential.HypothesisTest;
import org.statcato.utils.HelperFunctions;

public class HypothesisTest1MeanSigmaKnown {
    int n;
    double mu;
    double sigma;
    double confidenceLevel;
    int testType;

    public HypothesisTest1MeanSigmaKnown(int n, double mu, double sigma, double confidenceLevel, int testType) {
        this.n = n;
        this.mu = mu;
        this.sigma = sigma;
        this.confidenceLevel = confidenceLevel;
        this.testType = testType;
    }

    public double testStatistics(double xBar) {
        return (xBar - this.mu) / (this.sigma / Math.sqrt(this.n));
    }

    public String criticalValue() {
        double alpha = 1.0 - this.confidenceLevel;
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(1.0 - alpha), 3);
        }
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(alpha), 3);
        }
        return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(alpha / 2.0), 3) + ", " + HelperFunctions.formatFloat(dist.inverseCumulativeProbability(1.0 - alpha / 2.0), 3);
    }

    public double pValue(double xBar) {
        double ts = this.testStatistics(xBar);
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return dist.cumulativeProbability(ts);
        }
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return 1.0 - dist.cumulativeProbability(ts);
        }
        double area = dist.cumulativeProbability(ts);
        if (area > 0.5) {
            area = 1.0 - area;
        }
        return 2.0 * area;
    }
}

