/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics;

import org.statcato.statistics.DiscreteProbabilityDistribution;

public class GeometricProbabilityDistribution
extends DiscreteProbabilityDistribution {
    double p;
    int type;
    public static int TYPEI = 1;
    public static int TYPEII = 2;

    public GeometricProbabilityDistribution(double p, int type) {
        this.p = p;
        this.type = type == TYPEI || type == TYPEII ? type : TYPEI;
    }

    @Override
    public double density(double x) {
        int k = (int)x;
        if (k <= 0 && this.type == TYPEI) {
            return 0.0;
        }
        if (k < 0 && this.type == TYPEII) {
            return 0.0;
        }
        if (this.type == TYPEI) {
            return Math.pow(1.0 - this.p, k - 1) * this.p;
        }
        return Math.pow(1.0 - this.p, k) * this.p;
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= 0.0 && this.type == TYPEI) {
            return 0.0;
        }
        if (x < 0.0 && this.type == TYPEII) {
            return 0.0;
        }
        if (this.type == TYPEI) {
            return 1.0 - Math.pow(1.0 - this.p, x);
        }
        return 1.0 - Math.pow(1.0 - this.p, x + 1.0);
    }

    public Double inverseCumulativeProbability(double area) {
        if (this.type == TYPEI) {
            return super.inverseCumulativeProbability(1.0, 1000000.0, 1.0E-4, area);
        }
        return super.inverseCumulativeProbability(0.0, 1000000.0, 1.0E-4, area);
    }
}

