/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.statcato.spreadsheet.Cell;
import org.statcato.utils.MultidimensionalHash;
import org.statcato.utils.MultidimensionalHashKey;

public class CrossTabulation {
    private MultidimensionalHash hash;
    private Vector<String> dimensions;
    private Vector<Vector<Cell>> allValues;
    private int numDimensions;

    public CrossTabulation(Vector<Vector<Cell>> values, Vector<String> dimensions) {
        this.numDimensions = dimensions.size();
        this.hash = new MultidimensionalHash(this.numDimensions);
        this.allValues = values;
        for (int j = 0; j < values.elementAt(0).size(); ++j) {
            Vector<Cell> obs = new Vector<Cell>();
            for (int i = 0; i < values.size(); ++i) {
                obs.addElement(values.elementAt(i).elementAt(j));
            }
            MultidimensionalHashKey key = new MultidimensionalHashKey(obs);
            this.hash.put(key);
        }
    }

    public String getTable(Vector<String> rows, Vector<String> columns) {
        int i;
        String s = "";
        int[] rowDimensions = new int[rows.size()];
        int[] colDimensions = new int[columns.size()];
        for (i = 0; i < rows.size(); ++i) {
            rowDimensions[i] = this.dimensions.indexOf(rows.elementAt(i));
        }
        for (i = 0; i < columns.size(); ++i) {
            colDimensions[i] = this.dimensions.indexOf(columns.elementAt(i));
        }
        s = s + "<table>";
        for (i = 0; i < rows.size(); ++i) {
            for (int j = 0; j < columns.size(); ++j) {
                Set<String> cati = this.getCategories(rowDimensions[i]);
                Set<String> catj = this.getCategories(colDimensions[j]);
            }
        }
        s = s + "</table>";
        return s;
    }

    private Set<String> getCategories(int index) {
        HashSet<String> categories = new HashSet<String>();
        Vector<Cell> values = this.allValues.elementAt(index);
        for (int i = 0; i < values.size(); ++i) {
            categories.add(values.elementAt(i).toString());
        }
        return categories;
    }
}

