/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics;

import org.statcato.statistics.DiscreteProbabilityDistribution;
import org.statcato.statistics.SpecialFunctions;

public class BinomialProbabilityDistribution
extends DiscreteProbabilityDistribution {
    int n;
    double p;
    double q;

    public BinomialProbabilityDistribution(int n, double p) {
        this.n = n;
        this.p = p;
        this.q = 1.0 - p;
    }

    @Override
    public double density(double x) {
        if (x < 0.0 || x > (double)this.n) {
            return 0.0;
        }
        int k = (int)x;
        return SpecialFunctions.binomialCoefficient(this.n, k) * Math.pow(this.p, k) * Math.pow(this.q, this.n - k);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (x >= (double)this.n) {
            return 1.0;
        }
        return 1.0 - SpecialFunctions.betai(x + 1.0, (double)this.n - x, this.p);
    }

    public Double inverseCumulativeProbability(double area) {
        return super.inverseCumulativeProbability(0.0, this.n, 1.0E-4, area);
    }
}

