/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.samplesize;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.statistics.inferential.SampleSizeDetermination;
import org.statcato.utils.HelperFunctions;

public class SampleSizeMeanDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JTextField ConfidenceTextField;
    private JTextField ErrorTextField;
    private JTextField EstimateTextField;
    private JButton OKButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;

    public SampleSizeMeanDialog(Frame parent, boolean modal, Statcato mTab) {
        super(parent, modal);
        this.app = mTab;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-sample-size-mean");
        this.name = "Sample Size Determination: 1-Population Mean";
        this.description = "For determining the sample size required to estimate a population mean.";
        this.helpStrings.add("Provide the confidence level, desired margin of error, and population standard deviation. ");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.ConfidenceTextField = new JTextField();
        this.EstimateTextField = new JTextField();
        this.ErrorTextField = new JTextField();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Sample Size Determination: 1-Population Mean");
        this.jLabel1.setText("Confidence Level:");
        this.jLabel3.setText("Standard Deviation:");
        this.jLabel5.setText("Margin of Error:");
        this.ConfidenceTextField.setText("0.95");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleSizeMeanDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleSizeMeanDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setText("0 - 1.00 (e.g. 0.95)");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel3).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ConfidenceTextField, -2, 90, -2).addComponent(this.EstimateTextField, -1, 99, Short.MAX_VALUE).addComponent(this.ErrorTextField, -1, 99, Short.MAX_VALUE)).addGap(6, 6, 6).addComponent(this.jLabel2).addContainerGap(21, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(93, 93, 93).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.CancelButton).addGap(109, 109, 109)));
        layout.linkSize(0, this.ConfidenceTextField, this.ErrorTextField, this.EstimateTextField);
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.ConfidenceTextField, -2, -1, -2).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.EstimateTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.ErrorTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 45, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap()));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("sample size-mean");
        double confidenceLevel = 0.0;
        double estimate = -1.0;
        double error = 0.0;
        try {
            confidenceLevel = Double.parseDouble(this.ConfidenceTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        try {
            estimate = Double.parseDouble(this.EstimateTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number for standard deviation.");
            return;
        }
        try {
            error = Double.parseDouble(this.ErrorTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid number for the margin of error.");
            return;
        }
        int n = SampleSizeDetermination.mean(1.0 - confidenceLevel, estimate, error);
        this.app.addLogHeading("Sample Size Determination: 1-Population Mean");
        this.app.addLogText("Confidence Level = " + HelperFunctions.formatFloat(confidenceLevel * 100.0, 2) + "%");
        this.app.addLogText("Standard Deviation = " + estimate + "");
        this.app.addLogText("Margin of Error = " + error + "");
        this.app.addLogText("<b>Sample Size = " + n + "</b>");
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

