/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.nonparametrics;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.inferential.nonparametrics.SignTest;
import org.statcato.utils.HelperFunctions;

public class SignTestDialog
extends StatcatoDialog {
    private JComboBox AltComboBox;
    private JButton CancelButton;
    private JComboBox ColumnComboBox;
    private JTextField HyMedianTextField;
    private JLabel NegativeLabel;
    private JTextField NumNegativeTextField;
    private JTextField NumPositiveTextField;
    private JButton OKButton;
    private JLabel PositiveLabel;
    private JRadioButton SampleRadioButton;
    private JRadioButton SummaryRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel3;

    public SignTestDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.app = (Statcato)parent;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        this.ParentSpreadsheet.populateComboBox(this.ColumnComboBox);
        ButtonGroup group = new ButtonGroup();
        group.add(this.SampleRadioButton);
        group.add(this.SummaryRadioButton);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-nonparam-signtest");
        this.name = "1-Sample Sign Test";
        this.description = "For performing the sign test.";
        this.helpStrings.add("If individual samples are entered in a single column of the datasheet, select the Samples in column: radio button, and select the column name in the drop-down menu.");
        this.helpStrings.add("To use summary statistics of the sample data, select the Summarized sample data: radio button, and input the number of positive and negative signs in the provided text fields.");
        this.helpStrings.add("Provide the alternative hypothesis.");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.NumPositiveTextField = new JTextField();
        this.ColumnComboBox = new JComboBox();
        this.PositiveLabel = new JLabel();
        this.SampleRadioButton = new JRadioButton();
        this.SummaryRadioButton = new JRadioButton();
        this.NegativeLabel = new JLabel();
        this.NumNegativeTextField = new JTextField();
        this.jPanel3 = new JPanel();
        this.AltComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.HyMedianTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("1-Sample Sign Test");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.NumPositiveTextField.setEnabled(false);
        this.PositiveLabel.setText("Number of positive (+):");
        this.PositiveLabel.setEnabled(false);
        this.SampleRadioButton.setSelected(true);
        this.SampleRadioButton.setText("Samples in column:");
        this.SampleRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SignTestDialog.this.SampleRadioButtonStateChanged(evt);
            }
        });
        this.SummaryRadioButton.setText("Summarized sample data:");
        this.SummaryRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SignTestDialog.this.SummaryRadioButtonStateChanged(evt);
            }
        });
        this.NegativeLabel.setText("Number of negative (-):");
        this.NegativeLabel.setEnabled(false);
        this.NumNegativeTextField.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.SampleRadioButton).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.PositiveLabel).addComponent(this.NegativeLabel).addComponent(this.SummaryRadioButton)).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.ColumnComboBox, 0, -1, Short.MAX_VALUE))).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.NumPositiveTextField).addComponent(this.NumNegativeTextField, -1, 94, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.SampleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ColumnComboBox, -2, -1, -2).addGap(7, 7, 7).addComponent(this.SummaryRadioButton).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.NegativeLabel).addComponent(this.NumNegativeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.PositiveLabel).addComponent(this.NumPositiveTextField, -2, -1, -2)).addContainerGap(31, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Alternative Hypothesis"));
        this.AltComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Less than", "Not Equal to", "Greater than"}));
        this.jLabel3.setText("Alternative hypothesis:");
        this.jLabel1.setText("Hypothesized median:");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.HyMedianTextField, -2, 82, -2)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.AltComboBox, -2, -1, -2))).addContainerGap(63, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.AltComboBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.HyMedianTextField, -2, -1, -2)).addGap(38, 38, 38)));
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignTestDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignTestDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(97, 97, 97).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, 110, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 53, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton))));
        this.pack();
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.ColumnComboBox);
    }

    private void SampleRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SampleRadioButton.isSelected()) {
            this.ColumnComboBox.setEnabled(true);
        } else {
            this.ColumnComboBox.setEnabled(false);
        }
    }

    private void SummaryRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SummaryRadioButton.isSelected()) {
            this.PositiveLabel.setEnabled(true);
            this.NegativeLabel.setEnabled(true);
            this.NumPositiveTextField.setEnabled(true);
            this.NumNegativeTextField.setEnabled(true);
        } else {
            this.PositiveLabel.setEnabled(false);
            this.NegativeLabel.setEnabled(false);
            this.NumPositiveTextField.setEnabled(false);
            this.NumNegativeTextField.setEnabled(false);
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        SignTest st;
        double median;
        this.app.compoundEdit = new DialogEdit("sign test");
        Vector<Double> ColumnVector = new Vector();
        String heading = "Sign Test:";
        String text = "";
        int typeTest = this.AltComboBox.getSelectedIndex();
        try {
            median = Double.parseDouble(this.HyMedianTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid number for the hypothesized median.");
            return;
        }
        if (this.SampleRadioButton.isSelected()) {
            String columnLabel = this.ColumnComboBox.getSelectedItem().toString();
            if (columnLabel.equals("")) {
                this.app.showErrorDialog("Select the input column.");
                return;
            }
            int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if ((ColumnVector = HelperFunctions.removeNullValues(ColumnVector)) == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                return;
            }
            text = text + "Input: " + columnLabel + "<br>";
            st = new SignTest(ColumnVector, median, typeTest);
        } else {
            int numPositive = 0;
            int numNegative = 0;
            try {
                numPositive = Integer.parseInt(this.NumPositiveTextField.getText());
                numNegative = Integer.parseInt(this.NumNegativeTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Invalid summary data.");
                return;
            }
            text = text + "Input: Summary data<br>";
            st = new SignTest(numPositive, numNegative, median, typeTest);
        }
        text = text + "H<sub>0</sub>: median = " + median + "<br>";
        text = text + "H<sub>1</sub>: median ";
        text = typeTest == SignTest.LESS ? text + " &lt; " : (typeTest == SignTest.GREATER ? text + " &gt; " : text + " &ne; ");
        text = text + median + "<br>";
        text = text + st;
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

