/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.correg;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.graph.GraphFactory;
import org.statcato.graph.StatcatoChartFrame;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.inferential.CorrelationRegression;
import org.statcato.utils.HelperFunctions;

public class CorrelationMatrixDialog
extends StatcatoDialog {
    private JButton AddButton;
    private JButton CancelButton;
    private JButton ClearButton1;
    private JList ColList;
    private JCheckBox GraphCheckBox;
    private JPanel GraphPanel;
    private JCheckBox LegendCheckBox;
    private JCheckBox LineCheckBox;
    private JButton OKButton;
    private JButton RemoveButton;
    private JTextField SigTextField;
    private JTextField TitleTextField;
    private JList VarList;
    private JTextField XTextField;
    private JTextField YTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;

    public CorrelationMatrixDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        this.customInitComponents();
        this.setHelpFile("stat-reg-two-variables-all-pairs");
        this.name = "Linear Correlation and Regression (All Pairs)";
        this.description = "For performing computations that determine the correlation and regression for pairs of variables. ";
        this.helpStrings.add("Select the columns containing data values for the input variables.");
        this.helpStrings.add("A correlation and regression analysis is done for all pairs of variables.");
        this.helpStrings.add("Enter the significance level of the hypothesis test for correlation.");
        this.helpStrings.add("Select the Show a scatterplot for all pairs of data values check box to display a scatter plot showing data values in each pair of input variables.");
    }

    @Override
    public void updateElements() {
        this.clearMutableColumnsList(this.ColList);
        this.clearMutableColumnsList(this.VarList);
        this.ParentSpreadsheet.populateMutableColumnsList(this.ColList);
    }

    public void customInitComponents() {
        this.ParentSpreadsheet.populateMutableColumnsList(this.ColList);
        this.ColList.setSelectionMode(2);
        this.VarList.setSelectionMode(2);
        this.GraphPanel.setVisible(false);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.pack();
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.ClearButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.VarList = new JList(new DefaultListModel());
        this.AddButton = new JButton();
        this.RemoveButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.ColList = new JList(new DefaultListModel());
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.SigTextField = new JTextField();
        this.GraphCheckBox = new JCheckBox();
        this.GraphPanel = new JPanel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.LegendCheckBox = new JCheckBox();
        this.YTextField = new JTextField();
        this.TitleTextField = new JTextField();
        this.XTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.LineCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Correlation Matrix");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorrelationMatrixDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorrelationMatrixDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.ClearButton1.setText("Clear Input List");
        this.ClearButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorrelationMatrixDialog.this.ClearButton1ActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Variables:");
        this.VarList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CorrelationMatrixDialog.this.VarListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.VarList);
        this.AddButton.setText("<< Add to list");
        this.AddButton.setEnabled(false);
        this.AddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorrelationMatrixDialog.this.AddButtonActionPerformed(evt);
            }
        });
        this.RemoveButton.setText("Remove from list >>");
        this.RemoveButton.setEnabled(false);
        this.RemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorrelationMatrixDialog.this.RemoveButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setText("<html>Select the <b>column(s)</b> to be <br>included in the analysis<br>\n(Ctrl-click or Shift-click to <br>\nselect multiple columns):");
        this.ColList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CorrelationMatrixDialog.this.ColListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.ColList);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.ClearButton1).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jLabel1)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 103, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.RemoveButton)).addComponent(this.AddButton, -1, -1, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 100, -2).addComponent(this.jLabel2, -2, -1, -2)).addGap(47, 47, 47)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.jLabel1)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addComponent(this.jScrollPane1)).addGap(35, 35, 35)).addGroup(jPanel1Layout.createSequentialGroup().addGap(40, 40, 40).addComponent(this.AddButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.RemoveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE))).addComponent(this.ClearButton1)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Significance"));
        this.jLabel6.setText("Significance level:");
        this.SigTextField.setText("0.05");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SigTextField, -2, 81, -2).addContainerGap(175, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.SigTextField, -2, -1, -2)).addContainerGap()));
        this.GraphCheckBox.setText("Show a scatterplot for all pairs of data values");
        this.GraphCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CorrelationMatrixDialog.this.GraphCheckBoxStateChanged(evt);
            }
        });
        this.GraphPanel.setBorder(BorderFactory.createTitledBorder("Graph Options"));
        this.jLabel7.setText("Plot Title:");
        this.jLabel8.setText("X-axis Label:");
        this.LegendCheckBox.setSelected(true);
        this.LegendCheckBox.setText("Show legend");
        this.YTextField.setText("y");
        this.TitleTextField.setText("Scatterplot");
        this.XTextField.setText("x");
        this.jLabel5.setText("Y-axis Label:");
        this.LineCheckBox.setSelected(true);
        this.LineCheckBox.setText("Show regression line");
        GroupLayout GraphPanelLayout = new GroupLayout(this.GraphPanel);
        this.GraphPanel.setLayout(GraphPanelLayout);
        GraphPanelLayout.setHorizontalGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GraphPanelLayout.createSequentialGroup().addContainerGap().addGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.LineCheckBox).addComponent(this.LegendCheckBox).addGroup(GraphPanelLayout.createSequentialGroup().addGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel7)).addGap(18, 18, 18).addGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.TitleTextField).addComponent(this.XTextField).addComponent(this.YTextField, -1, 188, Short.MAX_VALUE))).addComponent(this.jLabel8)).addContainerGap(-1, Short.MAX_VALUE)));
        GraphPanelLayout.setVerticalGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GraphPanelLayout.createSequentialGroup().addContainerGap().addGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.XTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.YTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(GraphPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.TitleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LegendCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LineCheckBox).addContainerGap(17, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, 501, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.GraphPanel, -2, -1, -2).addComponent(this.GraphCheckBox)).addContainerGap(43, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addGap(301, 301, 301).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton).addGap(0, 0, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(16, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.GraphCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.GraphPanel, -2, -1, -2)).addComponent(this.jPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton))));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        int selectedXColumn;
        String x;
        int i;
        this.app.compoundEdit = new DialogEdit("correlation matrix");
        double significance = 0.0;
        String heading = "Correlation Matrix:";
        String text = "";
        String correlationMatrix = "";
        String detailsMatrix = "";
        if (this.VarList.getModel().getSize() < 2) {
            this.app.showErrorDialog("Add at least two variables.");
            return;
        }
        try {
            significance = Double.parseDouble(this.SigTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        if (significance <= 0.0 || significance >= 1.0) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        heading = heading + "  Significance level = " + significance;
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        double min = 0.0;
        double max = 0.0;
        correlationMatrix = correlationMatrix + "<table border='1'>";
        detailsMatrix = detailsMatrix + "<table border='1'>";
        correlationMatrix = correlationMatrix + "<tr><td>&nbsp;</td>";
        detailsMatrix = detailsMatrix + "<tr><td>&nbsp;</td>";
        for (i = 0; i < this.VarList.getModel().getSize(); ++i) {
            x = (String)this.VarList.getModel().getElementAt(i);
            selectedXColumn = this.ParentSpreadsheet.parseColumnNumber(x);
            correlationMatrix = correlationMatrix + "<td>" + x + "</td>";
            detailsMatrix = detailsMatrix + "<td>" + x + "</td>";
        }
        correlationMatrix = correlationMatrix + "</tr>";
        detailsMatrix = detailsMatrix + "</tr>";
        for (i = 0; i < this.VarList.getModel().getSize(); ++i) {
            x = (String)this.VarList.getModel().getElementAt(i);
            selectedXColumn = this.ParentSpreadsheet.parseColumnNumber(x);
            correlationMatrix = correlationMatrix + "<tr><td>" + x + "</td>";
            detailsMatrix = detailsMatrix + "<tr><td>" + x + "</td>";
            for (int j = 0; j < this.VarList.getModel().getSize(); ++j) {
                correlationMatrix = correlationMatrix + "<td>";
                detailsMatrix = detailsMatrix + "<td>";
                String y = (String)this.VarList.getModel().getElementAt(j);
                int selectedYColumn = this.ParentSpreadsheet.parseColumnNumber(y);
                detailsMatrix = detailsMatrix + "x = " + x + "<br>";
                detailsMatrix = detailsMatrix + "y = " + y + "<br>";
                Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(selectedXColumn);
                Vector<Double> XColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
                if (XColumnVector == null) {
                    this.app.showErrorDialog("Invalid input column " + x + ": all data must be numbers.");
                    return;
                }
                XColumnVector = HelperFunctions.removeNullValues(XColumnVector);
                StrColumnVector = this.ParentSpreadsheet.getColumn(selectedYColumn);
                Vector<Double> YColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
                if (YColumnVector == null) {
                    this.app.showErrorDialog("Invalid input column " + y + ": all data must be numbers.");
                    return;
                }
                YColumnVector = HelperFunctions.removeNullValues(YColumnVector);
                if (XColumnVector.size() != YColumnVector.size()) {
                    this.app.showErrorDialog("The number of x values must be the same as the number of y values.");
                    return;
                }
                CorrelationRegression CG = new CorrelationRegression(XColumnVector, YColumnVector, significance);
                detailsMatrix = detailsMatrix + CG;
                correlationMatrix = correlationMatrix + HelperFunctions.formatFloat(CG.LinearCorrelationCoeff(), 4);
                if (i < j) {
                    XYSeries series = new XYSeries((Comparable)((Object)(x + ", " + y)));
                    for (int k = 0; k < XColumnVector.size(); ++k) {
                        double value = XColumnVector.elementAt(k);
                        if (value < min) {
                            min = value;
                        }
                        if (value > max) {
                            max = value;
                        }
                        series.add(value, YColumnVector.elementAt(k));
                    }
                    seriesCollection.addSeries(series);
                }
                correlationMatrix = correlationMatrix + "</td>";
                detailsMatrix = detailsMatrix + "</td>";
            }
            correlationMatrix = correlationMatrix + "</tr>";
            detailsMatrix = detailsMatrix + "</tr>";
        }
        correlationMatrix = correlationMatrix + "</table>";
        detailsMatrix = detailsMatrix + "</table>";
        text = text + "<p>" + correlationMatrix + "</p>";
        text = text + "<p><b>Details:</b></p>";
        text = text + "<p>" + detailsMatrix + "</p>";
        this.app.addLogParagraph(heading, text);
        if (this.GraphCheckBox.isSelected()) {
            JFreeChart chart = GraphFactory.createScatterplot(seriesCollection, this.TitleTextField.getText(), this.XTextField.getText(), this.YTextField.getText(), this.LegendCheckBox.isSelected(), this.LineCheckBox.isSelected(), min, max);
            StatcatoChartFrame frame = new StatcatoChartFrame(this.TitleTextField.getText(), chart, this.app);
            frame.pack();
            frame.setVisible(true);
        }
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void GraphCheckBoxStateChanged(ChangeEvent evt) {
        if (this.GraphCheckBox.isSelected()) {
            this.GraphPanel.setVisible(true);
            this.pack();
        } else {
            this.GraphPanel.setVisible(false);
            this.pack();
        }
    }

    private void ClearButton1ActionPerformed(ActionEvent evt) {
        this.clearMutableColumnsList(this.ColList);
        this.clearMutableColumnsList(this.VarList);
        this.ParentSpreadsheet.populateMutableColumnsList(this.ColList);
    }

    private void VarListValueChanged(ListSelectionEvent evt) {
        if (this.VarList.getSelectedIndex() != -1) {
            this.RemoveButton.setEnabled(true);
            this.RemoveButton.requestFocusInWindow();
        } else {
            this.RemoveButton.setEnabled(false);
        }
    }

    private void AddButtonActionPerformed(ActionEvent evt) {
        Object[] list = this.ColList.getSelectedValues();
        for (int i = 0; i < list.length; ++i) {
            String x = (String)list[i];
            ((DefaultListModel)this.VarList.getModel()).addElement(x);
            ((DefaultListModel)this.ColList.getModel()).removeElement(x);
        }
        this.OKButton.requestFocusInWindow();
    }

    private void RemoveButtonActionPerformed(ActionEvent evt) {
        Object[] list = this.VarList.getSelectedValues();
        for (int i = 0; i < list.length; ++i) {
            String x = (String)list[i];
            ((DefaultListModel)this.ColList.getModel()).addElement(x);
            ((DefaultListModel)this.VarList.getModel()).removeElement(x);
        }
        this.OKButton.requestFocusInWindow();
    }

    private void ColListValueChanged(ListSelectionEvent evt) {
        if (this.ColList.getSelectedIndex() != -1) {
            this.AddButton.setEnabled(true);
            this.AddButton.requestFocusInWindow();
        } else {
            this.AddButton.setEnabled(false);
        }
    }
}

