/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.ci;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.inferential.CI2PopVar;
import org.statcato.utils.HelperFunctions;

public class CI2PopVarDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JTextField ConfidenceTextField;
    private JComboBox LabelsComboBox;
    private JButton OKButton;
    private JComboBox Pop1ComboBox;
    private JComboBox Pop2ComboBox;
    private JRadioButton Sample1ColRadioButton;
    private JRadioButton Sample2ColRadioButton;
    private JTextField Stdev1TextField;
    private JTextField Stdev2TextField;
    private JRadioButton StdevRadioButton;
    private JRadioButton SummaryRadioButton;
    private JComboBox ValuesComboBox;
    private JTextField Var1TextField;
    private JTextField Var2TextField;
    private JRadioButton VarRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField n1TextField;
    private JTextField n2TextField;

    public CI2PopVarDialog(Frame parent, boolean modal, Statcato mTab) {
        super(parent, modal);
        this.initComponents();
        this.app = mTab;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.Sample1ColRadioButton);
        group1.add(this.Sample2ColRadioButton);
        group1.add(this.SummaryRadioButton);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.VarRadioButton);
        group2.add(this.StdevRadioButton);
        this.ParentSpreadsheet.populateComboBox(this.LabelsComboBox);
        this.ParentSpreadsheet.populateComboBox(this.ValuesComboBox);
        this.ParentSpreadsheet.populateComboBox(this.Pop1ComboBox);
        this.ParentSpreadsheet.populateComboBox(this.Pop2ComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-ci-2var");
        this.name = "Confidence Interval: Two Population Variances";
        this.description = "For computing the confidence intervals for the ratio of two population variances.";
        this.helpStrings.add("The sample data can be inputted in one of three ways...");
        this.helpStrings.add("Samples in one column: The population labels of samples are in one column of the datasheet, and the individual samples are in another column.");
        this.helpStrings.add("Samples in two columns: The samples of the two population are in two separate columns.");
        this.helpStrings.add("Summarized sample data: The sample size and standard deviation/variance of each sample are provided (instead of individual sample values).");
        this.helpStrings.add("The confidence level must be between 0 and 1. ");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.LabelsComboBox);
        this.updateComboBox(this.ValuesComboBox);
        this.updateComboBox(this.Pop1ComboBox);
        this.updateComboBox(this.Pop2ComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.ConfidenceTextField = new JTextField();
        this.jLabel13 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jPanel2 = new JPanel();
        this.Pop2ComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.ValuesComboBox = new JComboBox();
        this.Sample2ColRadioButton = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.LabelsComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.Pop1ComboBox = new JComboBox();
        this.Sample1ColRadioButton = new JRadioButton();
        this.jLabel6 = new JLabel();
        this.jLabel5 = new JLabel();
        this.n1TextField = new JTextField();
        this.n2TextField = new JTextField();
        this.jLabel7 = new JLabel();
        this.SummaryRadioButton = new JRadioButton();
        this.StdevRadioButton = new JRadioButton();
        this.VarRadioButton = new JRadioButton();
        this.Var1TextField = new JTextField();
        this.Stdev1TextField = new JTextField();
        this.Stdev2TextField = new JTextField();
        this.Var2TextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Confidence Interval: 2-Population Variances");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CI2PopVarDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CI2PopVarDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Confidence"));
        this.ConfidenceTextField.setText("0.95");
        this.jLabel13.setText("0 - 1.00 (e.g. 0.95)");
        this.jLabel12.setText("Confidence Level:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ConfidenceTextField, -2, 83, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel13).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.ConfidenceTextField, -2, -1, -2).addComponent(this.jLabel13)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.Pop2ComboBox.setEnabled(false);
        this.jLabel3.setText("Population 1:");
        this.jLabel1.setText("Labels in column:");
        this.Sample2ColRadioButton.setText("Samples in two columns");
        this.Sample2ColRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI2PopVarDialog.this.Sample2ColRadioButtonStateChanged(evt);
            }
        });
        this.jLabel4.setText("Population 2:");
        this.jLabel2.setText("Values in column:");
        this.Pop1ComboBox.setEnabled(false);
        this.Sample1ColRadioButton.setSelected(true);
        this.Sample1ColRadioButton.setText("Samples in one column");
        this.Sample1ColRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI2PopVarDialog.this.Sample1ColRadioButtonStateChanged(evt);
            }
        });
        this.jLabel6.setText("Population 2:");
        this.jLabel5.setText("Population 1:");
        this.n1TextField.setEnabled(false);
        this.n2TextField.setEnabled(false);
        this.jLabel7.setText("Sample Size");
        this.SummaryRadioButton.setText("Summarized sample data");
        this.SummaryRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI2PopVarDialog.this.SummaryRadioButtonStateChanged(evt);
            }
        });
        this.StdevRadioButton.setSelected(true);
        this.StdevRadioButton.setText("Standard Deviation");
        this.StdevRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI2PopVarDialog.this.StdevRadioButtonStateChanged(evt);
            }
        });
        this.VarRadioButton.setText("Variance");
        this.VarRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI2PopVarDialog.this.VarRadioButtonStateChanged(evt);
            }
        });
        this.Var1TextField.setEnabled(false);
        this.Stdev1TextField.setEnabled(false);
        this.Stdev2TextField.setEnabled(false);
        this.Var2TextField.setEnabled(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel5)).addGap(35, 35, 35).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.n1TextField, GroupLayout.Alignment.LEADING).addComponent(this.n2TextField, GroupLayout.Alignment.LEADING, -2, 68, -2).addComponent(this.jLabel7, GroupLayout.Alignment.LEADING))).addComponent(this.SummaryRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.StdevRadioButton).addGroup(jPanel2Layout.createSequentialGroup().addGap(29, 29, 29).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.Stdev1TextField).addComponent(this.Stdev2TextField)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.VarRadioButton).addGap(0, 64, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGap(29, 29, 29).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.Var2TextField, GroupLayout.Alignment.TRAILING).addComponent(this.Var1TextField))))).addComponent(this.Sample1ColRadioButton).addComponent(this.Sample2ColRadioButton).addGroup(jPanel2Layout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.ValuesComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.LabelsComboBox, -2, 93, -2))).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addGap(26, 26, 26).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.Pop2ComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.Pop1ComboBox, -2, 89, -2)))))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.Sample1ColRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.LabelsComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.ValuesComboBox, -2, -1, -2)).addGap(23, 23, 23).addComponent(this.Sample2ColRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.Pop1ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Pop2ComboBox, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addComponent(this.SummaryRadioButton).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.StdevRadioButton).addComponent(this.VarRadioButton).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Var1TextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.Stdev2TextField, -2, -1, -2).addComponent(this.Var2TextField, -2, -1, -2))).addGroup(jPanel2Layout.createSequentialGroup().addGap(25, 25, 25).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.n1TextField, -2, -1, -2).addComponent(this.Stdev1TextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.n2TextField, -2, -1, -2)))).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(131, 131, 131).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap(15, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CancelButton).addComponent(this.OKButton)).addContainerGap(12, Short.MAX_VALUE)));
        this.pack();
    }

    private void SummaryRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SummaryRadioButton.isSelected()) {
            this.n1TextField.setEnabled(true);
            this.n2TextField.setEnabled(true);
            if (this.StdevRadioButton.isSelected()) {
                this.Stdev1TextField.setEnabled(true);
                this.Stdev2TextField.setEnabled(true);
                this.Var1TextField.setEnabled(false);
                this.Var2TextField.setEnabled(false);
            } else {
                this.Stdev1TextField.setEnabled(false);
                this.Stdev2TextField.setEnabled(false);
                this.Var1TextField.setEnabled(true);
                this.Var2TextField.setEnabled(true);
            }
        } else {
            this.n1TextField.setEnabled(false);
            this.n2TextField.setEnabled(false);
            this.Stdev1TextField.setEnabled(false);
            this.Stdev2TextField.setEnabled(false);
            this.Var1TextField.setEnabled(false);
            this.Var2TextField.setEnabled(false);
        }
    }

    private void Sample1ColRadioButtonStateChanged(ChangeEvent evt) {
        if (this.Sample1ColRadioButton.isSelected()) {
            this.LabelsComboBox.setEnabled(true);
            this.ValuesComboBox.setEnabled(true);
        } else {
            this.LabelsComboBox.setEnabled(false);
            this.ValuesComboBox.setEnabled(false);
        }
    }

    private void Sample2ColRadioButtonStateChanged(ChangeEvent evt) {
        if (this.Sample2ColRadioButton.isSelected()) {
            this.Pop1ComboBox.setEnabled(true);
            this.Pop2ComboBox.setEnabled(true);
        } else {
            this.Pop1ComboBox.setEnabled(false);
            this.Pop2ComboBox.setEnabled(false);
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        double confidenceLevel;
        this.app.compoundEdit = new DialogEdit("CI 2 variance");
        int n1 = 0;
        int n2 = 0;
        double var1 = 0.0;
        double var2 = 0.0;
        double stdev1 = 0.0;
        double stdev2 = 0.0;
        String heading = "Confidence Intervals - Two population variances:";
        String text = "";
        try {
            confidenceLevel = Double.parseDouble(this.ConfidenceTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        heading = heading + "  confidence level = " + confidenceLevel;
        if (this.SummaryRadioButton.isSelected()) {
            try {
                n1 = Integer.parseInt(this.n1TextField.getText());
                n2 = Integer.parseInt(this.n2TextField.getText());
                if (n1 < 1 || n2 < 1) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a positive integer for the sample sizes.");
                return;
            }
            if (this.StdevRadioButton.isSelected()) {
                try {
                    stdev1 = Double.parseDouble(this.Stdev1TextField.getText());
                    stdev2 = Double.parseDouble(this.Stdev2TextField.getText());
                    if (stdev1 < 0.0 || stdev2 < 0.0) {
                        throw new NumberFormatException();
                    }
                    var1 = stdev1 * stdev1;
                    var2 = stdev2 * stdev2;
                }
                catch (NumberFormatException e) {
                    this.app.showErrorDialog("Enter valid sample standard deviations.");
                    return;
                }
            } else {
                try {
                    var1 = Double.parseDouble(this.Var1TextField.getText());
                    var2 = Double.parseDouble(this.Var2TextField.getText());
                    if (var1 < 0.0 || var2 < 0.0) {
                        throw new NumberFormatException();
                    }
                    stdev1 = Math.sqrt(var1);
                    stdev2 = Math.sqrt(var2);
                }
                catch (NumberFormatException e) {
                    this.app.showErrorDialog("Enter valid sample variances.");
                    return;
                }
            }
        } else {
            Vector<Double> InputVector2;
            Vector<Double> InputVector1;
            block28: {
                Vector Vector1 = null;
                Vector Vector2 = null;
                InputVector1 = null;
                InputVector2 = null;
                if (this.Sample1ColRadioButton.isSelected()) {
                    String columnLabel = this.LabelsComboBox.getSelectedItem().toString();
                    text = text + "Population labels in " + columnLabel + "<br>";
                    if (columnLabel.equals("")) {
                        this.app.showErrorDialog("Select the column containing category labels.");
                        return;
                    }
                    int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                    Vector<Cell> LabelsVector = this.ParentSpreadsheet.getColumn(column);
                    columnLabel = this.ValuesComboBox.getSelectedItem().toString();
                    text = text + "Samples values in " + columnLabel + "<br>";
                    if (columnLabel.equals("")) {
                        this.app.showErrorDialog("Select the column containing sample values.");
                        return;
                    }
                    column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                    Vector<Cell> ValuesVector = this.ParentSpreadsheet.getColumn(column);
                    try {
                        Object[] returnValues = HelperFunctions.splitValuesVectorByLabels(LabelsVector, ValuesVector);
                        text = text + "Population 1 = " + returnValues[0] + "<br>";
                        text = text + "Population 2 = " + returnValues[2] + "<br>";
                        Vector1 = (Vector)returnValues[1];
                        Vector2 = (Vector)returnValues[3];
                        InputVector1 = HelperFunctions.ConvertInputVectorToDoubles(Vector1);
                        if (InputVector1 == null) {
                            this.app.showErrorDialog("Invalid input column " + returnValues[0] + ": all data must be numbers.");
                            return;
                        }
                        InputVector2 = HelperFunctions.ConvertInputVectorToDoubles(Vector2);
                        if (InputVector2 == null) {
                            this.app.showErrorDialog("Invalid input column " + returnValues[2] + ": all data must be numbers.");
                            return;
                        }
                        break block28;
                    }
                    catch (Exception e) {
                        this.app.showErrorDialog(e.getMessage());
                        return;
                    }
                }
                if (this.Sample2ColRadioButton.isSelected()) {
                    String columnLabel = this.Pop1ComboBox.getSelectedItem().toString();
                    text = text + "Samples of population 1 in " + columnLabel + "<br>";
                    if (columnLabel.equals("")) {
                        this.app.showErrorDialog("Select the column containing sample values for the first population.");
                        return;
                    }
                    int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                    Vector1 = this.ParentSpreadsheet.getColumn(column);
                    InputVector1 = HelperFunctions.ConvertInputVectorToDoubles(Vector1);
                    if (InputVector1 == null) {
                        this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                        return;
                    }
                    columnLabel = this.Pop2ComboBox.getSelectedItem().toString();
                    text = text + "Samples of population 2 in " + columnLabel + "<br>";
                    if (columnLabel.equals("")) {
                        this.app.showErrorDialog("Select the column containing sample values for the second population.");
                        return;
                    }
                    column = this.ParentSpreadsheet.parseColumnNumber(columnLabel);
                    Vector2 = this.ParentSpreadsheet.getColumn(column);
                    InputVector2 = HelperFunctions.ConvertInputVectorToDoubles(Vector2);
                    if (InputVector2 == null) {
                        this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                        return;
                    }
                }
            }
            n1 = BasicStatistics.Nnonmissing(InputVector1);
            var1 = BasicStatistics.variance(InputVector1);
            stdev1 = BasicStatistics.stdev(InputVector1);
            n2 = BasicStatistics.Nnonmissing(InputVector2);
            var2 = BasicStatistics.variance(InputVector2);
            stdev2 = BasicStatistics.stdev(InputVector2);
        }
        text = text + "<br><table border='1'>";
        text = text + "<tr><td>&nbsp;</td><td>N</td>";
        text = text + "<td>Stdev</td><td>Variance</td>";
        text = text + "</tr>";
        text = text + "<tr><td>Population 1</td><td>" + n1 + "</td><td>" + HelperFunctions.formatFloat(stdev1, 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(var1, 5) + "</td>";
        text = text + "</tr>";
        text = text + "<tr><td>Population 2</td><td>" + n2 + "</td><td>" + HelperFunctions.formatFloat(stdev2, 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(var2, 5) + "</td>";
        text = text + "</tr></table><br>";
        CI2PopVar CI = new CI2PopVar(confidenceLevel, n1, n2, var1, var2);
        text = text + "Left critical value F<sub>L</sub> = " + HelperFunctions.formatFloat(CI.criticalValueLeft(), 4) + "<br>";
        text = text + "Right critical value F<sub>R</sub> = " + HelperFunctions.formatFloat(CI.criticalValueRight(), 4) + "<br>";
        text = text + HelperFunctions.formatFloat(confidenceLevel * 100.0, 2) + "%CI Variance Ratio (&sigma;<sub>1</sub><sup>2</sup> / " + "&sigma;<sub>2</sub><sup>2</sup>) = " + CI.CIVar() + "<br>";
        text = text + HelperFunctions.formatFloat(confidenceLevel * 100.0, 2) + "%CI Standard Deviation Ratio (&sigma;<sub>1</sub> / " + "&sigma;<sub>2</sub>) = " + CI.CIStdev();
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void VarRadioButtonStateChanged(ChangeEvent evt) {
        if (this.VarRadioButton.isSelected()) {
            if (this.SummaryRadioButton.isSelected()) {
                this.Var1TextField.setEnabled(true);
                this.Var2TextField.setEnabled(true);
            } else {
                this.Var1TextField.setEnabled(false);
                this.Var2TextField.setEnabled(false);
            }
        } else {
            this.Var1TextField.setEnabled(false);
            this.Var2TextField.setEnabled(false);
        }
    }

    private void StdevRadioButtonStateChanged(ChangeEvent evt) {
        if (this.StdevRadioButton.isSelected()) {
            if (this.SummaryRadioButton.isSelected()) {
                this.Stdev1TextField.setEnabled(true);
                this.Stdev2TextField.setEnabled(true);
            } else {
                this.Stdev1TextField.setEnabled(false);
                this.Stdev2TextField.setEnabled(false);
            }
        } else {
            this.Stdev1TextField.setEnabled(false);
            this.Stdev2TextField.setEnabled(false);
        }
    }
}

