/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.basicstats;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.utils.HelperFunctions;

public class RowStatisticsDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JTextField InputTextField;
    private JRadioButton MaxRadioButton;
    private JRadioButton MeanRadioButton;
    private JRadioButton MedianRadioButton;
    private JRadioButton MinRadioButton;
    private JRadioButton NmissingRadioButton;
    private JRadioButton NnonmissingRadioButton;
    private JRadioButton NtotalRadioButton;
    private JButton OKButton;
    private JRadioButton RangeRadioButton;
    private JTextField ResultTextField;
    private JRadioButton StdevRadioButton;
    private JRadioButton SumOfSqRadioButton;
    private JRadioButton SumRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;

    public RowStatisticsDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.app = app;
        this.initComponents();
        ButtonGroup group = new ButtonGroup();
        group.add(this.SumRadioButton);
        group.add(this.MeanRadioButton);
        group.add(this.StdevRadioButton);
        group.add(this.MinRadioButton);
        group.add(this.MaxRadioButton);
        group.add(this.RangeRadioButton);
        group.add(this.MedianRadioButton);
        group.add(this.SumOfSqRadioButton);
        group.add(this.NtotalRadioButton);
        group.add(this.NnonmissingRadioButton);
        group.add(this.NmissingRadioButton);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-basic-row");
        this.name = "Row Statistics";
        this.description = "For computing a statistic for each row in a set of columns and storing the results in the corresponding rows of a new column.";
        this.helpStrings.add("Enter the names of the input columns. Separate column names by spaces (e.g. c2 c4), and use a dash to indicate a range of columns (e.g. c10-c15).");
        this.helpStrings.add("Select the desired statistic.");
        this.helpStrings.add("Enter the column name (e.g. C1) or variable name (e.g. sum) in the Store Results in: text box.");
    }

    @Override
    public void updateElements() {
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.InputTextField = new JTextField();
        this.jLabel8 = new JLabel();
        this.jPanel2 = new JPanel();
        this.MeanRadioButton = new JRadioButton();
        this.NmissingRadioButton = new JRadioButton();
        this.RangeRadioButton = new JRadioButton();
        this.MedianRadioButton = new JRadioButton();
        this.NnonmissingRadioButton = new JRadioButton();
        this.StdevRadioButton = new JRadioButton();
        this.NtotalRadioButton = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.MinRadioButton = new JRadioButton();
        this.SumOfSqRadioButton = new JRadioButton();
        this.SumRadioButton = new JRadioButton();
        this.MaxRadioButton = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.ResultTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Row Statistics");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RowStatisticsDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RowStatisticsDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.jLabel1.setText("Input Variables(s):");
        this.jLabel8.setText("<html>\nEnter valid column names separated by space.<br>\nFor a continuous range of columns,<br>\nseparate using dash (e.g. C1-C30).<br>\n</html>\n");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(18, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.InputTextField).addContainerGap()).addComponent(this.jLabel1).addComponent(this.jLabel8))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.InputTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel8, -2, -1, -2).addGap(208, 208, 208)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Statistics"));
        this.MeanRadioButton.setText("Mean");
        this.NmissingRadioButton.setText("N missing");
        this.RangeRadioButton.setText("Range");
        this.MedianRadioButton.setText("Median");
        this.NnonmissingRadioButton.setText("N nonmissing");
        this.StdevRadioButton.setText("Standard Deviation");
        this.NtotalRadioButton.setText("N total");
        this.jLabel2.setText("Statistic:");
        this.MinRadioButton.setText("Minimum");
        this.SumOfSqRadioButton.setText("Sum of Squares");
        this.SumRadioButton.setText("Sum");
        this.MaxRadioButton.setText("Maximum");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SumRadioButton).addComponent(this.jLabel2).addComponent(this.MeanRadioButton).addComponent(this.StdevRadioButton).addComponent(this.MinRadioButton).addComponent(this.MaxRadioButton).addComponent(this.RangeRadioButton)).addGap(42, 42, 42).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SumOfSqRadioButton).addComponent(this.MedianRadioButton).addComponent(this.NtotalRadioButton).addComponent(this.NnonmissingRadioButton).addComponent(this.NmissingRadioButton)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SumRadioButton).addComponent(this.MedianRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.MeanRadioButton).addComponent(this.SumOfSqRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.StdevRadioButton).addComponent(this.NtotalRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.MinRadioButton).addComponent(this.NnonmissingRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.MaxRadioButton).addComponent(this.NmissingRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.RangeRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Results"));
        this.jLabel3.setText("Store Results in:");
        this.jLabel4.setText("(column or variable name)");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.ResultTextField, -2, 144, -2).addComponent(this.jLabel4)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ResultTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(240, 240, 240).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, 157, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 49, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton))));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("row statistics");
        int[] columnNumbers = this.ParentSpreadsheet.getColumnNumbersArrayFromString(this.InputTextField.getText());
        if (columnNumbers.length == 0) {
            this.app.showErrorDialog("Invalid input column(s).");
            return;
        }
        String StoreColumn = this.ResultTextField.getText();
        int storeColumnNum = -1;
        if (!StoreColumn.equals("")) {
            storeColumnNum = this.ParentSpreadsheet.getColumnNumber(StoreColumn);
            if (storeColumnNum == -1) {
                this.app.showErrorDialog("Enter a valid column name (e.g. C1) or a valid variable name to store the results.");
                return;
            }
        } else {
            this.app.showErrorDialog("Enter a column name or variable name to which the results will be stored.");
            return;
        }
        String text = "";
        Vector<String> ResultVector = new Vector<String>(0);
        Vector<Vector<Cell>> Rows = this.ParentSpreadsheet.getRowsWithDataAtGivenColumns(columnNumbers);
        Enumeration<Vector<Cell>> e = Rows.elements();
        while (e.hasMoreElements()) {
            double sum;
            Vector<Cell> Row = e.nextElement();
            if (Row.size() == 0) {
                ResultVector.addElement("");
                continue;
            }
            Object[] conversions = HelperFunctions.ConvertInputVectorToNumbers2(Row);
            if (conversions == null) {
                this.app.showErrorDialog("Invalid input column: all data must be numbers.");
                return;
            }
            Vector RowVector = (Vector)conversions[0];
            int missing = (Integer)conversions[1];
            int nonmissing = (Integer)conversions[2];
            int total = missing + nonmissing;
            if (this.SumRadioButton.isSelected()) {
                sum = BasicStatistics.sum(RowVector);
                ResultVector.addElement(sum + "");
                continue;
            }
            if (this.MeanRadioButton.isSelected()) {
                Double mean = BasicStatistics.mean(RowVector);
                if (mean == null) {
                    ResultVector.addElement("*");
                    continue;
                }
                ResultVector.addElement(mean + "");
                continue;
            }
            if (this.StdevRadioButton.isSelected()) {
                Double stdev = BasicStatistics.stdev(RowVector);
                if (stdev == null) {
                    ResultVector.addElement("*");
                    continue;
                }
                ResultVector.addElement(stdev + "");
                continue;
            }
            if (this.MaxRadioButton.isSelected()) {
                Double max = BasicStatistics.max(RowVector);
                if (max == null) {
                    ResultVector.addElement("*");
                    continue;
                }
                ResultVector.addElement(max + "");
                continue;
            }
            if (this.MinRadioButton.isSelected()) {
                Double min = BasicStatistics.min(RowVector);
                if (min == null) {
                    ResultVector.addElement("*");
                    continue;
                }
                ResultVector.addElement(min + "");
                continue;
            }
            if (this.RangeRadioButton.isSelected()) {
                Double range = BasicStatistics.range(RowVector);
                if (range == null) {
                    ResultVector.addElement("*");
                    continue;
                }
                ResultVector.addElement(range + "");
                continue;
            }
            if (this.MedianRadioButton.isSelected()) {
                Double median = BasicStatistics.median(RowVector);
                if (median == null) {
                    ResultVector.addElement("*");
                    continue;
                }
                ResultVector.addElement(median + "");
                continue;
            }
            if (this.SumOfSqRadioButton.isSelected()) {
                sum = BasicStatistics.sumOfSquares(RowVector);
                ResultVector.addElement(sum + "");
                continue;
            }
            if (this.NtotalRadioButton.isSelected()) {
                ResultVector.addElement(total + "");
                continue;
            }
            if (this.NnonmissingRadioButton.isSelected()) {
                ResultVector.addElement(nonmissing + "");
                continue;
            }
            if (!this.NmissingRadioButton.isSelected()) continue;
            ResultVector.addElement(missing + "");
        }
        if (this.SumRadioButton.isSelected()) {
            text = text + "sum of " + this.InputTextField.getText();
        } else if (this.MeanRadioButton.isSelected()) {
            text = text + "mean of " + this.InputTextField.getText();
        } else if (this.StdevRadioButton.isSelected()) {
            text = text + "standard deviation of " + this.InputTextField.getText();
        } else if (this.MaxRadioButton.isSelected()) {
            text = text + "max of " + this.InputTextField.getText();
        } else if (this.MinRadioButton.isSelected()) {
            text = text + "min of " + this.InputTextField.getText();
        } else if (this.RangeRadioButton.isSelected()) {
            text = text + "range of " + this.InputTextField.getText();
        } else if (this.MedianRadioButton.isSelected()) {
            text = text + "median of " + this.InputTextField.getText();
        } else if (this.SumOfSqRadioButton.isSelected()) {
            text = text + "sum of squares of " + this.InputTextField.getText();
        } else if (this.NtotalRadioButton.isSelected()) {
            text = text + "N total of " + this.InputTextField.getText();
        } else if (this.NnonmissingRadioButton.isSelected()) {
            text = text + "N nonmissing of " + this.InputTextField.getText();
        } else if (this.NmissingRadioButton.isSelected()) {
            text = text + "N missing of " + this.InputTextField.getText();
        }
        this.ParentSpreadsheet.setColumn(storeColumnNum, ResultVector);
        text = text + "<br>Store results in " + StoreColumn;
        this.app.addLogParagraph("Row Statistics", text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

