/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.anova;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.inferential.OneWayANOVA;
import org.statcato.utils.HelperFunctions;

public class OneWayANOVADialog
extends StatcatoDialog {
    private JButton AddButton;
    private JButton CancelButton;
    private JButton ClearButton;
    private JList ColList;
    private JButton OKButton;
    private JButton RemoveButton;
    private JTextField SigTextField;
    private JList VarList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;

    public OneWayANOVADialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        this.customInitComponents();
        this.setHelpFile("stat-anova1");
        this.name = "One-Way Analysis of Variance";
        this.description = "For performing one-way ANOVA.";
        this.helpStrings.add("Provide sample values for different populations in separate columns and add the columns to the list of responses.");
        this.helpStrings.add("Specify the significance level.");
    }

    private void customInitComponents() {
        this.ParentSpreadsheet.populateMutableColumnsList(this.ColList);
        this.ColList.setSelectionMode(2);
        this.VarList.setSelectionMode(2);
        this.getRootPane().setDefaultButton(this.OKButton);
    }

    @Override
    public void updateElements() {
        this.clearMutableColumnsList(this.ColList);
        this.clearMutableColumnsList(this.VarList);
        this.ParentSpreadsheet.populateMutableColumnsList(this.ColList);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.VarList = new JList(new DefaultListModel());
        this.RemoveButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.ColList = new JList(new DefaultListModel());
        this.jLabel1 = new JLabel();
        this.AddButton = new JButton();
        this.ClearButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.SigTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("One-Way Analysis of Variance");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OneWayANOVADialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OneWayANOVADialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.VarList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                OneWayANOVADialog.this.VarListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.VarList);
        this.RemoveButton.setText("Remove from list >>");
        this.RemoveButton.setEnabled(false);
        this.RemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OneWayANOVADialog.this.RemoveButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setText("<html>Select the column to be <br>included in the analysis<br>\n(Ctrl-click or Shift-click to <br>\nselect multiple columns):");
        this.ColList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                OneWayANOVADialog.this.ColListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.ColList);
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Responses:");
        this.AddButton.setText("<< Add to list");
        this.AddButton.setEnabled(false);
        this.AddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OneWayANOVADialog.this.AddButtonActionPerformed(evt);
            }
        });
        this.ClearButton.setText("Clear Input List");
        this.ClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OneWayANOVADialog.this.ClearButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 103, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.RemoveButton).addComponent(this.AddButton))).addGroup(jPanel1Layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.jLabel1))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jScrollPane2, -2, 100, -2))).addComponent(this.ClearButton)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.AddButton, this.RemoveButton);
        jPanel1Layout.linkSize(0, this.jScrollPane1, this.jScrollPane2);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGap(44, 44, 44).addComponent(this.AddButton).addGap(18, 18, 18).addComponent(this.RemoveButton).addContainerGap()).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ClearButton).addGap(10, 10, 10)))));
        jPanel1Layout.linkSize(1, this.jScrollPane1, this.jScrollPane2);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Significance"));
        this.jLabel6.setText("Significance level:");
        this.SigTextField.setText("0.05");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SigTextField, -2, 81, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.SigTextField, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.CancelButton))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 38, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addGap(29, 29, 29)))));
        this.pack();
    }

    private void VarListValueChanged(ListSelectionEvent evt) {
        if (this.VarList.getSelectedIndex() != -1) {
            this.RemoveButton.setEnabled(true);
            this.RemoveButton.requestFocusInWindow();
        } else {
            this.RemoveButton.setEnabled(false);
        }
    }

    private void RemoveButtonActionPerformed(ActionEvent evt) {
        Object[] list = this.VarList.getSelectedValues();
        for (int i = 0; i < list.length; ++i) {
            String x = (String)list[i];
            ((DefaultListModel)this.ColList.getModel()).addElement(x);
            ((DefaultListModel)this.VarList.getModel()).removeElement(x);
        }
        this.OKButton.requestFocusInWindow();
    }

    private void AddButtonActionPerformed(ActionEvent evt) {
        Object[] list = this.ColList.getSelectedValues();
        for (int i = 0; i < list.length; ++i) {
            String x = (String)list[i];
            ((DefaultListModel)this.VarList.getModel()).addElement(x);
            ((DefaultListModel)this.ColList.getModel()).removeElement(x);
        }
        this.OKButton.requestFocusInWindow();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("one-way ANOVA");
        String heading = "One-way ANOVA:";
        String text = "";
        Vector<Vector<Double>> vectors = new Vector<Vector<Double>>();
        double significance = 0.0;
        try {
            significance = Double.parseDouble(this.SigTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
            return;
        }
        if (significance <= 0.0 || significance >= 1.0) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
            return;
        }
        heading = heading + "  Significance level = " + significance;
        if (this.VarList.getModel().getSize() < 3) {
            this.app.showErrorDialog("Select at least three columns to include in the analysis.");
            return;
        }
        text = text + "Selected column variables:  ";
        for (int i = 0; i < this.VarList.getModel().getSize(); ++i) {
            String x = (String)this.VarList.getModel().getElementAt(i);
            int selectedXColumn = this.ParentSpreadsheet.parseColumnNumber(x);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(selectedXColumn);
            Vector<Double> XColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (XColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + x + ": all data must be numbers.");
                return;
            }
            if ((XColumnVector = HelperFunctions.removeNullValues(XColumnVector)).size() == 0) {
                this.app.showErrorDialog("Invalid input column " + x + ": empty column.");
            }
            vectors.addElement(XColumnVector);
            text = text + x + "  ";
        }
        text = text + "<br><br>";
        OneWayANOVA anova = new OneWayANOVA(vectors);
        text = text + "<table border='1'>";
        text = text + "<tr align='right'><th>Source of Variation</th><th>DOF</th><th>SS</th><th>MS</th><th>Test statistic F</th><th>Critical value F</th><th>p-Value</th></tr>";
        text = text + "<tr align='right'><th>Treatment (Between Groups)</th><td>" + anova.DOFTreatment() + "</td>" + "<td>" + HelperFunctions.formatFloat(anova.SSTreatment(), 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(anova.MSTreatment(), 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(anova.TestStatisticsF(), 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(anova.CriticalValue(significance), 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(anova.PValue(), 5) + "</td></tr>";
        text = text + "<tr align='right'><th>Error (Within Groups)</th><td>" + anova.DOFError() + "</td>" + "<td>" + HelperFunctions.formatFloat(anova.SSError(), 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(anova.MSError(), 5) + "</td>" + "<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>";
        text = text + "<tr align='right'><th>Total</th><td>" + anova.DOFTotal() + "</td>" + "<td>" + HelperFunctions.formatFloat(anova.SSTotal(), 5) + "</td>" + "<td>&nbsp;</td>" + "<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>";
        text = text + "</table>";
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void ColListValueChanged(ListSelectionEvent evt) {
        if (this.ColList.getSelectedIndex() != -1) {
            this.AddButton.setEnabled(true);
            this.AddButton.requestFocusInWindow();
        } else {
            this.AddButton.setEnabled(false);
        }
    }

    private void ClearButtonActionPerformed(ActionEvent evt) {
        this.clearMutableColumnsList(this.ColList);
        this.clearMutableColumnsList(this.VarList);
        this.ParentSpreadsheet.populateMutableColumnsList(this.ColList);
    }
}

