/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.graph;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.util.SortOrder;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.graph.GraphFactory;
import org.statcato.graph.StatcatoChartFrame;
import org.statcato.spreadsheet.Cell;
import org.statcato.utils.HelperFunctions;

public class PieChartDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JComboBox CategoryComboBox;
    private JComboBox DataComboBox;
    private JComboBox FrequencyComboBox;
    private JCheckBox LabelCheckBox;
    private JCheckBox LegendCheckBox;
    private JButton OKButton;
    private JRadioButton SortCatRadioButton;
    private JRadioButton SortFreqRadioButton;
    private JRadioButton SummaryRadioButton;
    private JTextField TitleTextField;
    private JRadioButton ValuesRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public PieChartDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.SummaryRadioButton);
        group1.add(this.ValuesRadioButton);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.SortCatRadioButton);
        group2.add(this.SortFreqRadioButton);
        this.ParentSpreadsheet.populateComboBox(this.CategoryComboBox);
        this.ParentSpreadsheet.populateComboBox(this.FrequencyComboBox);
        this.ParentSpreadsheet.populateComboBox(this.DataComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("graph-piechart");
        this.name = "Pie Chart";
        this.description = "For creating pie charts, circular charts divided into sectors that show relative frequencies of different categories represented";
        this.helpStrings.add("If summary data of the categories and their corresponding frequencies are present in the datasheet, select Summary Data from Datasheet. Select the column containing categories and the column containing the respective frequencies.");
        this.helpStrings.add("If data values are entered in a single column in the datasheet, select Data Values from Datasheet. Select the column containing data values.");
        this.helpStrings.add("Select whether to sort the pie slices by categories or by frequencies.");
        this.helpStrings.add("To display legends, select the Show Legends check box.");
        this.helpStrings.add("To display values/percentages for each pie sector, select Show Values/Percentages for each Pie Sector.");
        this.pack();
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.CategoryComboBox);
        this.updateComboBox(this.FrequencyComboBox);
        this.updateComboBox(this.DataComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.CategoryComboBox = new JComboBox();
        this.SummaryRadioButton = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.ValuesRadioButton = new JRadioButton();
        this.FrequencyComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.DataComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.LabelCheckBox = new JCheckBox();
        this.LegendCheckBox = new JCheckBox();
        this.SortCatRadioButton = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.TitleTextField = new JTextField();
        this.SortFreqRadioButton = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Pie Chart");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PieChartDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PieChartDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Graph Variables"));
        this.SummaryRadioButton.setSelected(true);
        this.SummaryRadioButton.setText("Summary Data from Worksheet");
        this.SummaryRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PieChartDialog.this.SummaryRadioButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Categories:");
        this.ValuesRadioButton.setText("Data Values from Worksheet");
        this.ValuesRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PieChartDialog.this.ValuesRadioButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Data:");
        this.jLabel3.setEnabled(false);
        this.DataComboBox.setEnabled(false);
        this.jLabel2.setText("Frequencies:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SummaryRadioButton).addGroup(jPanel1Layout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jLabel3)).addComponent(this.ValuesRadioButton).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.DataComboBox, -2, 105, -2).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.FrequencyComboBox, -2, 105, -2).addComponent(this.CategoryComboBox, -2, 105, -2))))).addContainerGap(110, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.SummaryRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.CategoryComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.FrequencyComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ValuesRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.DataComboBox, -2, -1, -2)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Graph Options"));
        this.LabelCheckBox.setSelected(true);
        this.LabelCheckBox.setText("Show Values/Percentages for each Pie Sector");
        this.LegendCheckBox.setSelected(true);
        this.LegendCheckBox.setText("Show Legends");
        this.SortCatRadioButton.setSelected(true);
        this.SortCatRadioButton.setText("Sort by Categories");
        this.jLabel4.setText("Chart Title:");
        this.TitleTextField.setText("Pie Chart");
        this.SortFreqRadioButton.setText("Sort by Frequencies");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 4, -2).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.TitleTextField, -2, 217, -2)).addComponent(this.SortCatRadioButton).addComponent(this.SortFreqRadioButton).addComponent(this.LegendCheckBox).addComponent(this.LabelCheckBox)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.TitleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SortCatRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SortFreqRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LegendCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LabelCheckBox).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(84, 84, 84).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CancelButton).addComponent(this.OKButton)).addGap(31, 31, 31)));
        this.pack();
    }

    private void SummaryRadioButtonActionPerformed(ActionEvent evt) {
        this.CategoryComboBox.setEnabled(true);
        this.FrequencyComboBox.setEnabled(true);
        this.ValuesRadioButton.setEnabled(false);
        this.DataComboBox.setEnabled(false);
    }

    private void ValuesRadioButtonActionPerformed(ActionEvent evt) {
        this.DataComboBox.setEnabled(true);
        this.CategoryComboBox.setEnabled(false);
        this.FrequencyComboBox.setEnabled(false);
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("pie chart");
        DefaultPieDataset data = new DefaultPieDataset();
        String heading = "";
        String text = "";
        if (this.SummaryRadioButton.isSelected()) {
            String freqColumnLabel = this.FrequencyComboBox.getSelectedItem().toString();
            if (freqColumnLabel.equals("")) {
                this.app.showErrorDialog("Select the column containing frequencies.");
                return;
            }
            int freqColumn = this.ParentSpreadsheet.parseColumnNumber(freqColumnLabel);
            Vector<Cell> CellColumnVector = this.ParentSpreadsheet.getColumn(freqColumn);
            Vector<Double> ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(CellColumnVector);
            if (ColumnVector == null) {
                this.app.showErrorDialog("Invalid frequency column " + freqColumnLabel + ": all data must be numbers.");
                return;
            }
            String catColumnLabel = this.CategoryComboBox.getSelectedItem().toString();
            if (catColumnLabel.equals("")) {
                this.app.showErrorDialog("Select the column containing categories.");
                return;
            }
            int catColumn = this.ParentSpreadsheet.parseColumnNumber(catColumnLabel);
            Vector<Cell> CatColumnVector = this.ParentSpreadsheet.getColumn(catColumn);
            Hashtable<String, Double> hash = new Hashtable<String, Double>();
            for (int i = 0; i < CatColumnVector.size(); ++i) {
                String cat = CatColumnVector.elementAt(i).getContents();
                if (cat.equals("")) continue;
                Double freq = ColumnVector.elementAt(i);
                if (freq == null) {
                    this.app.showErrorDialog("Missing frequency for category " + cat);
                    return;
                }
                if (hash.containsKey(cat)) {
                    double f = (Double)hash.get(cat) + freq;
                    hash.put(cat, new Double(f));
                    continue;
                }
                hash.put(cat, freq);
            }
            Enumeration e = hash.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                data.setValue((Comparable)((Object)key), (Double)hash.get(key));
            }
            heading = heading + "Pie Chart";
            text = text + "Categories in " + catColumnLabel + ", frequencies in " + freqColumnLabel;
        } else if (this.ValuesRadioButton.isSelected()) {
            String catColumnLabel = this.DataComboBox.getSelectedItem().toString();
            if (catColumnLabel.equals("")) {
                this.app.showErrorDialog("Select the column containing data values.");
                return;
            }
            int catColumn = this.ParentSpreadsheet.parseColumnNumber(catColumnLabel);
            Vector<Cell> CatColumnVector = this.ParentSpreadsheet.getColumn(catColumn);
            Hashtable<String, Integer> hash = new Hashtable<String, Integer>();
            for (int i = 0; i < CatColumnVector.size(); ++i) {
                String cat = CatColumnVector.elementAt(i).getContents();
                if (cat.equals("")) continue;
                if (hash.containsKey(cat)) {
                    int f = (Integer)hash.get(cat) + 1;
                    hash.put(cat, new Integer(f));
                    continue;
                }
                hash.put(cat, new Integer(1));
            }
            Enumeration e = hash.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                data.setValue((Comparable)((Object)key), (Integer)hash.get(key));
            }
            heading = heading + "Pie Chart";
            text = text + "Data values in " + catColumnLabel;
        }
        if (this.SortCatRadioButton.isSelected()) {
            data.sortByKeys(SortOrder.ASCENDING);
        } else {
            data.sortByValues(SortOrder.ASCENDING);
        }
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        StatcatoChartFrame frame = new StatcatoChartFrame(this.TitleTextField.getText(), GraphFactory.createPieChart(this.TitleTextField.getText(), data, this.LegendCheckBox.isSelected(), this.LabelCheckBox.isSelected()), this.app);
        frame.pack();
        frame.setVisible(true);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

