/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.file;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.statcato.LogWindow;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;

public class PrintLogDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JCheckBox FooterCheckBox;
    private JTextField FooterTextField;
    private JCheckBox HeaderCheckBox;
    private JTextField HeaderTextField;
    private JButton PrintButton;
    private JLabel jLabel1;
    private JPanel jPanel1;

    public PrintLogDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.PrintButton);
        this.setHelpFile("file-menu");
        this.name = "Print Log";
        this.description = "For printing the log window.";
        this.helpStrings.add("Specify the header and footer to be printed along with the contents of the log window.");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.HeaderCheckBox = new JCheckBox();
        this.FooterCheckBox = new JCheckBox();
        this.HeaderTextField = new JTextField();
        this.FooterTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.CancelButton = new JButton();
        this.PrintButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Print Log");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Print Options"));
        this.HeaderCheckBox.setSelected(true);
        this.HeaderCheckBox.setText("Header:");
        this.HeaderCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintLogDialog.this.HeaderCheckBoxActionPerformed(evt);
            }
        });
        this.FooterCheckBox.setSelected(true);
        this.FooterCheckBox.setText("Footer:");
        this.FooterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintLogDialog.this.FooterCheckBoxActionPerformed(evt);
            }
        });
        this.FooterTextField.setText("Page {0}");
        this.jLabel1.setText("- Enter {0} for page number.");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(15, 15, 15).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.HeaderCheckBox).addComponent(this.FooterCheckBox)).addGap(26, 26, 26).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.FooterTextField).addComponent(this.HeaderTextField, -1, 233, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel1))).addContainerGap(19, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(22, 22, 22).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.HeaderCheckBox).addComponent(this.HeaderTextField, -2, 22, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.FooterCheckBox).addComponent(this.FooterTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1).addContainerGap(20, Short.MAX_VALUE)));
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintLogDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.PrintButton.setText("Print");
        this.PrintButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintLogDialog.this.PrintButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(128, 128, 128).addComponent(this.PrintButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.CancelButton))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.PrintButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.PrintButton).addComponent(this.CancelButton)).addContainerGap(23, Short.MAX_VALUE)));
        this.pack();
    }

    private void PrintButtonActionPerformed(ActionEvent evt) {
        LogWindow Text = this.app.getLogTextPane();
        MessageFormat header = null;
        if (this.HeaderCheckBox.isSelected()) {
            header = new MessageFormat(this.HeaderTextField.getText());
        }
        MessageFormat footer = null;
        if (this.FooterCheckBox.isSelected()) {
            footer = new MessageFormat(this.FooterTextField.getText());
        }
        try {
            boolean complete = Text.print(header, footer, true, null, null, true);
            if (complete) {
                JOptionPane.showMessageDialog(this, "Printing Complete", "Printing Result", 1);
            } else {
                JOptionPane.showMessageDialog(this, "Printing Cancelled", "Printing Result", 1);
            }
        }
        catch (PrinterException pe) {
            JOptionPane.showMessageDialog(this, "Printing Failed: " + pe.getMessage(), "Printing Result", 0);
        }
        this.dispose();
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void HeaderCheckBoxActionPerformed(ActionEvent evt) {
        if (this.HeaderCheckBox.isSelected()) {
            this.HeaderTextField.setEnabled(true);
        } else {
            this.HeaderTextField.setEnabled(false);
        }
    }

    private void FooterCheckBoxActionPerformed(ActionEvent evt) {
        if (this.FooterCheckBox.isSelected()) {
            this.FooterTextField.setEnabled(true);
        } else {
            this.FooterTextField.setEnabled(false);
        }
    }
}

