/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.edit;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;

public class AddMultipleRowColDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JButton OKButton;
    private JTextField colsTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField rowsTextField;

    public AddMultipleRowColDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("edit-menu");
        this.name = "Add Multiple Rows and/or Columns";
        this.description = "For adding multiple rows and/or columns to the current datasheet.";
        this.helpStrings.add("Enter the number of rows and columns to be added.");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.rowsTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.colsTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Add Multiple Rows and/or Columns");
        this.jLabel1.setText("Add...");
        this.rowsTextField.setHorizontalAlignment(11);
        this.rowsTextField.setText("0");
        this.jLabel2.setText("rows");
        this.colsTextField.setHorizontalAlignment(11);
        this.colsTextField.setText("0");
        this.jLabel3.setText("columns");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddMultipleRowColDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddMultipleRowColDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(43, 43, 43).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.rowsTextField, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.colsTextField, -1, 68, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.CancelButton).addComponent(this.jLabel3)).addContainerGap(-1, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap(210, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(32, Short.MAX_VALUE).addComponent(this.OKButton).addGap(135, 135, 135)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.linkSize(0, this.colsTextField, this.rowsTextField);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rowsTextField, -2, -1, -2).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.colsTextField, -2, -1, -2).addComponent(this.jLabel3)).addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        try {
            int i;
            int rows = Integer.parseInt(this.rowsTextField.getText());
            int cols = Integer.parseInt(this.colsTextField.getText());
            if (rows < 0 || cols < 0) {
                throw new NumberFormatException();
            }
            for (i = 0; i < rows; ++i) {
                this.ParentSpreadsheet.insertRow();
            }
            for (i = 0; i < cols; ++i) {
                this.ParentSpreadsheet.insertColumn();
            }
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter nonnegative integers for the number rows and columns.");
            return;
        }
        this.dispose();
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

