/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.data;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.random.NormalSample;

public class NormalSampleDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JTextField MeanTextField;
    private JButton OKButton;
    private JTextField SeedTextField;
    private JTextField StdevTextField;
    private JTextField StoreTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField nTextField;

    public NormalSampleDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.app = app;
        this.initComponents();
        this.customInitComponents();
        this.setHelpFile("data-random-normal");
        this.name = "Random Normal Sample";
        this.description = "For generating random samples from a normal distribution.";
        this.helpStrings.add("Specify the column name(s) in which samples will be stored, the sample size, and the mean and standard deviation of the normal distribution.");
    }

    public void customInitComponents() {
        this.getRootPane().setDefaultButton(this.OKButton);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.StoreTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.SeedTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel7 = new JLabel();
        this.StdevTextField = new JTextField();
        this.nTextField = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel6 = new JLabel();
        this.MeanTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Random Normal Sample");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NormalSampleDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NormalSampleDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Results"));
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Store Samples in:");
        this.jLabel5.setText("<html>\n- Enter valid column names separated by space.<br>\nFor a continuous range of columns, separate using dash (e.g. C1-C30).<br>\n- The random sampling process is repeated for each column.\n</html>\n");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.StoreTextField, -2, 218, -2)).addComponent(this.jLabel5, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.StoreTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5, -2, -1, -2).addGap(11, 11, 11)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Options"));
        this.jLabel4.setText("Random Generator Seed (optional):");
        this.jLabel7.setText("Standard Deviation:");
        this.StdevTextField.setText("1");
        this.jLabel8.setFont(new Font("Tahoma", 1, 11));
        this.jLabel8.setText("Normal Distribution");
        this.jLabel1.setText("Number of Samples to Generate:");
        this.jLabel6.setText("Mean:");
        this.MeanTextField.setText("0");
        this.jLabel2.setText("for each column");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel4).addGap(17, 17, 17).addComponent(this.SeedTextField, -2, 77, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGap(25, 25, 25).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.StdevTextField).addComponent(this.MeanTextField, -2, 60, -2))).addComponent(this.jLabel8).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nTextField, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(0, this.MeanTextField, this.StdevTextField);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.nTextField, -2, -1, -2).addComponent(this.jLabel2)).addGap(45, 45, 45).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.MeanTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.StdevTextField, -2, -1, -2)).addGap(43, 43, 43).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.SeedTextField, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(120, 120, 120).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap()));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("normal samples");
        int n = 0;
        double mean = 0.0;
        double stdev = 0.0;
        try {
            n = Integer.parseInt(this.nTextField.getText());
            if (n <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid sample size.");
            return;
        }
        try {
            mean = Double.parseDouble(this.MeanTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid mean value.");
            return;
        }
        try {
            stdev = Double.parseDouble(this.StdevTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid standard deviation.");
            return;
        }
        String StoreColumn = this.StoreTextField.getText();
        Vector<Integer> nums = this.ParentSpreadsheet.getColumnNumbersFromString(StoreColumn);
        if (nums == null) {
            this.app.showErrorDialog("Invalid column(s) for storing results.");
            return;
        }
        for (int i = 0; i < nums.size(); ++i) {
            int storeColumnNum = nums.elementAt(i);
            NormalSample sampler = new NormalSample(mean, stdev);
            try {
                long seed = Long.parseLong(this.SeedTextField.getText());
                sampler.setSeed(seed);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            Vector<String> results = new Vector<String>();
            for (int j = 0; j < n; ++j) {
                double sample = sampler.nextSample();
                results.addElement(sample + "");
            }
            this.ParentSpreadsheet.setColumn(storeColumnNum, results);
        }
        this.app.addLogParagraph("Normal Samples: mean = " + mean + ", stdev = " + stdev, n + " samples stored in each of " + StoreColumn);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

