/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.data;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.random.IntegerSample;

public class IntegerSampleDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JTextField MaxTextField;
    private JTextField MinTextField;
    private JButton OKButton;
    private JTextField SeedTextField;
    private JTextField StoreTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField nTextField;

    public IntegerSampleDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.app = app;
        this.initComponents();
        this.customInitComponents();
        this.setHelpFile("data-random-integer");
        this.name = "Random Integer Samples";
        this.description = "For generating random samples from a range of integer values, each of which having the same probability of being chosen.";
        this.helpStrings.add("Specify the column name(s) in which samples will be stored, the sample size, and the minimum and maximum values of the range of possible values.");
    }

    public void customInitComponents() {
        this.getRootPane().setDefaultButton(this.OKButton);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.StoreTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.SeedTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.MinTextField = new JTextField();
        this.jLabel7 = new JLabel();
        this.nTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.MaxTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Random Integer Samples");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntegerSampleDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntegerSampleDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Results"));
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Store Samples in:");
        this.jLabel5.setText("<html>\n- Enter valid column names separated by space.<br>\nFor a continuous range of columns, separate using dash (e.g. C1-C30).<br>\n- The random sampling process is repeated for each column.\n</html>\n");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.StoreTextField, -2, 218, -2)).addComponent(this.jLabel5, -2, -1, -2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.StoreTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5, -2, -1, -2).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Options"));
        this.jLabel2.setText("for each column");
        this.jLabel4.setText("Random Generator Seed (optional):");
        this.jLabel7.setText("Maximum:");
        this.jLabel6.setText("Minimum:");
        this.jLabel1.setText("Number of Samples to Generate:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.MaxTextField).addGap(321, 321, 321)).addComponent(this.MinTextField, -2, 60, -2))).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel4).addGap(17, 17, 17).addComponent(this.SeedTextField, -2, 77, -2).addContainerGap()).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.nTextField, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addGap(47, 47, 47)))));
        jPanel2Layout.linkSize(0, this.MaxTextField, this.MinTextField);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.nTextField, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.MinTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.MaxTextField, -2, -1, -2)).addGap(30, 30, 30).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.SeedTextField, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(121, 121, 121).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap()));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        String StoreColumn;
        Vector<Integer> nums;
        this.app.compoundEdit = new DialogEdit("integer samples");
        int n = 0;
        int min = 0;
        int max = 0;
        try {
            n = Integer.parseInt(this.nTextField.getText());
            if (n <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid sample size.");
            return;
        }
        try {
            min = Integer.parseInt(this.MinTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid minimum integer value.");
            return;
        }
        try {
            max = Integer.parseInt(this.MaxTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid maximum integer value.");
            return;
        }
        if (min > max) {
            int temp = max;
            max = min;
            min = temp;
        }
        if ((nums = this.ParentSpreadsheet.getColumnNumbersFromString(StoreColumn = this.StoreTextField.getText())) == null) {
            this.app.showErrorDialog("Invalid column(s) for storing results.");
            return;
        }
        if (nums != null) {
            for (int i = 0; i < nums.size(); ++i) {
                int storeColumnNum = nums.elementAt(i);
                IntegerSample sampler = new IntegerSample(min, max);
                try {
                    long seed = Long.parseLong(this.SeedTextField.getText());
                    sampler.setSeed(seed);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                Vector<String> results = new Vector<String>();
                for (int j = 0; j < n; ++j) {
                    int sample = sampler.nextSample();
                    results.addElement(sample + "");
                }
                this.ParentSpreadsheet.setColumn(storeColumnNum, results);
            }
            this.app.addLogParagraph("Integer Samples [" + min + ", " + max + "]", n + " samples stored in each of " + StoreColumn);
            this.app.compoundEdit.end();
            this.app.addCompoundEdit(this.app.compoundEdit);
            this.setVisible(false);
        }
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

