/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.calc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.statistics.ChiSquareProbabilityDistribution;
import org.statcato.statistics.FProbabilityDistribution;
import org.statcato.statistics.NormalProbabilityDistribution;
import org.statcato.statistics.StudentTProbabilityDistribution;
import org.statcato.utils.HelperFunctions;

public class PvalueDialog
extends StatcatoDialog {
    final int normal = 0;
    final int studentT = 1;
    final int chiSquare = 2;
    final int fisher = 3;
    final int leftTail = 0;
    final int rightTail = 1;
    final int twoTail = 2;
    private JButton ClearButton;
    private JTextField DOF1Box;
    private JLabel DOF1ErrorLabel;
    private JLabel DOF1Label;
    private JTextField DOF2Box;
    private JLabel DOF2ErrorLabel;
    private JLabel DOF2Label;
    private JLabel DistributionLabel;
    private JComboBox DistributionMenu;
    private JPanel InputsPanel;
    private JButton OKButton;
    private JPanel ResultsPanel;
    private JLabel ResultsText;
    private JTextField TestStatisticsBox;
    private JLabel TestStatisticsErrorLabel;
    private JLabel TestStatisticsLabel;
    private JLabel TestTypeLabel;
    private JComboBox TestTypeMenu;

    public PvalueDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("calc-pvalue");
        this.name = "p-Value";
        this.description = "For calculating p-values given the type of distribution, distribution parameters, and the type of test.";
        this.helpStrings.add("Select the type of distribution and enter its parameters.");
        this.helpStrings.add("Select the type of test: left-, right-, or two-tailed");
        this.helpStrings.add("Enter the test statistic.");
    }

    private void initComponents() {
        this.InputsPanel = new JPanel();
        this.DistributionLabel = new JLabel();
        this.DistributionMenu = new JComboBox();
        this.TestTypeLabel = new JLabel();
        this.TestTypeMenu = new JComboBox();
        this.TestStatisticsLabel = new JLabel();
        this.TestStatisticsBox = new JTextField();
        this.DOF1Label = new JLabel();
        this.DOF2Label = new JLabel();
        this.DOF1Box = new JTextField();
        this.DOF2Box = new JTextField();
        this.TestStatisticsErrorLabel = new JLabel();
        this.DOF1ErrorLabel = new JLabel();
        this.DOF2ErrorLabel = new JLabel();
        this.ResultsPanel = new JPanel();
        this.ResultsText = new JLabel();
        this.ClearButton = new JButton();
        this.OKButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("p-Value");
        this.setMinimumSize(new Dimension(640, 271));
        this.InputsPanel.setBorder(BorderFactory.createTitledBorder(null, "Inputs", 0, 0, new Font("Tahoma", 1, 14)));
        this.DistributionLabel.setText("Distribution:");
        this.DistributionMenu.setModel(new DefaultComboBoxModel<String>(new String[]{"Normal", "Student's t", "Chi-square", "F (Fisher)"}));
        this.DistributionMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PvalueDialog.this.DistributionMenuItemStateChanged(evt);
            }
        });
        this.TestTypeLabel.setText("Type of Test:");
        this.TestTypeMenu.setModel(new DefaultComboBoxModel<String>(new String[]{"Left-tail", "Right-tail", "Two-tail"}));
        this.TestTypeMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PvalueDialog.this.TestTypeMenuItemStateChanged(evt);
            }
        });
        this.TestStatisticsLabel.setText("Test Statistic:");
        this.TestStatisticsBox.setToolTipText("Enter a valid number");
        this.TestStatisticsBox.setInputVerifier(new TestStatisticsFieldVerifier());
        this.TestStatisticsBox.setMinimumSize(new Dimension(30, 22));
        this.DOF1Label.setText("Degrees of Freedom:");
        this.DOF2Label.setText("Degrees of Freedom 2:");
        this.DOF1Box.setToolTipText("Enter a positive integer");
        this.DOF1Box.setInputVerifier(new DOF1FieldVerifier());
        this.DOF2Box.setToolTipText("Enter a positive integer");
        this.DOF2Box.setInputVerifier(new DOF2FieldVerifier());
        this.TestStatisticsErrorLabel.setBackground(new Color(255, 255, 255));
        this.TestStatisticsErrorLabel.setFont(new Font("Tahoma", 0, 12));
        this.TestStatisticsErrorLabel.setForeground(new Color(255, 0, 0));
        this.TestStatisticsErrorLabel.setText("Enter a valid number");
        this.DOF1ErrorLabel.setBackground(new Color(255, 255, 255));
        this.DOF1ErrorLabel.setFont(new Font("Tahoma", 0, 12));
        this.DOF1ErrorLabel.setForeground(new Color(255, 0, 0));
        this.DOF1ErrorLabel.setText("Enter a positive integer");
        this.DOF2ErrorLabel.setBackground(new Color(255, 255, 255));
        this.DOF2ErrorLabel.setFont(new Font("Tahoma", 0, 12));
        this.DOF2ErrorLabel.setForeground(new Color(255, 0, 0));
        this.DOF2ErrorLabel.setText("Enter a positive integer");
        GroupLayout InputsPanelLayout = new GroupLayout(this.InputsPanel);
        this.InputsPanel.setLayout(InputsPanelLayout);
        InputsPanelLayout.setHorizontalGroup(InputsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(InputsPanelLayout.createSequentialGroup().addGap(15, 15, 15).addGroup(InputsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.DistributionLabel, GroupLayout.Alignment.TRAILING).addComponent(this.TestTypeLabel, GroupLayout.Alignment.TRAILING).addComponent(this.TestStatisticsLabel, GroupLayout.Alignment.TRAILING).addComponent(this.DOF1Label, GroupLayout.Alignment.TRAILING).addComponent(this.DOF2Label, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(InputsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.TestStatisticsBox, -2, 85, -2).addComponent(this.DOF1Box, -2, 86, -2).addComponent(this.DOF2Box, -2, 82, -2).addGroup(InputsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.TestTypeMenu, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.DistributionMenu, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(InputsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.DOF2ErrorLabel).addComponent(this.TestStatisticsErrorLabel).addComponent(this.DOF1ErrorLabel)).addContainerGap(19, Short.MAX_VALUE)));
        InputsPanelLayout.linkSize(0, this.DOF1Box, this.DOF2Box, this.TestStatisticsBox);
        InputsPanelLayout.setVerticalGroup(InputsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(InputsPanelLayout.createSequentialGroup().addContainerGap().addGroup(InputsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.DistributionLabel).addComponent(this.DistributionMenu, -2, -1, -2)).addGap(10, 10, 10).addGroup(InputsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.TestTypeLabel).addComponent(this.TestTypeMenu, -2, -1, -2)).addGap(18, 18, 18).addGroup(InputsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.TestStatisticsLabel).addComponent(this.TestStatisticsErrorLabel).addComponent(this.TestStatisticsBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(InputsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.DOF1Label).addComponent(this.DOF1Box, -2, -1, -2).addComponent(this.DOF1ErrorLabel)).addGap(18, 18, 18).addGroup(InputsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.DOF2Label).addComponent(this.DOF2Box, -2, -1, -2).addComponent(this.DOF2ErrorLabel)).addGap(12, 12, 12)));
        this.DOF1Label.setVisible(false);
        this.DOF2Label.setVisible(false);
        this.DOF1Box.setVisible(false);
        this.DOF2Box.setVisible(false);
        this.TestStatisticsErrorLabel.setVisible(false);
        this.DOF1ErrorLabel.setVisible(false);
        this.DOF2ErrorLabel.setVisible(false);
        this.ResultsPanel.setBorder(BorderFactory.createTitledBorder(null, "Results", 0, 0, new Font("Tahoma", 1, 14)));
        this.ResultsText.setHorizontalAlignment(2);
        this.ResultsText.setText("P-value=");
        this.ResultsText.setVerticalAlignment(1);
        GroupLayout ResultsPanelLayout = new GroupLayout(this.ResultsPanel);
        this.ResultsPanel.setLayout(ResultsPanelLayout);
        ResultsPanelLayout.setHorizontalGroup(ResultsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ResultsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ResultsText, -2, 207, -2).addContainerGap(-1, Short.MAX_VALUE)));
        ResultsPanelLayout.setVerticalGroup(ResultsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ResultsPanelLayout.createSequentialGroup().addComponent(this.ResultsText, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.ResultsPanel.setVisible(false);
        this.ClearButton.setText("Clear");
        this.ClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PvalueDialog.this.ClearButtonActionPerformed(evt);
            }
        });
        this.OKButton.setText("Compute");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PvalueDialog.this.OKButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.InputsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ResultsPanel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(238, 238, 238).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ClearButton))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.ClearButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.InputsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.ResultsPanel, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.ClearButton)).addGap(21, 21, 21)));
        this.pack();
    }

    private void DistributionMenuItemStateChanged(ItemEvent evt) {
        if (evt.getItem() == (String)this.DistributionMenu.getItemAt(0)) {
            this.DOF1Label.setVisible(false);
            this.DOF1Box.setVisible(false);
            this.DOF2Label.setVisible(false);
            this.DOF2Box.setVisible(false);
        } else if (evt.getItem() == (String)this.DistributionMenu.getItemAt(1)) {
            this.DOF1Label.setVisible(true);
            this.DOF1Label.setText("Degrees of Freedom:");
            this.DOF1Box.setVisible(true);
            this.DOF1Box.setText("");
            this.DOF2Label.setVisible(false);
            this.DOF2Box.setVisible(false);
        } else if (evt.getItem() == (String)this.DistributionMenu.getItemAt(2)) {
            this.DOF1Label.setVisible(true);
            this.DOF1Label.setText("Degrees of Freedom:");
            this.DOF1Box.setVisible(true);
            this.DOF1Box.setText("");
            this.DOF2Label.setVisible(false);
            this.DOF2Box.setVisible(false);
        } else {
            this.DOF1Label.setVisible(true);
            this.DOF1Label.setText("Degrees of Freedom 1:");
            this.DOF1Box.setVisible(true);
            this.DOF1Box.setText("");
            this.DOF2Label.setVisible(true);
            this.DOF2Box.setVisible(true);
            this.DOF2Box.setText("");
        }
        this.ResultsPanel.setVisible(false);
        this.pack();
    }

    private void TestTypeMenuItemStateChanged(ItemEvent evt) {
        this.ResultsPanel.setVisible(false);
    }

    private void ClearButtonActionPerformed(ActionEvent evt) {
        this.DistributionMenu.setSelectedIndex(0);
        this.TestTypeMenu.setSelectedIndex(0);
        this.TestStatisticsBox.setText("");
        this.DOF1Box.setVisible(false);
        this.DOF1Box.setText("");
        this.DOF1ErrorLabel.setVisible(false);
        this.DOF1Label.setVisible(false);
        this.DOF2Box.setVisible(false);
        this.DOF2Box.setText("");
        this.DOF2ErrorLabel.setVisible(false);
        this.DOF2Label.setVisible(false);
        this.ResultsPanel.setVisible(false);
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        double pvalue;
        double area;
        this.app.compoundEdit = new DialogEdit("p value");
        double testStatistics = 0.0;
        int dof1 = 0;
        int dof2 = 0;
        boolean inputError = false;
        String results = "";
        String TestStatisticsText = "";
        String DistributionText = "";
        String TestTypeText = "";
        String DOF1Text = "";
        String DOF2Text = "";
        String CumProbText = "";
        String PValueText = "";
        try {
            testStatistics = Double.parseDouble(this.TestStatisticsBox.getText());
            if ((this.DistributionMenu.getSelectedIndex() == 2 || this.DistributionMenu.getSelectedIndex() == 3) && testStatistics < 0.0) {
                inputError = true;
                this.TestStatisticsErrorLabel.setVisible(true);
            }
        }
        catch (NumberFormatException e) {
            inputError = true;
            this.TestStatisticsErrorLabel.setVisible(true);
        }
        if (this.DistributionMenu.getSelectedIndex() == 0) {
            NormalProbabilityDistribution npd = new NormalProbabilityDistribution(0.0, 1.0);
            area = npd.cumulativeProbability(testStatistics);
            DistributionText = DistributionText + "Distribution = Normal<br>";
        } else if (this.DistributionMenu.getSelectedIndex() == 1) {
            try {
                dof1 = Integer.parseInt(this.DOF1Box.getText());
                if (dof1 <= 0) {
                    inputError = true;
                    this.DOF1ErrorLabel.setVisible(true);
                }
            }
            catch (NumberFormatException e) {
                inputError = true;
                this.DOF1ErrorLabel.setVisible(true);
            }
            StudentTProbabilityDistribution dist = new StudentTProbabilityDistribution(dof1);
            area = dist.cumulativeProbability(testStatistics);
            DistributionText = DistributionText + "Distribution = Student's t<br>";
            DOF1Text = DOF1Text + "Degree of freedom = " + dof1 + "<br>";
        } else if (this.DistributionMenu.getSelectedIndex() == 2) {
            try {
                dof1 = Integer.parseInt(this.DOF1Box.getText());
                if (dof1 <= 0) {
                    inputError = true;
                    this.DOF1ErrorLabel.setVisible(true);
                }
            }
            catch (NumberFormatException e) {
                inputError = true;
                this.DOF1ErrorLabel.setVisible(true);
            }
            ChiSquareProbabilityDistribution dist = new ChiSquareProbabilityDistribution(dof1);
            area = dist.cumulativeProbability(testStatistics);
            DistributionText = DistributionText + "Distribution = Chi-square<br>";
            DOF1Text = DOF1Text + "Degree of freedom = " + dof1 + "<br>";
        } else {
            try {
                dof1 = Integer.parseInt(this.DOF1Box.getText());
                if (dof1 <= 0) {
                    inputError = true;
                    this.DOF1ErrorLabel.setVisible(true);
                }
            }
            catch (NumberFormatException e) {
                inputError = true;
                this.DOF1ErrorLabel.setVisible(true);
            }
            try {
                dof2 = Integer.parseInt(this.DOF2Box.getText());
                if (dof2 <= 0) {
                    inputError = true;
                    this.DOF2ErrorLabel.setVisible(true);
                }
            }
            catch (NumberFormatException e) {
                inputError = true;
                this.DOF2ErrorLabel.setVisible(true);
            }
            FProbabilityDistribution dist = new FProbabilityDistribution(dof1, dof2);
            area = dist.cumulativeProbability(testStatistics);
            DistributionText = DistributionText + "Distribution = Fisher<br>";
            DOF1Text = DOF1Text + "Degree of freedom 1 = " + dof1 + "<br>";
            DOF2Text = DOF2Text + "Degree of freedom 2 = " + dof2 + "<br>";
        }
        if (this.TestTypeMenu.getSelectedIndex() == 0) {
            pvalue = area;
            TestTypeText = TestTypeText + "Type of Test = Left-tail<br>";
        } else if (this.TestTypeMenu.getSelectedIndex() == 1) {
            pvalue = 1.0 - area;
            TestTypeText = TestTypeText + "Type of Test = Right-tail<br>";
        } else {
            pvalue = 2.0 * Math.min(area, 1.0 - area);
            TestTypeText = TestTypeText + "Type of Test = Two-tail<br>";
        }
        if (!inputError) {
            TestStatisticsText = TestStatisticsText + "Test Statistic = " + HelperFunctions.formatFloat(testStatistics, 4) + "<br>";
            PValueText = PValueText + "p-Value = ";
            CumProbText = CumProbText + "Cumulative Probability = " + HelperFunctions.formatFloat(area, 4) + "<br>";
            PValueText = this.DistributionMenu.getSelectedIndex() == 0 || this.DistributionMenu.getSelectedIndex() == 1 ? (pvalue == 0.0 ? PValueText + "0+" : PValueText + HelperFunctions.formatFloat(pvalue, 4)) : (testStatistics > 0.0 && pvalue == 0.0 ? PValueText + "0+" : PValueText + HelperFunctions.formatFloat(pvalue, 4));
            results = results + DistributionText + TestTypeText + TestStatisticsText;
            results = results + DOF1Text + DOF2Text + CumProbText + PValueText;
            this.app.addLogParagraph("Computing p-Value", results);
            this.app.compoundEdit.end();
            this.app.addCompoundEdit(this.app.compoundEdit);
            this.ResultsText.setText("<html>" + results + "</html>");
            this.ResultsPanel.setVisible(true);
            this.TestStatisticsErrorLabel.setVisible(false);
            this.DOF1ErrorLabel.setVisible(false);
            this.DOF2ErrorLabel.setVisible(false);
            this.toFront();
            this.setVisible(true);
        }
    }

    class DOF2FieldVerifier
    extends InputVerifier {
        DOF2FieldVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            JTextField tf = (JTextField)input;
            boolean ok = true;
            try {
                int dof = Integer.parseInt(tf.getText());
                PvalueDialog.this.DOF2ErrorLabel.setVisible(false);
                if (dof <= 0) {
                    ok = false;
                    PvalueDialog.this.DOF2ErrorLabel.setVisible(true);
                }
            }
            catch (NumberFormatException e) {
                ok = false;
                PvalueDialog.this.DOF2ErrorLabel.setVisible(true);
            }
            return ok;
        }
    }

    class DOF1FieldVerifier
    extends InputVerifier {
        DOF1FieldVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            JTextField tf = (JTextField)input;
            boolean ok = true;
            try {
                int dof = Integer.parseInt(tf.getText());
                PvalueDialog.this.DOF1ErrorLabel.setVisible(false);
                if (dof <= 0) {
                    ok = false;
                    PvalueDialog.this.DOF1ErrorLabel.setVisible(true);
                }
            }
            catch (NumberFormatException e) {
                ok = false;
                PvalueDialog.this.DOF1ErrorLabel.setVisible(true);
            }
            return ok;
        }
    }

    class TestStatisticsFieldVerifier
    extends InputVerifier {
        TestStatisticsFieldVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            JTextField tf = (JTextField)input;
            boolean ok = true;
            try {
                double ts = Double.parseDouble(tf.getText());
                if (PvalueDialog.this.DistributionMenu.getSelectedIndex() == 2 || PvalueDialog.this.DistributionMenu.getSelectedIndex() == 3) {
                    if (ts < 0.0) {
                        ok = false;
                        PvalueDialog.this.TestStatisticsErrorLabel.setVisible(true);
                    } else {
                        PvalueDialog.this.TestStatisticsErrorLabel.setVisible(false);
                    }
                } else {
                    PvalueDialog.this.TestStatisticsErrorLabel.setVisible(false);
                }
            }
            catch (NumberFormatException e) {
                ok = false;
                PvalueDialog.this.TestStatisticsErrorLabel.setVisible(true);
            }
            return ok;
        }
    }
}

