/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.function;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javolution.context.LocalContext;
import javolution.context.ObjectFactory;
import javolution.lang.Realtime;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.util.FastList;
import org.jscience.mathematics.function.FunctionException;
import org.jscience.mathematics.function.Variable;
import org.jscience.mathematics.structure.GroupAdditive;
import org.jscience.mathematics.structure.GroupMultiplicative;

public abstract class Function<X, Y>
implements Serializable,
Realtime {
    protected Function() {
    }

    public abstract List<Variable<X>> getVariables();

    public abstract Y evaluate();

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public final Variable<X> getVariable(String symbol) {
        for (Variable<X> v : this.getVariables()) {
            if (!symbol.equals(v.getSymbol())) continue;
            return v;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Y evaluate(X arg) {
        List<Variable<X>> vars = this.getVariables();
        if (vars.size() != 1) {
            throw new FunctionException("This function is not monovariate");
        }
        Variable<X> x = vars.get(0);
        Object prev = x.get();
        LocalContext.enter();
        try {
            x.set(arg);
            Y y = this.evaluate();
            return y;
        }
        finally {
            x.set(prev);
            LocalContext.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Y evaluate(X ... args) {
        List<Variable<X>> vars = this.getVariables();
        if (vars.size() != args.length) {
            throw new IllegalArgumentException("Found " + args.length + " arguments, but " + vars.size() + "required");
        }
        LocalContext.enter();
        try {
            Y y = this.evaluate(args, vars, 0);
            return y;
        }
        finally {
            LocalContext.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Y evaluate(X[] args, List<Variable<X>> vars, int i) {
        if (i < args.length) {
            Variable<X> var = vars.get(i);
            Object prev = var.get();
            var.set(args[i]);
            try {
                Y y = this.evaluate(args, vars, i + 1);
                return y;
            }
            finally {
                var.set(prev);
            }
        }
        return this.evaluate();
    }

    public <Z> Function<Z, Y> compose(Function<Z, X> that) {
        if (this.getVariables().size() != 1) {
            throw new FunctionException("This function is not monovariate");
        }
        return Compose.newInstance(this, that);
    }

    public Function<X, Y> differentiate(Variable<X> v) {
        return Derivative.newInstance(this, v);
    }

    public Function<X, Y> integrate(Variable<X> v) {
        return Integral.newInstance(this, v);
    }

    public Function<X, Y> plus(Function<X, Y> that) {
        return Plus.newInstance(this, that);
    }

    public Function<X, Y> minus(Function<X, Y> that) {
        if (that instanceof GroupAdditive) {
            Function thatOpposite = (Function)((GroupAdditive)((Object)that)).opposite();
            return this.plus(thatOpposite);
        }
        return Minus.newInstance(this, that);
    }

    public Function<X, Y> times(Function<X, Y> that) {
        return Times.newInstance(this, that);
    }

    public Function<X, Y> divide(Function<X, Y> that) {
        if (that instanceof GroupMultiplicative) {
            Function thatInverse = (Function)((GroupMultiplicative)((Object)that)).inverse();
            return this.times(thatInverse);
        }
        return Divide.newInstance(this, that);
    }

    public Function<X, Y> pow(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n: " + n + " zero or negative values not allowed");
        }
        Function<X, Y> pow2 = this;
        Function<X, Y> result = null;
        while (n >= 1) {
            if ((n & 1) == 1) {
                result = result == null ? pow2 : result.times(pow2);
            }
            pow2 = pow2.times(pow2);
            n >>>= 1;
        }
        return result;
    }

    @Override
    public abstract Text toText();

    public final String toString() {
        return this.toText().toString();
    }

    static final List merge(List left, List right) {
        if (left.containsAll(right)) {
            return left;
        }
        if (right.containsAll(left)) {
            return right;
        }
        FastList result = FastList.newInstance();
        Iterator iLeft = left.iterator();
        Iterator iRight = right.iterator();
        Variable l = null;
        Variable r = null;
        while (true) {
            if (!iLeft.hasNext()) {
                while (iRight.hasNext()) {
                    result.add(iRight.next());
                }
                return result;
            }
            if (!iRight.hasNext()) {
                while (iLeft.hasNext()) {
                    result.add(iLeft.next());
                }
                return result;
            }
            l = l == null ? (Variable)iLeft.next() : l;
            Variable variable = r = r == null ? (Variable)iRight.next() : r;
            if (l == r) {
                result.add(l);
                l = null;
                r = null;
                continue;
            }
            int comp = l.getSymbol().compareTo(r.getSymbol());
            if (comp < 0) {
                result.add(l);
                l = null;
                continue;
            }
            if (comp <= 0) break;
            result.add(r);
            r = null;
        }
        throw new FunctionException("Duplicate symbol " + l.getSymbol());
    }

    private static final class Divide
    extends Function {
        private static final ObjectFactory<Divide> FACTORY = new ObjectFactory<Divide>(){

            @Override
            protected Divide create() {
                return new Divide();
            }

            @Override
            protected void cleanup(Divide divide) {
                divide._f = null;
                divide._g = null;
            }
        };
        private Function _f;
        private Function _g;
        private static final long serialVersionUID = 1L;

        private Divide() {
        }

        public static <X, Y> Function<X, Y> newInstance(Function f, Function g) {
            Divide divide = FACTORY.object();
            divide._f = f;
            divide._g = g;
            return divide;
        }

        public List getVariables() {
            return Divide.merge(this._f.getVariables(), this._g.getVariables());
        }

        public Object evaluate() {
            Object y2 = this._g.evaluate();
            if (!(y2 instanceof GroupMultiplicative)) {
                throw new FunctionException(y2.getClass() + " is not a multiplicative group");
            }
            y2 = ((GroupMultiplicative)y2).inverse();
            Object y1 = this._f.evaluate();
            if (!(y1 instanceof GroupMultiplicative)) {
                throw new FunctionException(y1.getClass() + " is not a multiplicative group");
            }
            return ((GroupMultiplicative)y1).times(y2);
        }

        public Function differentiate(Variable v) {
            Function fd = this._f.differentiate(v);
            Function gd = this._g.differentiate(v);
            return fd.minus(this._f.divide(this._g).times(gd)).divide(this._g);
        }

        @Override
        public Text toText() {
            return TextBuilder.newInstance().append('(').append(this._f).append(")").append('/').append('(').append(this._g).append(')').toText();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Divide)) {
                return false;
            }
            Divide that = (Divide)obj;
            return this._f.equals(that._f) && this._g.equals(that._g);
        }

        @Override
        public int hashCode() {
            return this._f.hashCode() + this._g.hashCode();
        }
    }

    private static final class Times
    extends Function {
        private static final ObjectFactory<Times> FACTORY = new ObjectFactory<Times>(){

            @Override
            protected Times create() {
                return new Times();
            }

            @Override
            protected void cleanup(Times times) {
                times._f = null;
                times._g = null;
            }
        };
        private Function _f;
        private Function _g;
        private static final long serialVersionUID = 1L;

        private Times() {
        }

        public static <X, Y> Function<X, Y> newInstance(Function f, Function g) {
            Times times = FACTORY.object();
            times._f = f;
            times._g = g;
            return times;
        }

        public List getVariables() {
            return Times.merge(this._f.getVariables(), this._g.getVariables());
        }

        public Object evaluate() {
            Object y2 = this._g.evaluate();
            Object y1 = this._f.evaluate();
            if (!(y1 instanceof GroupMultiplicative)) {
                throw new FunctionException(y1.getClass() + " is not a multiplicative group");
            }
            return ((GroupMultiplicative)y1).times(y2);
        }

        public Function differentiate(Variable v) {
            Function fd = this._f.differentiate(v);
            Function gd = this._g.differentiate(v);
            return fd.times(this._g).plus(this._f.times(gd));
        }

        @Override
        public Text toText() {
            return TextBuilder.newInstance().append('(').append(this._f).append(")").append('\u00b7').append('(').append(this._g).append(')').toText();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Times)) {
                return false;
            }
            Times that = (Times)obj;
            return this._f.equals(that._f) && this._g.equals(that._g);
        }

        @Override
        public int hashCode() {
            return this._f.hashCode() + this._g.hashCode();
        }
    }

    private static final class Minus
    extends Function {
        private static final ObjectFactory<Minus> FACTORY = new ObjectFactory<Minus>(){

            @Override
            protected Minus create() {
                return new Minus();
            }

            @Override
            protected void cleanup(Minus minus) {
                minus._f = null;
                minus._g = null;
            }
        };
        private Function _f;
        private Function _g;
        private static final long serialVersionUID = 1L;

        private Minus() {
        }

        public static <X, Y> Function<X, Y> newInstance(Function f, Function g) {
            Minus minus = FACTORY.object();
            minus._f = f;
            minus._g = g;
            return minus;
        }

        public List getVariables() {
            return Minus.merge(this._f.getVariables(), this._g.getVariables());
        }

        public Object evaluate() {
            Object y2 = this._g.evaluate();
            if (!(y2 instanceof GroupAdditive)) {
                throw new FunctionException(y2.getClass() + " is not an additive group");
            }
            y2 = ((GroupAdditive)y2).opposite();
            Object y1 = this._f.evaluate();
            if (!(y1 instanceof GroupAdditive)) {
                throw new FunctionException(y1.getClass() + " is not an additive group");
            }
            return ((GroupAdditive)y1).plus(y2);
        }

        public Function differentiate(Variable v) {
            return this._f.differentiate(v).minus(this._g.differentiate(v));
        }

        public Function integrate(Variable v) {
            return this._f.integrate(v).minus(this._g.integrate(v));
        }

        @Override
        public Text toText() {
            return TextBuilder.newInstance().append('(').append(this._f).append(")").append('-').append('(').append(this._g).append(')').toText();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Minus)) {
                return false;
            }
            Minus that = (Minus)obj;
            return this._f.equals(that._f) && this._g.equals(that._g);
        }

        @Override
        public int hashCode() {
            return this._f.hashCode() + this._g.hashCode();
        }
    }

    private static final class Plus
    extends Function {
        private static final ObjectFactory<Plus> FACTORY = new ObjectFactory<Plus>(){

            @Override
            protected Plus create() {
                return new Plus();
            }

            @Override
            protected void cleanup(Plus plus) {
                plus._f = null;
                plus._g = null;
            }
        };
        private Function _f;
        private Function _g;
        private static final long serialVersionUID = 1L;

        private Plus() {
        }

        public static <X, Y> Function<X, Y> newInstance(Function f, Function g) {
            Plus plus = FACTORY.object();
            plus._f = f;
            plus._g = g;
            return plus;
        }

        public List getVariables() {
            return Plus.merge(this._f.getVariables(), this._g.getVariables());
        }

        public Object evaluate() {
            Object y2 = this._g.evaluate();
            Object y1 = this._f.evaluate();
            if (!(y1 instanceof GroupAdditive)) {
                throw new FunctionException(y1.getClass() + " is not an additive group");
            }
            return ((GroupAdditive)y1).plus(y2);
        }

        public Function differentiate(Variable v) {
            return this._f.differentiate(v).plus(this._g.differentiate(v));
        }

        public Function integrate(Variable v) {
            return this._f.integrate(v).plus(this._g.integrate(v));
        }

        @Override
        public Text toText() {
            return TextBuilder.newInstance().append('(').append(this._f).append(")").append('+').append('(').append(this._g).append(')').toText();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Plus)) {
                return false;
            }
            Plus that = (Plus)obj;
            return this._f.equals(that._f) && this._g.equals(that._g);
        }

        @Override
        public int hashCode() {
            return this._f.hashCode() + this._g.hashCode();
        }
    }

    private static final class Integral
    extends Function {
        private static final ObjectFactory<Integral> FACTORY = new ObjectFactory<Integral>(){

            @Override
            protected Integral create() {
                return new Integral();
            }

            @Override
            protected void cleanup(Integral integral) {
                integral._f = null;
                integral._v = null;
            }
        };
        private Function _f;
        private Variable _v;
        private static final long serialVersionUID = 1L;

        private Integral() {
        }

        public static <X, Y> Function<X, Y> newInstance(Function f, Variable v) {
            Integral integral = FACTORY.object();
            integral._f = f;
            integral._v = v;
            return integral;
        }

        public List getVariables() {
            return this._f.getVariables();
        }

        public Object evaluate() {
            throw new FunctionException("Integral of " + this._f + " undefined");
        }

        @Override
        public Text toText() {
            return TextBuilder.newInstance().append("S[").append(this._f).append("\u00b7d").append(this._v.getSymbol()).append(']').toText();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Integral)) {
                return false;
            }
            Integral that = (Integral)obj;
            return this._f.equals(that._f) && this._v.equals(that._v);
        }

        @Override
        public int hashCode() {
            return this._f.hashCode() + this._v.hashCode();
        }
    }

    private static final class Derivative
    extends Function {
        private static final ObjectFactory<Derivative> FACTORY = new ObjectFactory<Derivative>(){

            @Override
            protected Derivative create() {
                return new Derivative();
            }

            @Override
            protected void cleanup(Derivative derivative) {
                derivative._f = null;
                derivative._v = null;
            }
        };
        private Function _f;
        private Variable _v;
        private static final long serialVersionUID = 1L;

        private Derivative() {
        }

        public static <X, Y> Function<X, Y> newInstance(Function f, Variable v) {
            Derivative derivative = FACTORY.object();
            derivative._f = f;
            derivative._v = v;
            return derivative;
        }

        public List getVariables() {
            return this._f.getVariables();
        }

        public Object evaluate() {
            throw new FunctionException("Derivative of " + this._f + " undefined");
        }

        @Override
        public Text toText() {
            return TextBuilder.newInstance().append("d[").append(this._f).append("]/d").append(this._v.getSymbol()).toText();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Derivative)) {
                return false;
            }
            Derivative that = (Derivative)obj;
            return this._f.equals(that._f) && this._v.equals(that._v);
        }

        @Override
        public int hashCode() {
            return this._f.hashCode() + this._v.hashCode();
        }
    }

    private static final class Compose
    extends Function {
        private static final ObjectFactory<Compose> FACTORY = new ObjectFactory<Compose>(){

            @Override
            protected Compose create() {
                return new Compose();
            }

            @Override
            protected void cleanup(Compose compose) {
                compose._f = null;
                compose._g = null;
            }
        };
        private Function _f;
        private Function _g;
        private static final long serialVersionUID = 1L;

        private Compose() {
        }

        public static <X, Y> Function<X, Y> newInstance(Function f, Function g) {
            Compose compose = FACTORY.object();
            compose._f = f;
            compose._g = g;
            return compose;
        }

        public List getVariables() {
            return this._g.getVariables();
        }

        public Object evaluate() {
            return this.evaluate(this._g.evaluate());
        }

        public Function differentiate(Variable v) {
            Function fd = this._f.differentiate(v);
            Function gd = this._g.differentiate(v);
            return fd.compose(this._g).times(gd);
        }

        @Override
        public Text toText() {
            return TextBuilder.newInstance().append('(').append(this._f).append(')').append('o').append('(').append(this._g).append(')').toText();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Compose)) {
                return false;
            }
            Compose that = (Compose)obj;
            return this._f.equals(that._f) && this._g.equals(that._g);
        }

        @Override
        public int hashCode() {
            return this._f.hashCode() + this._g.hashCode();
        }
    }
}

