/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.geography.coordinates.crs;

import java.util.Collection;
import java.util.Set;
import javax.measure.unit.SI;
import org.jscience.geography.coordinates.Coordinates;
import org.jscience.geography.coordinates.crs.CoordinateReferenceSystem;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.util.InternationalString;

public abstract class GeocentricCRS<C extends Coordinates<?>>
extends CoordinateReferenceSystem<C> {
    public static final CoordinateSystem XYZ_CS = new CoordinateSystem(){
        CoordinateReferenceSystem.Axis xAxis = new CoordinateReferenceSystem.Axis("Geocentric X", "X", SI.METRE, AxisDirection.GEOCENTRIC_X);
        CoordinateReferenceSystem.Axis yAxis = new CoordinateReferenceSystem.Axis("Geocentric Y", "Y", SI.METRE, AxisDirection.GEOCENTRIC_Y);
        CoordinateReferenceSystem.Axis zAxis = new CoordinateReferenceSystem.Axis("Geocentric Z", "Z", SI.METRE, AxisDirection.GEOCENTRIC_Z);

        public int getDimension() {
            return 3;
        }

        public CoordinateSystemAxis getAxis(int dimension) throws IndexOutOfBoundsException {
            if (dimension == 0) {
                return this.xAxis;
            }
            if (dimension == 1) {
                return this.yAxis;
            }
            if (dimension == 2) {
                return this.zAxis;
            }
            throw new IndexOutOfBoundsException();
        }

        public Identifier getName() {
            throw new UnsupportedOperationException();
        }

        public Collection<String> getAlias() {
            return CoordinateReferenceSystem.EMPTY_SET;
        }

        public Set<String> getIdentifiers() {
            return CoordinateReferenceSystem.EMPTY_SET;
        }

        public InternationalString getRemarks() {
            throw new UnsupportedOperationException();
        }

        public String toWKT() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    };
}

