/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.truetype;

import java.io.IOException;
import org.jfree.fonts.io.FontDataInputSource;
import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontIdentifier;
import org.jfree.fonts.registry.FontRecord;
import org.jfree.fonts.truetype.FontHeaderTable;
import org.jfree.fonts.truetype.NameTable;
import org.jfree.fonts.truetype.OS2Table;
import org.jfree.fonts.truetype.TrueTypeFont;
import org.jfree.fonts.truetype.TrueTypeFontIdentifier;

public class TrueTypeFontRecord
implements FontRecord {
    private String fontFile;
    private int collectionIndex;
    private long offset;
    private boolean bold;
    private boolean italics;
    private boolean oblique;
    private FontFamily family;
    private boolean embeddable;
    private FontIdentifier identifier;
    private String name;
    private String variant;
    private String[] allNames;
    private String[] allVariants;
    private FontDataInputSource fontInputSource;

    public TrueTypeFontRecord(TrueTypeFont trueTypeFont, FontFamily family) throws IOException {
        if (trueTypeFont == null) {
            throw new NullPointerException("The font must not be null");
        }
        if (family == null) {
            throw new NullPointerException("The font-family must not be null");
        }
        this.family = family;
        this.collectionIndex = trueTypeFont.getCollectionIndex();
        this.offset = trueTypeFont.getOffset();
        this.fontFile = trueTypeFont.getFilename();
        this.fontInputSource = trueTypeFont.getInputSource();
        OS2Table table = (OS2Table)trueTypeFont.getTable(1330851634L);
        if (table != null) {
            this.embeddable = !table.isRestricted();
        }
        NameTable nameTable = (NameTable)trueTypeFont.getTable(1851878757L);
        this.name = nameTable.getPrimaryName(4);
        this.allNames = nameTable.getAllNames(4);
        this.variant = nameTable.getPrimaryName(2);
        this.allVariants = nameTable.getAllNames(2);
        FontHeaderTable headTable = (FontHeaderTable)trueTypeFont.getTable(1751474532L);
        this.bold = headTable.isBold();
        if (this.variant.toLowerCase().indexOf("oblique") >= 0) {
            this.oblique = true;
            this.italics = false;
        } else {
            this.oblique = this.italics = headTable.isItalic();
        }
        this.identifier = new TrueTypeFontIdentifier(this.fontFile, this.name, this.variant, this.collectionIndex, this.offset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrueTypeFontRecord that = (TrueTypeFontRecord)o;
        if (this.bold != that.bold) {
            return false;
        }
        if (this.embeddable != that.embeddable) {
            return false;
        }
        if (this.italics != that.italics) {
            return false;
        }
        if (this.oblique != that.oblique) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.variant.equals(that.variant);
    }

    public String[] getAllNames() {
        return (String[])this.allNames.clone();
    }

    public String[] getAllVariants() {
        return (String[])this.allVariants.clone();
    }

    public int getCollectionIndex() {
        return this.collectionIndex;
    }

    public FontFamily getFamily() {
        return this.family;
    }

    public String getFontFile() {
        return this.fontFile;
    }

    public FontDataInputSource getFontInputSource() {
        return this.fontInputSource;
    }

    public FontIdentifier getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getVariant() {
        return this.variant;
    }

    public int hashCode() {
        int result = this.bold ? 1 : 0;
        result = 29 * result + (this.italics ? 1 : 0);
        result = 29 * result + (this.oblique ? 1 : 0);
        result = 29 * result + (this.embeddable ? 1 : 0);
        result = 29 * result + this.name.hashCode();
        result = 29 * result + this.variant.hashCode();
        return result;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isEmbeddable() {
        return this.embeddable;
    }

    public boolean isItalic() {
        return this.italics;
    }

    public boolean isOblique() {
        return this.oblique;
    }
}

