/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.truetype;

import org.jfree.fonts.registry.FontMetrics;
import org.jfree.fonts.truetype.ScalableTrueTypeFontMetrics;

public class TrueTypeFontMetrics
implements FontMetrics {
    private ScalableTrueTypeFontMetrics fontMetrics;
    private double fontSize;

    public TrueTypeFontMetrics(ScalableTrueTypeFontMetrics fontMetrics, double fontSize) {
        if (fontMetrics == null) {
            throw new NullPointerException("The font must not be null");
        }
        this.fontMetrics = fontMetrics;
        this.fontSize = fontSize;
    }

    public double getAscent() {
        return this.fontSize * this.fontMetrics.getAscent();
    }

    public double getCharWidth(char character) {
        return 0.0;
    }

    public double getCharWidthWithKerning(char previous, char character) {
        return 0.0;
    }

    public double getDescent() {
        return this.fontSize * this.fontMetrics.getDescent();
    }

    public double getLeading() {
        return this.fontSize * this.fontMetrics.getLeading();
    }

    public double getMaxAscent() {
        return 0.0;
    }

    public double getMaxCharAdvance() {
        return 0.0;
    }

    public double getMaxDescent() {
        return 0.0;
    }

    public double getMaxLeading() {
        return 0.0;
    }

    public double getOverlinePosition() {
        return this.fontSize * this.fontMetrics.getOverlinePosition();
    }

    public double getStrikeThroughPosition() {
        return this.fontSize * this.fontMetrics.getStrikeThroughPosition();
    }

    public double getUnderlinePosition() {
        return this.fontSize * this.fontMetrics.getUnderlinePosition();
    }

    public double getXHeight() {
        return this.fontSize * this.fontMetrics.getXHeight();
    }
}

