/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.awt;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import org.jfree.fonts.registry.FontContext;
import org.jfree.fonts.registry.FontMetrics;

public class AWTFontMetrics
implements FontMetrics {
    private Font font;
    private FontContext context;
    private java.awt.FontMetrics fontMetrics;
    private Graphics2D graphics;

    public AWTFontMetrics(Font font, FontContext context) {
        this.font = font;
        this.context = context;
        FontRenderContext frc = new FontRenderContext(null, context.isAntiAliased(), context.isFractionalMetrics());
        Graphics2D graphics = this.getGraphics(frc);
        this.fontMetrics = graphics.getFontMetrics(font);
    }

    public double getAscent() {
        return this.fontMetrics.getAscent();
    }

    public double getCharWidth(char character) {
        return 0.0;
    }

    public double getCharWidthWithKerning(char previous, char character) {
        return 0.0;
    }

    public double getDescent() {
        return this.fontMetrics.getDescent();
    }

    public Font getFont() {
        return this.font;
    }

    protected Graphics2D getGraphics(FontRenderContext frc) {
        if (this.graphics == null) {
            BufferedImage image = new BufferedImage(1, 1, 2);
            Graphics2D g2 = image.createGraphics();
            if (this.context.isAntiAliased()) {
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (this.context.isFractionalMetrics()) {
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            this.graphics = g2;
        }
        return this.graphics;
    }

    public double getLeading() {
        return this.fontMetrics.getLeading();
    }

    public double getMaxAscent() {
        return 0.0;
    }

    public double getMaxCharAdvance() {
        return 0.0;
    }

    public double getMaxDescent() {
        return 0.0;
    }

    public double getMaxLeading() {
        return 0.0;
    }

    public double getOverlinePosition() {
        return 0.0;
    }

    public double getStrikeThroughPosition() {
        return 0.0;
    }

    public double getUnderlinePosition() {
        return 0.0;
    }

    public double getXHeight() {
        return (double)this.fontMetrics.getAscent() * 0.7;
    }
}

